/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.parse.ASTConstantHelper;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.spec.AnnotationDesc;
import com.espertech.esper.util.JavaClassHelper;
import java.util.ArrayList;
import org.antlr.runtime.tree.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTAnnotationHelper {
    public static AnnotationDesc walk(Tree node, EngineImportService engineImportService) throws ASTWalkException {
        String name = node.getChild(0).getText();
        ArrayList<Pair<String, Object>> values = new ArrayList<Pair<String, Object>>();
        for (int i = 1; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() == 228) {
                Pair<String, Object> entry = ASTAnnotationHelper.walkValuePair(node.getChild(i), engineImportService);
                values.add(new Pair<String, Object>(entry.getFirst(), entry.getSecond()));
                continue;
            }
            if (node.getChild(i).getType() == 130) {
                Object enumValue = ASTAnnotationHelper.walkClassIdent(node.getChild(i), engineImportService);
                values.add(new Pair<String, Object>("value", enumValue));
                continue;
            }
            Object value = ASTAnnotationHelper.walkValue(node.getChild(i));
            values.add(new Pair<String, Object>("value", value));
        }
        return new AnnotationDesc(name, values);
    }

    private static Object walkValue(Tree child) {
        return ASTConstantHelper.parse(child);
    }

    private static Pair<String, Object> walkValuePair(Tree node, EngineImportService engineImportService) {
        String name = node.getChild(0).getText();
        if (node.getChild(1).getType() == 227) {
            Object[] values = ASTAnnotationHelper.walkArray(node.getChild(1));
            return new Pair<String, Object[]>(name, values);
        }
        if (node.getChild(1).getType() == 226) {
            AnnotationDesc anno = ASTAnnotationHelper.walk(node.getChild(1), engineImportService);
            return new Pair<String, Object>(name, anno);
        }
        if (node.getChild(1).getType() == 130) {
            Object enumValue = ASTAnnotationHelper.walkClassIdent(node.getChild(1), engineImportService);
            return new Pair<String, Object>(name, enumValue);
        }
        Object constant = ASTConstantHelper.parse(node.getChild(1));
        return new Pair<String, Object>(name, constant);
    }

    private static Object walkClassIdent(Tree child, EngineImportService engineImportService) {
        Object enumValue;
        String enumValueText = child.getText();
        try {
            enumValue = JavaClassHelper.resolveIdentAsEnumConst(enumValueText, null, engineImportService);
        }
        catch (ExprValidationException e) {
            throw new ASTWalkException("Annotation value '" + enumValueText + "' is not recognized as an enumeration value, please check imports or use a primitive or string type");
        }
        if (enumValue != null) {
            return enumValue;
        }
        throw new ASTWalkException("Annotation enumeration value '" + enumValueText + "' not recognized as an enumeration class, please check imports or type used");
    }

    private static Object[] walkArray(Tree node) {
        Object[] values = new Object[node.getChildCount()];
        for (int i = 0; i < node.getChildCount(); ++i) {
            values[i] = ASTAnnotationHelper.walkValue(node.getChild(i));
        }
        return values;
    }
}

