/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.parse.ASTConstantHelper;
import com.espertech.esper.epl.parse.ASTWalkException;
import com.espertech.esper.epl.parse.EPLTreeWalker;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitRateType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.spec.RowLimitSpec;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.type.IntValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTOutputLimitHelper {
    public static OutputLimitSpec buildOutputLimitSpec(Tree node, Map<Tree, ExprNode> astExprNodeMap, VariableService variableService, String engineURI, TimeProvider timeProvider, ExprEvaluatorContext exprEvaluatorContext) {
        int count = 0;
        Tree child = node.getChild(count);
        OutputLimitLimitType displayLimit = OutputLimitLimitType.DEFAULT;
        if (child.getType() == 52) {
            displayLimit = OutputLimitLimitType.FIRST;
            child = node.getChild(++count);
        } else if (child.getType() == 53) {
            displayLimit = OutputLimitLimitType.LAST;
            child = node.getChild(++count);
        } else if (child.getType() == 77) {
            displayLimit = OutputLimitLimitType.SNAPSHOT;
            child = node.getChild(++count);
        } else if (child.getType() == 47) {
            displayLimit = OutputLimitLimitType.ALL;
            child = node.getChild(++count);
        }
        String variableName = null;
        double rate = -1.0;
        ExprNode whenExpression = null;
        ArrayList<ExprNode> crontabScheduleSpec = null;
        List<OnTriggerSetAssignment> thenExpressions = null;
        ExprTimePeriod timePeriodExpr = null;
        if (node.getType() == 170) {
            Tree expressionNode = node.getChild(count);
            whenExpression = astExprNodeMap.remove(expressionNode);
            if (node.getChildCount() > count + 1) {
                thenExpressions = EPLTreeWalker.getOnTriggerSetAssignments(node.getChild(1), astExprNodeMap);
            }
        } else if (node.getType() == 168) {
            Tree parent = node.getChild(0);
            if (parent.getType() != 169) {
                parent = node.getChild(1);
            }
            crontabScheduleSpec = new ArrayList<ExprNode>(parent.getChildCount());
            for (int i = 0; i < parent.getChildCount(); ++i) {
                crontabScheduleSpec.add(astExprNodeMap.remove(parent.getChild(i)));
            }
        } else if (node.getType() != 167) {
            if (child.getType() == 255) {
                variableName = child.getText();
            } else if (child.getType() == 176) {
                ExprNode expression = astExprNodeMap.remove(child);
                try {
                    timePeriodExpr = (ExprTimePeriod)expression.getValidatedSubtree(new StreamTypeServiceImpl(engineURI), null, null, timeProvider, variableService, exprEvaluatorContext);
                }
                catch (ExprValidationException ex) {
                    throw new ASTWalkException("Invalid time period expresion: " + ex.getMessage(), ex);
                }
            } else {
                rate = Double.parseDouble(child.getText());
            }
        }
        ExprTimePeriod afterTimePeriodExpr = null;
        Integer afterNumberOfEvents = null;
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (node.getChild(i).getType() != 106) continue;
            ExprNode expression = astExprNodeMap.remove(node.getChild(i).getChild(0));
            if (expression != null) {
                try {
                    afterTimePeriodExpr = (ExprTimePeriod)expression.getValidatedSubtree(new StreamTypeServiceImpl(engineURI), null, null, timeProvider, variableService, exprEvaluatorContext);
                    continue;
                }
                catch (ExprValidationException ex) {
                    throw new ASTWalkException("Invalid time period expresion: " + ex.getMessage(), ex);
                }
            }
            Object constant = ASTConstantHelper.parse(node.getChild(i).getChild(0));
            afterNumberOfEvents = ((Number)constant).intValue();
        }
        switch (node.getType()) {
            case 165: {
                return new OutputLimitSpec(rate, variableName, OutputLimitRateType.EVENTS, displayLimit, null, null, null, null, afterTimePeriodExpr, afterNumberOfEvents);
            }
            case 166: {
                return new OutputLimitSpec(null, null, OutputLimitRateType.TIME_PERIOD, displayLimit, null, null, null, timePeriodExpr, afterTimePeriodExpr, afterNumberOfEvents);
            }
            case 168: {
                return new OutputLimitSpec(null, null, OutputLimitRateType.CRONTAB, displayLimit, null, null, crontabScheduleSpec, null, afterTimePeriodExpr, afterNumberOfEvents);
            }
            case 170: {
                return new OutputLimitSpec(null, null, OutputLimitRateType.WHEN_EXPRESSION, displayLimit, whenExpression, thenExpressions, null, null, afterTimePeriodExpr, afterNumberOfEvents);
            }
            case 167: {
                return new OutputLimitSpec(null, null, OutputLimitRateType.AFTER, displayLimit, null, null, null, null, afterTimePeriodExpr, afterNumberOfEvents);
            }
        }
        throw new IllegalArgumentException("Node type " + node.getType() + " not a recognized output limit type");
    }

    public static RowLimitSpec buildRowLimitSpec(Tree node) {
        Object offset;
        Object numRows;
        if (node.getChildCount() == 1) {
            numRows = ASTOutputLimitHelper.parseNumOrVariableIdent(node.getChild(0));
            offset = null;
        } else if (node.getChild(node.getChildCount() - 1).getType() == 254) {
            offset = ASTOutputLimitHelper.parseNumOrVariableIdent(node.getChild(0));
            numRows = ASTOutputLimitHelper.parseNumOrVariableIdent(node.getChild(1));
        } else {
            numRows = ASTOutputLimitHelper.parseNumOrVariableIdent(node.getChild(0));
            offset = ASTOutputLimitHelper.parseNumOrVariableIdent(node.getChild(1));
        }
        Integer numRowsInt = null;
        String numRowsVariable = null;
        if (numRows instanceof String) {
            numRowsVariable = (String)numRows;
        } else {
            numRowsInt = (Integer)numRows;
        }
        Integer offsetInt = null;
        String offsetVariable = null;
        if (offset instanceof String) {
            offsetVariable = (String)offset;
        } else {
            offsetInt = (Integer)offset;
        }
        return new RowLimitSpec(numRowsInt, offsetInt, numRowsVariable, offsetVariable);
    }

    private static Object parseNumOrVariableIdent(Tree child) {
        if (child.getType() == 255) {
            return child.getText();
        }
        return IntValue.parseString(child.getText());
    }
}

