/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.parse;

import com.espertech.esper.client.EPStatementSyntaxException;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.epl.generated.EsperEPL2Ast;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import java.util.Set;
import java.util.Stack;
import org.antlr.runtime.EarlyExitException;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.Token;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionConvertor {
    public static EPStatementSyntaxException convertStatement(RecognitionException e, String expression, boolean addPleaseCheck, EsperEPL2GrammarParser parser2) {
        UniformPair<String> pair = ExceptionConvertor.convert(e, expression, addPleaseCheck, parser2);
        return new EPStatementSyntaxException(pair.getFirst(), pair.getSecond());
    }

    public static PropertyAccessException convertProperty(RecognitionException e, String expression, boolean addPleaseCheck, EsperEPL2GrammarParser parser2) {
        UniformPair<String> pair = ExceptionConvertor.convert(e, expression, addPleaseCheck, parser2);
        return new PropertyAccessException(pair.getFirst(), pair.getSecond());
    }

    public static UniformPair<String> convert(RecognitionException e, String expression, boolean addPleaseCheck, EsperEPL2GrammarParser parser2) {
        Set<String> keywords;
        Token t;
        if (expression.trim().length() == 0) {
            String message = "Unexpected end of input";
            return new UniformPair<String>(message, expression);
        }
        Token tBefore = null;
        Token tAfter = null;
        if (e.index < parser2.getTokenStream().size()) {
            t = parser2.getTokenStream().get(e.index);
            if (e.index + 1 < parser2.getTokenStream().size()) {
                tAfter = parser2.getTokenStream().get(e.index + 1);
            }
            if (e.index - 1 >= 0) {
                tBefore = parser2.getTokenStream().get(e.index - 1);
            }
        } else {
            t = parser2.getTokenStream().get(parser2.getTokenStream().size() - 1);
        }
        String positionInfo = ExceptionConvertor.getPositionInfo(t);
        String token2 = "'" + t.getText() + "'";
        Stack stack = parser2.getParaphrases();
        String check = "";
        if (stack.size() > 0 && addPleaseCheck) {
            String delimiter = "";
            StringBuilder checkList = new StringBuilder();
            checkList.append(", please check the ");
            while (stack.size() != 0) {
                checkList.append(delimiter);
                checkList.append(stack.pop());
                delimiter = " within the ";
            }
            check = checkList.toString();
        }
        if ((keywords = parser2.getKeywords()).contains(token2.toLowerCase())) {
            token2 = token2 + " (a reserved keyword)";
        } else if (tBefore != null && tAfter != null && keywords.contains("'" + tBefore.getText().toLowerCase() + "'") && keywords.contains("'" + tAfter.getText().toLowerCase() + "'")) {
            token2 = token2 + " ('" + tBefore.getText() + "' and '" + tAfter.getText() + "' are a reserved keyword)";
        } else if (tBefore != null && keywords.contains("'" + tBefore.getText().toLowerCase() + "'")) {
            token2 = token2 + " ('" + tBefore.getText() + "' is a reserved keyword)";
        }
        String message = "Incorrect syntax near " + token2 + positionInfo + check;
        if (e instanceof NoViableAltException) {
            NoViableAltException nvae = (NoViableAltException)e;
            if (nvae.token.getType() == -1) {
                message = "Unexpected end of input near " + token2 + positionInfo + check;
            } else if (parser2.getParserTokenParaphrases().get(nvae.token.getType()) != null) {
                message = "Incorrect syntax near " + token2 + positionInfo + check;
            } else {
                for (int currentIndex = e.index + 1; currentIndex > 0 && currentIndex < parser2.getTokenStream().size() - 1 && currentIndex < e.index + 3; ++currentIndex) {
                    Token next = parser2.getTokenStream().get(currentIndex);
                    String quotedToken = "'" + next.getText() + "'";
                    if (!parser2.getKeywords().contains(quotedToken)) continue;
                    check = check + " near reserved keyword '" + next.getText() + "'";
                    break;
                }
                message = "Incorrect syntax near " + token2 + positionInfo + check;
            }
        }
        if (e instanceof MismatchedTokenException) {
            MismatchedTokenException mismatched = (MismatchedTokenException)e;
            String expected = "end of input";
            if (mismatched.expecting >= 0 && mismatched.expecting < parser2.getTokenNames().length) {
                expected = parser2.getTokenNames()[mismatched.expecting];
            }
            if (parser2.getLexerTokenParaphrases().get(mismatched.expecting) != null) {
                expected = parser2.getLexerTokenParaphrases().get(mismatched.expecting);
            }
            if (parser2.getParserTokenParaphrases().get(mismatched.expecting) != null) {
                expected = parser2.getParserTokenParaphrases().get(mismatched.expecting);
            }
            String unexpected = mismatched.getUnexpectedType() < 0 || mismatched.getUnexpectedType() >= parser2.getTokenNames().length ? "end of input" : parser2.getTokenNames()[mismatched.getUnexpectedType()];
            if (parser2.getLexerTokenParaphrases().get(mismatched.getUnexpectedType()) != null) {
                unexpected = parser2.getLexerTokenParaphrases().get(mismatched.getUnexpectedType());
            }
            if (parser2.getParserTokenParaphrases().get(mismatched.getUnexpectedType()) != null) {
                unexpected = parser2.getParserTokenParaphrases().get(mismatched.getUnexpectedType());
            }
            String expecting = " expecting " + expected.trim() + " but found " + unexpected.trim();
            message = "Incorrect syntax near " + token2 + expecting + positionInfo + check;
        }
        if (e instanceof EarlyExitException) {
            EarlyExitException ee = (EarlyExitException)e;
            char c = (char)ee.c;
            message = "Incorrect syntax near " + token2 + positionInfo + " unexpected character '" + c + "', check for an invalid identifier";
        }
        return new UniformPair<String>(message, expression);
    }

    public static EPStatementSyntaxException convert(RecognitionException e, String expression, EsperEPL2Ast treeWalker) {
        String positionInfo = ExceptionConvertor.getPositionInfo(e.token);
        String tokenName = "end of input";
        if (e.token != null && e.token.getType() >= 0 && e.token.getType() < treeWalker.getTokenNames().length) {
            tokenName = treeWalker.getTokenNames()[e.token.getType()];
        }
        String message = "Unexpected error processing statement near token " + tokenName + positionInfo;
        if (e instanceof MismatchedTokenException) {
            MismatchedTokenException mismatched = (MismatchedTokenException)e;
            String expected = "end of input";
            if (mismatched.expecting >= 0 && mismatched.expecting < treeWalker.getTokenNames().length) {
                expected = treeWalker.getTokenNames()[mismatched.expecting];
            }
            String unexpected = mismatched.getUnexpectedType() < 0 || mismatched.getUnexpectedType() >= treeWalker.getTokenNames().length ? "end of input" : treeWalker.getTokenNames()[mismatched.getUnexpectedType()];
            String expecting = " expecting " + expected.trim() + " but found " + unexpected.trim();
            message = "Unexpected error processing statement near token " + tokenName + expecting + positionInfo;
        }
        return new EPStatementSyntaxException(message, expression);
    }

    private static String getPositionInfo(Token t) {
        return t.getLine() > 0 && t.getCharPositionInLine() > 0 ? " at line " + t.getLine() + " column " + t.getCharPositionInLine() : "";
    }
}

