/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec;

import com.espertech.esper.epl.expression.ExprAndNode;
import com.espertech.esper.epl.expression.ExprEqualsNode;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.type.OuterJoinType;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;

public class OuterJoinDesc
implements MetaDefItem,
Serializable {
    private OuterJoinType outerJoinType;
    private ExprIdentNode leftNode;
    private ExprIdentNode rightNode;
    private ExprIdentNode[] addLeftNode;
    private ExprIdentNode[] addRightNode;
    private static final long serialVersionUID = -2616847070429124382L;

    public OuterJoinDesc(OuterJoinType outerJoinType, ExprIdentNode leftNode, ExprIdentNode rightNode, ExprIdentNode[] addLeftNode, ExprIdentNode[] addRightNode) {
        this.outerJoinType = outerJoinType;
        this.leftNode = leftNode;
        this.rightNode = rightNode;
        this.addLeftNode = addLeftNode;
        this.addRightNode = addRightNode;
    }

    public OuterJoinType getOuterJoinType() {
        return this.outerJoinType;
    }

    public ExprIdentNode getLeftNode() {
        return this.leftNode;
    }

    public ExprIdentNode getRightNode() {
        return this.rightNode;
    }

    public ExprIdentNode[] getAdditionalLeftNodes() {
        return this.addLeftNode;
    }

    public ExprIdentNode[] getAdditionalRightNodes() {
        return this.addRightNode;
    }

    public ExprNode makeExprNode(ExprEvaluatorContext exprEvaluatorContext) {
        ExprNode representativeNode = new ExprEqualsNode(false);
        representativeNode.addChildNode(this.leftNode);
        representativeNode.addChildNode(this.rightNode);
        if (this.addLeftNode != null) {
            ExprAndNode andNode = new ExprAndNode();
            andNode.addChildNode(representativeNode);
            representativeNode = andNode;
            for (int i = 0; i < this.addLeftNode.length; ++i) {
                ExprEqualsNode eqNode = new ExprEqualsNode(false);
                eqNode.addChildNode(this.addLeftNode[i]);
                eqNode.addChildNode(this.addRightNode[i]);
                andNode.addChildNode(eqNode);
            }
        }
        try {
            representativeNode.validate(null, null, null, null, null, exprEvaluatorContext);
        }
        catch (ExprValidationException e) {
            throw new IllegalStateException("Failed to make representative node for outer join criteria");
        }
        return representativeNode;
    }
}

