/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.core.StreamTypeService;
import com.espertech.esper.epl.core.StreamTypeServiceImpl;
import com.espertech.esper.epl.core.ViewResourceDelegate;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.expression.ExprValidationPropertyException;
import com.espertech.esper.epl.property.PropertyEvaluator;
import com.espertech.esper.epl.property.PropertyEvaluatorFactory;
import com.espertech.esper.epl.spec.FilterStreamSpecRaw;
import com.espertech.esper.epl.spec.PatternStreamSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecBase;
import com.espertech.esper.epl.spec.StreamSpecCompiled;
import com.espertech.esper.epl.spec.StreamSpecOptions;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.filter.FilterSpecCompiler;
import com.espertech.esper.pattern.EvalEveryDistinctNode;
import com.espertech.esper.pattern.EvalFilterNode;
import com.espertech.esper.pattern.EvalGuardNode;
import com.espertech.esper.pattern.EvalMatchUntilNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNodeAnalysisResult;
import com.espertech.esper.pattern.EvalObserverNode;
import com.espertech.esper.pattern.MatchedEventConvertorImpl;
import com.espertech.esper.pattern.PatternObjectException;
import com.espertech.esper.pattern.guard.GuardFactory;
import com.espertech.esper.pattern.guard.GuardParameterException;
import com.espertech.esper.pattern.observer.ObserverFactory;
import com.espertech.esper.pattern.observer.ObserverParameterException;
import com.espertech.esper.schedule.TimeProvider;
import com.espertech.esper.util.UuidGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternStreamSpecRaw
extends StreamSpecBase
implements StreamSpecRaw {
    private final EvalNode evalNode;
    private static final long serialVersionUID = 6393401926404401433L;

    public PatternStreamSpecRaw(EvalNode evalNode, List<ViewSpec> viewSpecs, String optionalStreamName, StreamSpecOptions streamSpecOptions) {
        super(optionalStreamName, viewSpecs, streamSpecOptions);
        this.evalNode = evalNode;
    }

    public EvalNode getEvalNode() {
        return this.evalNode;
    }

    @Override
    public StreamSpecCompiled compile(StatementContext context, Set<String> eventTypeReferences, boolean isInsertInto) throws ExprValidationException {
        MatchEventSpec tags = new MatchEventSpec();
        PatternStreamSpecRaw.recursiveCompile(this.evalNode, context, eventTypeReferences, isInsertInto, tags);
        return new PatternStreamSpecCompiled(this.evalNode, tags.getTaggedEventTypes(), tags.getArrayEventTypes(), this.getViewSpecs(), this.getOptionalStreamName(), this.getOptions());
    }

    private static void recursiveCompile(EvalNode evalNode, StatementContext context, Set<String> eventTypeReferences, boolean isInsertInto, MatchEventSpec tags) throws ExprValidationException {
        for (EvalNode child : evalNode.getChildNodes()) {
            PatternStreamSpecRaw.recursiveCompile(child, context, eventTypeReferences, isInsertInto, tags);
        }
        LinkedHashMap<String, Pair<EventType, String>> newTaggedEventTypes = null;
        LinkedHashMap<String, Pair<EventType, String>> newArrayEventTypes = null;
        if (evalNode instanceof EvalFilterNode) {
            String selfStreamName;
            EventType resolvedEventType;
            EvalFilterNode filterNode = (EvalFilterNode)evalNode;
            String eventName = filterNode.getRawFilterSpec().getEventTypeName();
            EventType finalEventType = resolvedEventType = FilterStreamSpecRaw.resolveType(context.getEngineURI(), eventName, context.getEventAdapterService(), context.getPlugInTypeResolutionURIs());
            String optionalTag = filterNode.getEventAsName();
            boolean isPropertyEvaluation = false;
            if (filterNode.getRawFilterSpec().getOptionalPropertyEvalSpec() != null) {
                PropertyEvaluator optionalPropertyEvaluator = PropertyEvaluatorFactory.makeEvaluator(filterNode.getRawFilterSpec().getOptionalPropertyEvalSpec(), resolvedEventType, filterNode.getEventAsName(), context.getEventAdapterService(), context.getMethodResolutionService(), context.getSchedulingService(), context.getVariableService(), context.getEngineURI());
                finalEventType = optionalPropertyEvaluator.getFragmentEventType();
                isPropertyEvaluation = true;
            }
            if (finalEventType instanceof EventTypeSPI) {
                eventTypeReferences.add(((EventTypeSPI)finalEventType).getMetadata().getPrimaryName());
            }
            if (optionalTag != null) {
                Pair<EventType, String> pair = tags.getTaggedEventTypes().get(optionalTag);
                EventType existingType = null;
                if (pair != null) {
                    existingType = pair.getFirst();
                }
                if (existingType == null && (pair = tags.getArrayEventTypes().get(optionalTag)) != null) {
                    throw new ExprValidationException("Tag '" + optionalTag + "' for event '" + eventName + "' used in the repeat-until operator cannot also appear in other filter expressions");
                }
                if (existingType != null && existingType != finalEventType) {
                    throw new ExprValidationException("Tag '" + optionalTag + "' for event '" + eventName + "' has already been declared for events of type " + existingType.getUnderlyingType().getName());
                }
                pair = new Pair<EventType, String>(finalEventType, eventName);
                if (isPropertyEvaluation) {
                    newArrayEventTypes = new LinkedHashMap<String, Pair<EventType, String>>();
                    newArrayEventTypes.put(optionalTag, pair);
                } else {
                    newTaggedEventTypes = new LinkedHashMap<String, Pair<EventType, String>>();
                    newTaggedEventTypes.put(optionalTag, pair);
                }
            }
            if ((selfStreamName = optionalTag) == null) {
                selfStreamName = "s_" + UuidGenerator.generate();
            }
            LinkedHashMap<String, Pair<EventType, String>> filterTypes = new LinkedHashMap<String, Pair<EventType, String>>();
            Pair<EventType, String> typePair = new Pair<EventType, String>(finalEventType, eventName);
            filterTypes.put(selfStreamName, typePair);
            filterTypes.putAll(tags.getTaggedEventTypes());
            LinkedHashMap<String, Pair<EventType, String>> filterTaggedEventTypes = new LinkedHashMap<String, Pair<EventType, String>>(tags.getTaggedEventTypes());
            filterTaggedEventTypes.remove(optionalTag);
            LinkedHashMap<String, Pair<EventType, String>> arrayCompositeEventTypes = null;
            if (tags.getArrayEventTypes() != null) {
                arrayCompositeEventTypes = new LinkedHashMap<String, Pair<EventType, String>>();
                EventType arrayTagCompositeEventType = context.getEventAdapterService().createSemiAnonymousMapType(new HashMap<String, Pair<EventType, String>>(), tags.getArrayEventTypes(), isInsertInto);
                for (Map.Entry<String, Pair<EventType, String>> entry : tags.getArrayEventTypes().entrySet()) {
                    String tag = entry.getKey();
                    if (filterTypes.containsKey(tag)) continue;
                    Pair<EventType, String> pair = new Pair<EventType, String>(arrayTagCompositeEventType, tag);
                    filterTypes.put(tag, pair);
                    arrayCompositeEventTypes.put(tag, pair);
                }
            }
            StreamTypeServiceImpl streamTypeService = new StreamTypeServiceImpl(filterTypes, context.getEngineURI(), true, false);
            List<ExprNode> exprNodes = filterNode.getRawFilterSpec().getFilterExpressions();
            FilterSpecCompiled spec = FilterSpecCompiler.makeFilterSpec(resolvedEventType, eventName, exprNodes, filterNode.getRawFilterSpec().getOptionalPropertyEvalSpec(), filterTaggedEventTypes, arrayCompositeEventTypes, streamTypeService, context.getMethodResolutionService(), context.getSchedulingService(), context.getVariableService(), context.getEventAdapterService(), context.getEngineURI(), null, context);
            filterNode.setFilterSpec(spec);
        } else {
            if (evalNode instanceof EvalObserverNode) {
                EvalObserverNode observerNode = (EvalObserverNode)evalNode;
                try {
                    ObserverFactory observerFactory = context.getPatternResolutionService().create(observerNode.getPatternObserverSpec());
                    StreamTypeService streamTypeService = PatternStreamSpecRaw.getStreamTypeService(context.getEngineURI(), context.getEventAdapterService(), tags.taggedEventTypes, tags.arrayEventTypes);
                    List<ExprNode> validated = PatternStreamSpecRaw.validateExpressions(observerNode.getPatternObserverSpec().getObjectParameters(), streamTypeService, context.getMethodResolutionService(), null, context.getSchedulingService(), context.getVariableService(), context);
                    MatchedEventConvertorImpl convertor = new MatchedEventConvertorImpl(tags.taggedEventTypes, tags.arrayEventTypes, context.getEventAdapterService());
                    observerNode.setObserverFactory(observerFactory);
                    observerFactory.setObserverParameters(validated, convertor);
                }
                catch (ObserverParameterException e) {
                    throw new ExprValidationException("Invalid parameter for pattern observer: " + e.getMessage(), e);
                }
                catch (PatternObjectException e) {
                    throw new ExprValidationException("Failed to resolve pattern observer: " + e.getMessage(), e);
                }
            }
            if (evalNode instanceof EvalGuardNode) {
                EvalGuardNode guardNode = (EvalGuardNode)evalNode;
                try {
                    GuardFactory guardFactory = context.getPatternResolutionService().create(guardNode.getPatternGuardSpec());
                    StreamTypeService streamTypeService = PatternStreamSpecRaw.getStreamTypeService(context.getEngineURI(), context.getEventAdapterService(), tags.taggedEventTypes, tags.arrayEventTypes);
                    List<ExprNode> validated = PatternStreamSpecRaw.validateExpressions(guardNode.getPatternGuardSpec().getObjectParameters(), streamTypeService, context.getMethodResolutionService(), null, context.getSchedulingService(), context.getVariableService(), context);
                    MatchedEventConvertorImpl convertor = new MatchedEventConvertorImpl(tags.taggedEventTypes, tags.arrayEventTypes, context.getEventAdapterService());
                    guardNode.setGuardFactory(guardFactory);
                    guardFactory.setGuardParameters(validated, convertor);
                }
                catch (GuardParameterException e) {
                    throw new ExprValidationException("Invalid parameter for pattern guard: " + e.getMessage(), e);
                }
                catch (PatternObjectException e) {
                    throw new ExprValidationException("Failed to resolve pattern guard: " + e.getMessage(), e);
                }
            }
            if (evalNode instanceof EvalEveryDistinctNode) {
                List<ExprNode> validated;
                EvalEveryDistinctNode distinctNode = (EvalEveryDistinctNode)evalNode;
                MatchEventSpec matchEventFromChildNodes = PatternStreamSpecRaw.analyzeMatchEvent(distinctNode);
                StreamTypeService streamTypeService = PatternStreamSpecRaw.getStreamTypeService(context.getEngineURI(), context.getEventAdapterService(), matchEventFromChildNodes.getTaggedEventTypes(), matchEventFromChildNodes.getArrayEventTypes());
                try {
                    validated = PatternStreamSpecRaw.validateExpressions(distinctNode.getExpressions(), streamTypeService, context.getMethodResolutionService(), null, context.getSchedulingService(), context.getVariableService(), context);
                }
                catch (ExprValidationPropertyException ex) {
                    throw new ExprValidationPropertyException(ex.getMessage() + ", every-distinct requires that all properties resolve from sub-expressions to the every-distinct", ex.getCause());
                }
                MatchedEventConvertorImpl convertor = new MatchedEventConvertorImpl(matchEventFromChildNodes.getTaggedEventTypes(), matchEventFromChildNodes.getArrayEventTypes(), context.getEventAdapterService());
                distinctNode.setConvertor(convertor);
                distinctNode.setExpressions(validated);
            } else if (evalNode instanceof EvalMatchUntilNode) {
                EvalMatchUntilNode matchUntilNode = (EvalMatchUntilNode)evalNode;
                HashSet<String> arrayTags = null;
                EvalNodeAnalysisResult matchUntilAnalysisResult = EvalNode.recursiveAnalyzeChildNodes(matchUntilNode.getChildNodes().get(0));
                for (EvalFilterNode filterNode : matchUntilAnalysisResult.getFilterNodes()) {
                    String optionalTag = filterNode.getEventAsName();
                    if (optionalTag == null) continue;
                    if (arrayTags == null) {
                        arrayTags = new HashSet<String>();
                    }
                    arrayTags.add(optionalTag);
                }
                if (arrayTags != null) {
                    for (String arrayTag : arrayTags) {
                        if (tags.arrayEventTypes.containsKey(arrayTag)) continue;
                        tags.arrayEventTypes.put(arrayTag, tags.taggedEventTypes.get(arrayTag));
                        tags.taggedEventTypes.remove(arrayTag);
                    }
                }
                matchUntilNode.setTagsArrayedSet((Set<String>)arrayTags);
            }
        }
        if (newTaggedEventTypes != null) {
            tags.getTaggedEventTypes().putAll(newTaggedEventTypes);
        }
        if (newArrayEventTypes != null) {
            tags.getArrayEventTypes().putAll(newArrayEventTypes);
        }
    }

    private static List<ExprNode> validateExpressions(List<ExprNode> objectParameters, StreamTypeService streamTypeService, MethodResolutionService methodResolutionService, ViewResourceDelegate viewResourceDelegate, TimeProvider timeProvider, VariableService variableService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        if (objectParameters == null) {
            return objectParameters;
        }
        ArrayList<ExprNode> validated = new ArrayList<ExprNode>();
        for (ExprNode node : objectParameters) {
            validated.add(node.getValidatedSubtree(streamTypeService, methodResolutionService, viewResourceDelegate, timeProvider, variableService, exprEvaluatorContext));
        }
        return validated;
    }

    private static StreamTypeService getStreamTypeService(String engineURI, EventAdapterService eventAdapterService, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes) {
        LinkedHashMap<String, Pair<EventType, String>> filterTypes = new LinkedHashMap<String, Pair<EventType, String>>();
        filterTypes.putAll(taggedEventTypes);
        if (arrayEventTypes != null) {
            EventType arrayTagCompositeEventType = eventAdapterService.createSemiAnonymousMapType(new HashMap<String, Pair<EventType, String>>(), arrayEventTypes, false);
            for (Map.Entry<String, Pair<EventType, String>> entry : arrayEventTypes.entrySet()) {
                String tag = entry.getKey();
                if (filterTypes.containsKey(tag)) continue;
                Pair<EventType, String> pair = new Pair<EventType, String>(arrayTagCompositeEventType, tag);
                filterTypes.put(tag, pair);
            }
        }
        return new StreamTypeServiceImpl(filterTypes, engineURI, true, false);
    }

    private static MatchEventSpec analyzeMatchEvent(EvalNode relativeNode) {
        LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes = new LinkedHashMap<String, Pair<EventType, String>>();
        LinkedHashMap arrayEventTypes = new LinkedHashMap();
        EvalNodeAnalysisResult evalNodeAnalysisResult = EvalNode.recursiveAnalyzeChildNodes(relativeNode);
        for (EvalFilterNode filterNode : evalNodeAnalysisResult.getFilterNodes()) {
            String optionalTag = filterNode.getEventAsName();
            if (optionalTag == null) continue;
            taggedEventTypes.put(optionalTag, new Pair<EventType, String>(filterNode.getFilterSpec().getFilterForEventType(), filterNode.getFilterSpec().getFilterForEventTypeName()));
        }
        HashSet<String> arrayTags = new HashSet<String>();
        for (EvalMatchUntilNode matchUntilNode : evalNodeAnalysisResult.getRepeatNodes()) {
            EvalNodeAnalysisResult matchUntilAnalysisResult = EvalNode.recursiveAnalyzeChildNodes(matchUntilNode.getChildNodes().get(0));
            for (EvalFilterNode filterNode : matchUntilAnalysisResult.getFilterNodes()) {
                String optionalTag = filterNode.getEventAsName();
                if (optionalTag == null) continue;
                arrayTags.add(optionalTag);
            }
        }
        for (String arrayTag : arrayTags) {
            if (taggedEventTypes.get(arrayTag) == null) continue;
            arrayEventTypes.put(arrayTag, taggedEventTypes.get(arrayTag));
            taggedEventTypes.remove(arrayTag);
        }
        return new MatchEventSpec(taggedEventTypes, arrayEventTypes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MatchEventSpec {
        private final LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes;
        private final LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes;

        private MatchEventSpec(LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes) {
            this.taggedEventTypes = taggedEventTypes;
            this.arrayEventTypes = arrayEventTypes;
        }

        public MatchEventSpec() {
            this.taggedEventTypes = new LinkedHashMap();
            this.arrayEventTypes = new LinkedHashMap();
        }

        public LinkedHashMap<String, Pair<EventType, String>> getArrayEventTypes() {
            return this.arrayEventTypes;
        }

        public LinkedHashMap<String, Pair<EventType, String>> getTaggedEventTypes() {
            return this.taggedEventTypes;
        }
    }
}

