/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.spec;

import com.espertech.esper.client.ConfigurationInformation;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.soda.AnnotationAttribute;
import com.espertech.esper.client.soda.AnnotationPart;
import com.espertech.esper.client.soda.ArithmaticExpression;
import com.espertech.esper.client.soda.ArrayExpression;
import com.espertech.esper.client.soda.AssignmentPair;
import com.espertech.esper.client.soda.AvedevProjectionExpression;
import com.espertech.esper.client.soda.AvgProjectionExpression;
import com.espertech.esper.client.soda.BetweenExpression;
import com.espertech.esper.client.soda.BitwiseOpExpression;
import com.espertech.esper.client.soda.CaseSwitchExpression;
import com.espertech.esper.client.soda.CaseWhenThenExpression;
import com.espertech.esper.client.soda.CastExpression;
import com.espertech.esper.client.soda.CoalesceExpression;
import com.espertech.esper.client.soda.CompareListExpression;
import com.espertech.esper.client.soda.ConcatExpression;
import com.espertech.esper.client.soda.Conjunction;
import com.espertech.esper.client.soda.ConstantExpression;
import com.espertech.esper.client.soda.ContainedEventSelect;
import com.espertech.esper.client.soda.CountProjectionExpression;
import com.espertech.esper.client.soda.CountStarProjectionExpression;
import com.espertech.esper.client.soda.CreateIndexClause;
import com.espertech.esper.client.soda.CreateVariableClause;
import com.espertech.esper.client.soda.CreateWindowClause;
import com.espertech.esper.client.soda.CrontabFrequencyExpression;
import com.espertech.esper.client.soda.CrontabParameterExpression;
import com.espertech.esper.client.soda.CrontabParameterSetExpression;
import com.espertech.esper.client.soda.CrontabRangeExpression;
import com.espertech.esper.client.soda.CurrentTimestampExpression;
import com.espertech.esper.client.soda.Disjunction;
import com.espertech.esper.client.soda.EPStatementObjectModel;
import com.espertech.esper.client.soda.Expression;
import com.espertech.esper.client.soda.Filter;
import com.espertech.esper.client.soda.FilterStream;
import com.espertech.esper.client.soda.FirstProjectionExpression;
import com.espertech.esper.client.soda.FromClause;
import com.espertech.esper.client.soda.GroupByClause;
import com.espertech.esper.client.soda.InExpression;
import com.espertech.esper.client.soda.InsertIntoClause;
import com.espertech.esper.client.soda.InstanceOfExpression;
import com.espertech.esper.client.soda.LastProjectionExpression;
import com.espertech.esper.client.soda.LikeExpression;
import com.espertech.esper.client.soda.MatchRecogizePatternElementType;
import com.espertech.esper.client.soda.MatchRecognizeClause;
import com.espertech.esper.client.soda.MatchRecognizeDefine;
import com.espertech.esper.client.soda.MatchRecognizeIntervalClause;
import com.espertech.esper.client.soda.MatchRecognizeRegEx;
import com.espertech.esper.client.soda.MatchRecognizeRegExAlteration;
import com.espertech.esper.client.soda.MatchRecognizeRegExAtom;
import com.espertech.esper.client.soda.MatchRecognizeRegExConcatenation;
import com.espertech.esper.client.soda.MatchRecognizeRegExNested;
import com.espertech.esper.client.soda.MatchRecognizeSkipClause;
import com.espertech.esper.client.soda.MaxProjectionExpression;
import com.espertech.esper.client.soda.MaxRowExpression;
import com.espertech.esper.client.soda.MedianProjectionExpression;
import com.espertech.esper.client.soda.MethodInvocationStream;
import com.espertech.esper.client.soda.MinProjectionExpression;
import com.espertech.esper.client.soda.MinRowExpression;
import com.espertech.esper.client.soda.NotExpression;
import com.espertech.esper.client.soda.OnClause;
import com.espertech.esper.client.soda.OnDeleteClause;
import com.espertech.esper.client.soda.OnInsertSplitStreamClause;
import com.espertech.esper.client.soda.OnInsertSplitStreamItem;
import com.espertech.esper.client.soda.OnSelectClause;
import com.espertech.esper.client.soda.OnSetClause;
import com.espertech.esper.client.soda.OnUpdateClause;
import com.espertech.esper.client.soda.OrderByClause;
import com.espertech.esper.client.soda.OrderByElement;
import com.espertech.esper.client.soda.OrderedObjectParamExpression;
import com.espertech.esper.client.soda.OuterJoinQualifier;
import com.espertech.esper.client.soda.OutputLimitClause;
import com.espertech.esper.client.soda.OutputLimitSelector;
import com.espertech.esper.client.soda.OutputLimitUnit;
import com.espertech.esper.client.soda.PatternAndExpr;
import com.espertech.esper.client.soda.PatternEveryDistinctExpr;
import com.espertech.esper.client.soda.PatternEveryExpr;
import com.espertech.esper.client.soda.PatternExpr;
import com.espertech.esper.client.soda.PatternFilterExpr;
import com.espertech.esper.client.soda.PatternFollowedByExpr;
import com.espertech.esper.client.soda.PatternGuardExpr;
import com.espertech.esper.client.soda.PatternMatchUntilExpr;
import com.espertech.esper.client.soda.PatternNotExpr;
import com.espertech.esper.client.soda.PatternObserverExpr;
import com.espertech.esper.client.soda.PatternOrExpr;
import com.espertech.esper.client.soda.PatternStream;
import com.espertech.esper.client.soda.PlugInProjectionExpression;
import com.espertech.esper.client.soda.PreviousExpression;
import com.espertech.esper.client.soda.PriorExpression;
import com.espertech.esper.client.soda.ProjectedStream;
import com.espertech.esper.client.soda.PropertyExistsExpression;
import com.espertech.esper.client.soda.PropertyValueExpression;
import com.espertech.esper.client.soda.PropertyValueExpressionPair;
import com.espertech.esper.client.soda.RegExpExpression;
import com.espertech.esper.client.soda.RelationalOpExpression;
import com.espertech.esper.client.soda.RowLimitClause;
import com.espertech.esper.client.soda.SQLStream;
import com.espertech.esper.client.soda.ScheduleItemType;
import com.espertech.esper.client.soda.SelectClause;
import com.espertech.esper.client.soda.SelectClauseElement;
import com.espertech.esper.client.soda.SelectClauseExpression;
import com.espertech.esper.client.soda.SelectClauseStreamWildcard;
import com.espertech.esper.client.soda.SelectClauseWildcard;
import com.espertech.esper.client.soda.StaticMethodExpression;
import com.espertech.esper.client.soda.StddevProjectionExpression;
import com.espertech.esper.client.soda.Stream;
import com.espertech.esper.client.soda.StreamSelector;
import com.espertech.esper.client.soda.SubqueryExistsExpression;
import com.espertech.esper.client.soda.SubqueryExpression;
import com.espertech.esper.client.soda.SubqueryInExpression;
import com.espertech.esper.client.soda.SubqueryQualifiedExpression;
import com.espertech.esper.client.soda.SumProjectionExpression;
import com.espertech.esper.client.soda.TimePeriodExpression;
import com.espertech.esper.client.soda.UpdateClause;
import com.espertech.esper.client.soda.View;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.agg.AggregationSupport;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.expression.ExprAndNode;
import com.espertech.esper.epl.expression.ExprArrayNode;
import com.espertech.esper.epl.expression.ExprAvedevNode;
import com.espertech.esper.epl.expression.ExprAvgNode;
import com.espertech.esper.epl.expression.ExprBetweenNode;
import com.espertech.esper.epl.expression.ExprBitWiseNode;
import com.espertech.esper.epl.expression.ExprCaseNode;
import com.espertech.esper.epl.expression.ExprCastNode;
import com.espertech.esper.epl.expression.ExprCoalesceNode;
import com.espertech.esper.epl.expression.ExprConcatNode;
import com.espertech.esper.epl.expression.ExprConstantNode;
import com.espertech.esper.epl.expression.ExprCountNode;
import com.espertech.esper.epl.expression.ExprEqualsAllAnyNode;
import com.espertech.esper.epl.expression.ExprEqualsNode;
import com.espertech.esper.epl.expression.ExprFirstNode;
import com.espertech.esper.epl.expression.ExprIdentNode;
import com.espertech.esper.epl.expression.ExprInNode;
import com.espertech.esper.epl.expression.ExprInstanceofNode;
import com.espertech.esper.epl.expression.ExprLastNode;
import com.espertech.esper.epl.expression.ExprLeavingAggNode;
import com.espertech.esper.epl.expression.ExprLikeNode;
import com.espertech.esper.epl.expression.ExprMathNode;
import com.espertech.esper.epl.expression.ExprMedianNode;
import com.espertech.esper.epl.expression.ExprMinMaxAggrNode;
import com.espertech.esper.epl.expression.ExprMinMaxRowNode;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNotNode;
import com.espertech.esper.epl.expression.ExprNthAggNode;
import com.espertech.esper.epl.expression.ExprNumberSetCronParam;
import com.espertech.esper.epl.expression.ExprNumberSetFrequency;
import com.espertech.esper.epl.expression.ExprNumberSetList;
import com.espertech.esper.epl.expression.ExprNumberSetRange;
import com.espertech.esper.epl.expression.ExprNumberSetWildcard;
import com.espertech.esper.epl.expression.ExprOrNode;
import com.espertech.esper.epl.expression.ExprOrderedExpr;
import com.espertech.esper.epl.expression.ExprPlugInAggFunctionNode;
import com.espertech.esper.epl.expression.ExprPreviousNode;
import com.espertech.esper.epl.expression.ExprPriorNode;
import com.espertech.esper.epl.expression.ExprPropertyExistsNode;
import com.espertech.esper.epl.expression.ExprRateAggNode;
import com.espertech.esper.epl.expression.ExprRegexpNode;
import com.espertech.esper.epl.expression.ExprRelationalOpAllAnyNode;
import com.espertech.esper.epl.expression.ExprRelationalOpNode;
import com.espertech.esper.epl.expression.ExprStaticMethodNode;
import com.espertech.esper.epl.expression.ExprStddevNode;
import com.espertech.esper.epl.expression.ExprSubselectAllSomeAnyNode;
import com.espertech.esper.epl.expression.ExprSubselectExistsNode;
import com.espertech.esper.epl.expression.ExprSubselectInNode;
import com.espertech.esper.epl.expression.ExprSubselectRowNode;
import com.espertech.esper.epl.expression.ExprSubstitutionNode;
import com.espertech.esper.epl.expression.ExprSumNode;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.expression.ExprTimestampNode;
import com.espertech.esper.epl.expression.ExprVariableNode;
import com.espertech.esper.epl.parse.ASTFilterSpecHelper;
import com.espertech.esper.epl.spec.AnnotationDesc;
import com.espertech.esper.epl.spec.CreateIndexDesc;
import com.espertech.esper.epl.spec.CreateVariableDesc;
import com.espertech.esper.epl.spec.CreateWindowDesc;
import com.espertech.esper.epl.spec.DBStatementStreamSpec;
import com.espertech.esper.epl.spec.FilterSpecRaw;
import com.espertech.esper.epl.spec.FilterStreamSpecRaw;
import com.espertech.esper.epl.spec.InsertIntoDesc;
import com.espertech.esper.epl.spec.MatchRecognizeDefineItem;
import com.espertech.esper.epl.spec.MatchRecognizeInterval;
import com.espertech.esper.epl.spec.MatchRecognizeMeasureItem;
import com.espertech.esper.epl.spec.MatchRecognizeSkip;
import com.espertech.esper.epl.spec.MatchRecognizeSkipEnum;
import com.espertech.esper.epl.spec.MatchRecognizeSpec;
import com.espertech.esper.epl.spec.MethodStreamSpec;
import com.espertech.esper.epl.spec.OnTriggerDesc;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.spec.OnTriggerSetDesc;
import com.espertech.esper.epl.spec.OnTriggerSplitStream;
import com.espertech.esper.epl.spec.OnTriggerSplitStreamDesc;
import com.espertech.esper.epl.spec.OnTriggerType;
import com.espertech.esper.epl.spec.OnTriggerWindowDesc;
import com.espertech.esper.epl.spec.OnTriggerWindowUpdateDesc;
import com.espertech.esper.epl.spec.OrderByItem;
import com.espertech.esper.epl.spec.OuterJoinDesc;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitRateType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.spec.PatternGuardSpec;
import com.espertech.esper.epl.spec.PatternObserverSpec;
import com.espertech.esper.epl.spec.PatternStreamSpecRaw;
import com.espertech.esper.epl.spec.PropertyEvalAtom;
import com.espertech.esper.epl.spec.PropertyEvalSpec;
import com.espertech.esper.epl.spec.RowLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseElementRaw;
import com.espertech.esper.epl.spec.SelectClauseElementWildcard;
import com.espertech.esper.epl.spec.SelectClauseExprRawSpec;
import com.espertech.esper.epl.spec.SelectClauseSpecRaw;
import com.espertech.esper.epl.spec.SelectClauseStreamRawSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecMapContext;
import com.espertech.esper.epl.spec.StatementSpecRaw;
import com.espertech.esper.epl.spec.StatementSpecUnMapContext;
import com.espertech.esper.epl.spec.StatementSpecUnMapResult;
import com.espertech.esper.epl.spec.StreamSpecBase;
import com.espertech.esper.epl.spec.StreamSpecOptions;
import com.espertech.esper.epl.spec.StreamSpecRaw;
import com.espertech.esper.epl.spec.SubstitutionParameterExpression;
import com.espertech.esper.epl.spec.UpdateDesc;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.pattern.EvalAndNode;
import com.espertech.esper.pattern.EvalEveryDistinctNode;
import com.espertech.esper.pattern.EvalEveryNode;
import com.espertech.esper.pattern.EvalFilterNode;
import com.espertech.esper.pattern.EvalFollowedByNode;
import com.espertech.esper.pattern.EvalGuardNode;
import com.espertech.esper.pattern.EvalMatchUntilNode;
import com.espertech.esper.pattern.EvalMatchUntilSpec;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNotNode;
import com.espertech.esper.pattern.EvalObserverNode;
import com.espertech.esper.pattern.EvalOrNode;
import com.espertech.esper.rowregex.RegexNFATypeEnum;
import com.espertech.esper.rowregex.RowRegexExprNode;
import com.espertech.esper.rowregex.RowRegexExprNodeAlteration;
import com.espertech.esper.rowregex.RowRegexExprNodeAtom;
import com.espertech.esper.rowregex.RowRegexExprNodeConcatenation;
import com.espertech.esper.rowregex.RowRegexExprNodeNested;
import com.espertech.esper.type.CronOperatorEnum;
import com.espertech.esper.type.MathArithTypeEnum;
import com.espertech.esper.type.MinMaxTypeEnum;
import com.espertech.esper.type.RelationalOpEnum;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementSpecMapper {
    public static Expression unmap(ExprNode expression) {
        return StatementSpecMapper.unmapExpressionDeep(expression, new StatementSpecUnMapContext());
    }

    public static PatternExpr unmap(EvalNode node) {
        return StatementSpecMapper.unmapPatternEvalDeep(node, new StatementSpecUnMapContext());
    }

    public static AnnotationPart unmap(AnnotationDesc node) {
        List<AnnotationPart> list = StatementSpecMapper.unmapAnnotations(Collections.singletonList(node));
        return list.get(0);
    }

    public static MatchRecognizeRegEx unmap(RowRegexExprNode pattern) {
        return StatementSpecMapper.unmapExpressionDeepRowRegex(pattern, new StatementSpecUnMapContext());
    }

    public static StatementSpecRaw map(EPStatementObjectModel sodaStatement, EngineImportService engineImportService, VariableService variableService, ConfigurationInformation configuration) {
        StatementSpecMapContext mapContext = new StatementSpecMapContext(engineImportService, variableService, configuration);
        StatementSpecRaw raw = StatementSpecMapper.map(sodaStatement, mapContext);
        if (mapContext.isHasVariables()) {
            raw.setHasVariables(true);
        }
        raw.setReferencedVariables(mapContext.getVariableNames());
        return raw;
    }

    private static StatementSpecRaw map(EPStatementObjectModel sodaStatement, StatementSpecMapContext mapContext) {
        StatementSpecRaw raw = new StatementSpecRaw(SelectClauseStreamSelectorEnum.ISTREAM_ONLY);
        StatementSpecMapper.mapAnnotations(sodaStatement.getAnnotations(), raw);
        StatementSpecMapper.mapUpdateClause(sodaStatement.getUpdateClause(), raw, mapContext);
        StatementSpecMapper.mapCreateWindow(sodaStatement.getCreateWindow(), raw, mapContext);
        StatementSpecMapper.mapCreateIndex(sodaStatement.getCreateIndex(), raw, mapContext);
        StatementSpecMapper.mapCreateVariable(sodaStatement.getCreateVariable(), raw, mapContext);
        StatementSpecMapper.mapOnTrigger(sodaStatement.getOnExpr(), raw, mapContext);
        InsertIntoDesc desc = StatementSpecMapper.mapInsertInto(sodaStatement.getInsertInto());
        raw.setInsertIntoDesc(desc);
        StatementSpecMapper.mapSelect(sodaStatement.getSelectClause(), raw, mapContext);
        StatementSpecMapper.mapFrom(sodaStatement.getFromClause(), raw, mapContext);
        StatementSpecMapper.mapWhere(sodaStatement.getWhereClause(), raw, mapContext);
        StatementSpecMapper.mapGroupBy(sodaStatement.getGroupByClause(), raw, mapContext);
        StatementSpecMapper.mapHaving(sodaStatement.getHavingClause(), raw, mapContext);
        StatementSpecMapper.mapOutputLimit(sodaStatement.getOutputLimitClause(), raw, mapContext);
        StatementSpecMapper.mapOrderBy(sodaStatement.getOrderByClause(), raw, mapContext);
        StatementSpecMapper.mapRowLimit(sodaStatement.getRowLimitClause(), raw, mapContext);
        StatementSpecMapper.mapMatchRecognize(sodaStatement.getMatchRecognizeClause(), raw, mapContext);
        return raw;
    }

    public static StatementSpecUnMapResult unmap(StatementSpecRaw statementSpec) {
        StatementSpecUnMapContext unmapContext = new StatementSpecUnMapContext();
        EPStatementObjectModel model = new EPStatementObjectModel();
        List<AnnotationPart> annotations = StatementSpecMapper.unmapAnnotations(statementSpec.getAnnotations());
        model.setAnnotations(annotations);
        StatementSpecMapper.unmapCreateWindow(statementSpec.getCreateWindowDesc(), model, unmapContext);
        StatementSpecMapper.unmapCreateIndex(statementSpec.getCreateIndexDesc(), model, unmapContext);
        StatementSpecMapper.unmapCreateVariable(statementSpec.getCreateVariableDesc(), model, unmapContext);
        StatementSpecMapper.unmapUpdateClause(statementSpec.getStreamSpecs(), statementSpec.getUpdateDesc(), model, unmapContext);
        StatementSpecMapper.unmapOnClause(statementSpec.getOnTriggerDesc(), model, unmapContext);
        InsertIntoClause insertIntoClause = StatementSpecMapper.unmapInsertInto(statementSpec.getInsertIntoDesc());
        model.setInsertInto(insertIntoClause);
        SelectClause selectClause = StatementSpecMapper.unmapSelect(statementSpec.getSelectClauseSpec(), statementSpec.getSelectStreamSelectorEnum(), unmapContext);
        model.setSelectClause(selectClause);
        StatementSpecMapper.unmapFrom(statementSpec.getStreamSpecs(), statementSpec.getOuterJoinDescList(), model, unmapContext);
        StatementSpecMapper.unmapWhere(statementSpec.getFilterRootNode(), model, unmapContext);
        StatementSpecMapper.unmapGroupBy(statementSpec.getGroupByExpressions(), model, unmapContext);
        StatementSpecMapper.unmapHaving(statementSpec.getHavingExprRootNode(), model, unmapContext);
        StatementSpecMapper.unmapOutputLimit(statementSpec.getOutputLimitSpec(), model, unmapContext);
        StatementSpecMapper.unmapOrderBy(statementSpec.getOrderByList(), model, unmapContext);
        StatementSpecMapper.unmapRowLimit(statementSpec.getRowLimitSpec(), model, unmapContext);
        StatementSpecMapper.unmapMatchRecognize(statementSpec.getMatchRecognizeSpec(), model, unmapContext);
        return new StatementSpecUnMapResult(model, unmapContext.getIndexedParams());
    }

    private static void unmapOnClause(OnTriggerDesc onTriggerDesc, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (onTriggerDesc == null) {
            return;
        }
        if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_DELETE) {
            OnTriggerWindowDesc window = (OnTriggerWindowDesc)onTriggerDesc;
            model.setOnExpr(new OnDeleteClause(window.getWindowName(), window.getOptionalAsName()));
        } else if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_UPDATE) {
            OnTriggerWindowUpdateDesc window = (OnTriggerWindowUpdateDesc)onTriggerDesc;
            OnUpdateClause clause = new OnUpdateClause(window.getWindowName(), window.getOptionalAsName());
            for (OnTriggerSetAssignment assignment : window.getAssignments()) {
                Expression expr = StatementSpecMapper.unmapExpressionDeep(assignment.getExpression(), unmapContext);
                clause.addAssignment(assignment.getVariableName(), expr);
            }
            model.setOnExpr(clause);
        } else if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_SELECT) {
            OnTriggerWindowDesc window = (OnTriggerWindowDesc)onTriggerDesc;
            model.setOnExpr(new OnSelectClause(window.getWindowName(), window.getOptionalAsName()));
        } else if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_SET) {
            OnTriggerSetDesc trigger = (OnTriggerSetDesc)onTriggerDesc;
            OnSetClause clause = new OnSetClause();
            for (OnTriggerSetAssignment assignment : trigger.getAssignments()) {
                Expression expr = StatementSpecMapper.unmapExpressionDeep(assignment.getExpression(), unmapContext);
                clause.addAssignment(assignment.getVariableName(), expr);
            }
            model.setOnExpr(clause);
        } else if (onTriggerDesc.getOnTriggerType() == OnTriggerType.ON_SPLITSTREAM) {
            OnTriggerSplitStreamDesc trigger = (OnTriggerSplitStreamDesc)onTriggerDesc;
            OnInsertSplitStreamClause clause = OnInsertSplitStreamClause.create();
            for (OnTriggerSplitStream stream : trigger.getSplitStreams()) {
                Expression whereClause = null;
                if (stream.getWhereClause() != null) {
                    whereClause = StatementSpecMapper.unmapExpressionDeep(stream.getWhereClause(), unmapContext);
                }
                InsertIntoClause insertIntoClause = StatementSpecMapper.unmapInsertInto(stream.getInsertInto());
                SelectClause selectClause = StatementSpecMapper.unmapSelect(stream.getSelectClause(), SelectClauseStreamSelectorEnum.ISTREAM_ONLY, unmapContext);
                clause.addItem(OnInsertSplitStreamItem.create(insertIntoClause, selectClause, whereClause));
            }
            model.setOnExpr(clause);
        }
    }

    private static void unmapUpdateClause(List<StreamSpecRaw> desc, UpdateDesc updateDesc, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (updateDesc == null) {
            return;
        }
        String type = ((FilterStreamSpecRaw)desc.get(0)).getRawFilterSpec().getEventTypeName();
        UpdateClause clause = new UpdateClause(type, updateDesc.getOptionalStreamName());
        for (OnTriggerSetAssignment assignment : updateDesc.getAssignments()) {
            Expression expr = StatementSpecMapper.unmapExpressionDeep(assignment.getExpression(), unmapContext);
            clause.addAssignment(assignment.getVariableName(), expr);
        }
        model.setUpdateClause(clause);
        if (updateDesc.getOptionalWhereClause() != null) {
            Expression expr = StatementSpecMapper.unmapExpressionDeep(updateDesc.getOptionalWhereClause(), unmapContext);
            model.getUpdateClause().setOptionalWhereClause(expr);
        }
    }

    private static void unmapCreateWindow(CreateWindowDesc createWindowDesc, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (createWindowDesc == null) {
            return;
        }
        Expression filter = null;
        if (createWindowDesc.getInsertFilter() != null) {
            filter = StatementSpecMapper.unmapExpressionDeep(createWindowDesc.getInsertFilter(), unmapContext);
        }
        CreateWindowClause clause = new CreateWindowClause(createWindowDesc.getWindowName(), StatementSpecMapper.unmapViews(createWindowDesc.getViewSpecs(), unmapContext));
        clause.setInsert(createWindowDesc.isInsert());
        clause.setInsertWhereClause(filter);
        model.setCreateWindow(clause);
    }

    private static void unmapCreateIndex(CreateIndexDesc createIndexDesc, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (createIndexDesc == null) {
            return;
        }
        model.setCreateIndex(new CreateIndexClause(createIndexDesc.getIndexName(), createIndexDesc.getWindowName(), createIndexDesc.getColumns().toArray(new String[createIndexDesc.getColumns().size()])));
    }

    private static void unmapCreateVariable(CreateVariableDesc createVariableDesc, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (createVariableDesc == null) {
            return;
        }
        Expression assignment = null;
        if (createVariableDesc.getAssignment() != null) {
            assignment = StatementSpecMapper.unmapExpressionDeep(createVariableDesc.getAssignment(), unmapContext);
        }
        model.setCreateVariable(new CreateVariableClause(createVariableDesc.getVariableType(), createVariableDesc.getVariableName(), assignment));
    }

    private static void unmapOrderBy(List<OrderByItem> orderByList, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (orderByList == null || orderByList.size() == 0) {
            return;
        }
        OrderByClause clause = new OrderByClause();
        for (OrderByItem item : orderByList) {
            Expression expr = StatementSpecMapper.unmapExpressionDeep(item.getExprNode(), unmapContext);
            clause.add(expr, item.isDescending());
        }
        model.setOrderByClause(clause);
    }

    private static void unmapOutputLimit(OutputLimitSpec outputLimitSpec, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        OutputLimitClause clause;
        if (outputLimitSpec == null) {
            return;
        }
        OutputLimitSelector selector = OutputLimitSelector.DEFAULT;
        if (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.FIRST) {
            selector = OutputLimitSelector.FIRST;
        }
        if (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.LAST) {
            selector = OutputLimitSelector.LAST;
        }
        if (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.SNAPSHOT) {
            selector = OutputLimitSelector.SNAPSHOT;
        }
        if (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.ALL) {
            selector = OutputLimitSelector.ALL;
        }
        OutputLimitUnit unit = OutputLimitUnit.EVENTS;
        if (outputLimitSpec.getRateType() == OutputLimitRateType.TIME_PERIOD) {
            unit = OutputLimitUnit.TIME_PERIOD;
            TimePeriodExpression timePeriod = (TimePeriodExpression)StatementSpecMapper.unmapExpressionDeep(outputLimitSpec.getTimePeriodExpr(), unmapContext);
            clause = new OutputLimitClause(selector, timePeriod);
        } else if (outputLimitSpec.getRateType() == OutputLimitRateType.AFTER) {
            unit = OutputLimitUnit.AFTER;
            if (outputLimitSpec.getAfterTimePeriodExpr() != null) {
                TimePeriodExpression after = (TimePeriodExpression)StatementSpecMapper.unmapExpressionDeep(outputLimitSpec.getAfterTimePeriodExpr(), unmapContext);
                clause = new OutputLimitClause(OutputLimitSelector.DEFAULT, OutputLimitUnit.AFTER, after, null);
            } else {
                clause = new OutputLimitClause(OutputLimitSelector.DEFAULT, OutputLimitUnit.AFTER, null, outputLimitSpec.getAfterNumberOfEvents());
            }
        } else if (outputLimitSpec.getRateType() == OutputLimitRateType.WHEN_EXPRESSION) {
            unit = OutputLimitUnit.WHEN_EXPRESSION;
            Expression whenExpression = StatementSpecMapper.unmapExpressionDeep(outputLimitSpec.getWhenExpressionNode(), unmapContext);
            ArrayList<AssignmentPair> thenAssignments = new ArrayList<AssignmentPair>();
            clause = new OutputLimitClause(selector, whenExpression, thenAssignments);
            if (outputLimitSpec.getThenExpressions() != null) {
                for (OnTriggerSetAssignment assignment : outputLimitSpec.getThenExpressions()) {
                    Expression expr = StatementSpecMapper.unmapExpressionDeep(assignment.getExpression(), unmapContext);
                    clause.addThenAssignment(assignment.getVariableName(), expr);
                }
            }
        } else if (outputLimitSpec.getRateType() == OutputLimitRateType.CRONTAB) {
            unit = OutputLimitUnit.CRONTAB_EXPRESSION;
            List<ExprNode> timerAtExpressions = outputLimitSpec.getCrontabAtSchedule();
            List<Expression> mappedExpr = StatementSpecMapper.unmapExpressionDeep(timerAtExpressions, unmapContext);
            clause = new OutputLimitClause(selector, mappedExpr.toArray(new Expression[mappedExpr.size()]));
        } else {
            clause = new OutputLimitClause(selector, outputLimitSpec.getRate(), outputLimitSpec.getVariableName(), unit);
        }
        clause.setAfterNumberOfEvents(outputLimitSpec.getAfterNumberOfEvents());
        if (outputLimitSpec.getAfterTimePeriodExpr() != null) {
            clause.setAfterTimePeriodExpression((TimePeriodExpression)StatementSpecMapper.unmapExpressionDeep(outputLimitSpec.getAfterTimePeriodExpr(), unmapContext));
        }
        model.setOutputLimitClause(clause);
    }

    private static void unmapRowLimit(RowLimitSpec rowLimitSpec, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (rowLimitSpec == null) {
            return;
        }
        RowLimitClause spec = new RowLimitClause(rowLimitSpec.getNumRows(), rowLimitSpec.getOptionalOffset(), rowLimitSpec.getNumRowsVariable(), rowLimitSpec.getOptionalOffsetVariable());
        model.setRowLimitClause(spec);
    }

    private static void unmapMatchRecognize(MatchRecognizeSpec spec, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (spec == null) {
            return;
        }
        MatchRecognizeClause clause = new MatchRecognizeClause();
        clause.setPartitionExpressions(StatementSpecMapper.unmapExpressionDeep(spec.getPartitionByExpressions(), unmapContext));
        ArrayList<SelectClauseExpression> measures = new ArrayList<SelectClauseExpression>();
        for (MatchRecognizeMeasureItem item : spec.getMeasures()) {
            measures.add(new SelectClauseExpression(StatementSpecMapper.unmapExpressionDeep(item.getExpr(), unmapContext), item.getName()));
        }
        clause.setMeasures(measures);
        clause.setAll(spec.isAllMatches());
        clause.setSkipClause(MatchRecognizeSkipClause.values()[spec.getSkip().getSkip().ordinal()]);
        ArrayList<MatchRecognizeDefine> defines = new ArrayList<MatchRecognizeDefine>();
        for (MatchRecognizeDefineItem define : spec.getDefines()) {
            defines.add(new MatchRecognizeDefine(define.getIdentifier(), StatementSpecMapper.unmapExpressionDeep(define.getExpression(), unmapContext)));
        }
        clause.setDefines(defines);
        if (spec.getInterval() != null) {
            clause.setIntervalClause(new MatchRecognizeIntervalClause((TimePeriodExpression)StatementSpecMapper.unmapExpressionDeep(spec.getInterval().getTimePeriodExpr(), unmapContext)));
        }
        clause.setPattern(StatementSpecMapper.unmapExpressionDeepRowRegex(spec.getPattern(), unmapContext));
        model.setMatchRecognizeClause(clause);
    }

    private static void mapOrderBy(OrderByClause orderByClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (orderByClause == null) {
            return;
        }
        for (OrderByElement element : orderByClause.getOrderByExpressions()) {
            ExprNode orderExpr = StatementSpecMapper.mapExpressionDeep(element.getExpression(), mapContext);
            OrderByItem item = new OrderByItem(orderExpr, element.isDescending());
            raw.getOrderByList().add(item);
        }
    }

    private static void mapOutputLimit(OutputLimitClause outputLimitClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        OutputLimitRateType rateType;
        if (outputLimitClause == null) {
            return;
        }
        OutputLimitLimitType displayLimit = OutputLimitLimitType.valueOf(outputLimitClause.getSelector().toString().toUpperCase());
        if (outputLimitClause.getUnit() == OutputLimitUnit.EVENTS) {
            rateType = OutputLimitRateType.EVENTS;
        } else if (outputLimitClause.getUnit() == OutputLimitUnit.TIME_PERIOD) {
            rateType = OutputLimitRateType.TIME_PERIOD;
        } else if (outputLimitClause.getUnit() == OutputLimitUnit.CRONTAB_EXPRESSION) {
            rateType = OutputLimitRateType.CRONTAB;
        } else if (outputLimitClause.getUnit() == OutputLimitUnit.WHEN_EXPRESSION) {
            rateType = OutputLimitRateType.WHEN_EXPRESSION;
        } else if (outputLimitClause.getUnit() == OutputLimitUnit.AFTER) {
            rateType = OutputLimitRateType.AFTER;
        } else {
            throw new IllegalArgumentException("Unknown output limit unit " + (Object)((Object)outputLimitClause.getUnit()));
        }
        Double frequency = outputLimitClause.getFrequency();
        String frequencyVariable = outputLimitClause.getFrequencyVariable();
        if (frequencyVariable != null) {
            mapContext.setHasVariables(true);
        }
        ExprNode whenExpression = null;
        ArrayList<OnTriggerSetAssignment> assignments = null;
        if (outputLimitClause.getWhenExpression() != null) {
            whenExpression = StatementSpecMapper.mapExpressionDeep(outputLimitClause.getWhenExpression(), mapContext);
            assignments = new ArrayList<OnTriggerSetAssignment>();
            for (AssignmentPair pair : outputLimitClause.getThenAssignments()) {
                ExprNode expr = StatementSpecMapper.mapExpressionDeep(pair.getValue(), mapContext);
                assignments.add(new OnTriggerSetAssignment(pair.getName(), expr));
            }
        }
        List<ExprNode> timerAtExprList = null;
        if (outputLimitClause.getCrontabAtParameters() != null) {
            timerAtExprList = StatementSpecMapper.mapExpressionDeep(Arrays.asList(outputLimitClause.getCrontabAtParameters()), mapContext);
        }
        ExprTimePeriod timePeriod = null;
        if (outputLimitClause.getTimePeriodExpression() != null) {
            timePeriod = (ExprTimePeriod)StatementSpecMapper.mapExpressionDeep(outputLimitClause.getTimePeriodExpression(), mapContext);
        }
        ExprTimePeriod afterTimePeriod = null;
        if (outputLimitClause.getAfterTimePeriodExpression() != null) {
            afterTimePeriod = (ExprTimePeriod)StatementSpecMapper.mapExpressionDeep(outputLimitClause.getAfterTimePeriodExpression(), mapContext);
        }
        OutputLimitSpec spec = new OutputLimitSpec(frequency, frequencyVariable, rateType, displayLimit, whenExpression, assignments, timerAtExprList, timePeriod, afterTimePeriod, outputLimitClause.getAfterNumberOfEvents());
        raw.setOutputLimitSpec(spec);
    }

    private static void mapOnTrigger(OnClause onExpr, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (onExpr == null) {
            return;
        }
        if (onExpr instanceof OnDeleteClause) {
            OnDeleteClause onDeleteClause = (OnDeleteClause)onExpr;
            raw.setOnTriggerDesc(new OnTriggerWindowDesc(onDeleteClause.getWindowName(), onDeleteClause.getOptionalAsName(), OnTriggerType.ON_DELETE));
        } else if (onExpr instanceof OnSelectClause) {
            OnSelectClause onSelectClause = (OnSelectClause)onExpr;
            raw.setOnTriggerDesc(new OnTriggerWindowDesc(onSelectClause.getWindowName(), onSelectClause.getOptionalAsName(), OnTriggerType.ON_SELECT));
        } else if (onExpr instanceof OnSetClause) {
            OnSetClause setClause = (OnSetClause)onExpr;
            mapContext.setHasVariables(true);
            ArrayList<OnTriggerSetAssignment> assignments = new ArrayList<OnTriggerSetAssignment>();
            for (AssignmentPair pair : setClause.getAssignments()) {
                ExprNode expr = StatementSpecMapper.mapExpressionDeep(pair.getValue(), mapContext);
                assignments.add(new OnTriggerSetAssignment(pair.getName(), expr));
            }
            OnTriggerSetDesc desc = new OnTriggerSetDesc(assignments);
            raw.setOnTriggerDesc(desc);
        } else if (onExpr instanceof OnUpdateClause) {
            OnUpdateClause updateClause = (OnUpdateClause)onExpr;
            ArrayList<OnTriggerSetAssignment> assignments = new ArrayList<OnTriggerSetAssignment>();
            for (AssignmentPair pair : updateClause.getAssignments()) {
                ExprNode expr = StatementSpecMapper.mapExpressionDeep(pair.getValue(), mapContext);
                assignments.add(new OnTriggerSetAssignment(pair.getName(), expr));
            }
            OnTriggerWindowUpdateDesc desc = new OnTriggerWindowUpdateDesc(updateClause.getWindowName(), updateClause.getOptionalAsName(), assignments);
            raw.setOnTriggerDesc(desc);
        } else if (onExpr instanceof OnInsertSplitStreamClause) {
            OnInsertSplitStreamClause splitClause = (OnInsertSplitStreamClause)onExpr;
            mapContext.setHasVariables(true);
            ArrayList<OnTriggerSplitStream> streams = new ArrayList<OnTriggerSplitStream>();
            for (OnInsertSplitStreamItem item : splitClause.getItems()) {
                ExprNode whereClause = null;
                if (item.getWhereClause() != null) {
                    whereClause = StatementSpecMapper.mapExpressionDeep(item.getWhereClause(), mapContext);
                }
                InsertIntoDesc insertDesc = StatementSpecMapper.mapInsertInto(item.getInsertInto());
                SelectClauseSpecRaw selectDesc = StatementSpecMapper.mapSelectRaw(item.getSelectClause(), mapContext);
                streams.add(new OnTriggerSplitStream(insertDesc, selectDesc, whereClause));
            }
            OnTriggerSplitStreamDesc desc = new OnTriggerSplitStreamDesc(OnTriggerType.ON_SPLITSTREAM, splitClause.isFirst(), streams);
            raw.setOnTriggerDesc(desc);
        } else {
            throw new IllegalArgumentException("Cannot map on-clause expression type : " + onExpr);
        }
    }

    private static void mapRowLimit(RowLimitClause rowLimitClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (rowLimitClause == null) {
            return;
        }
        if (rowLimitClause.getNumRowsVariable() != null || rowLimitClause.getOptionalOffsetRowsVariable() != null) {
            raw.setHasVariables(true);
            mapContext.getVariableNames().add(rowLimitClause.getOptionalOffsetRowsVariable());
        }
        raw.setRowLimitSpec(new RowLimitSpec(rowLimitClause.getNumRows(), rowLimitClause.getOptionalOffsetRows(), rowLimitClause.getNumRowsVariable(), rowLimitClause.getOptionalOffsetRowsVariable()));
    }

    private static void mapMatchRecognize(MatchRecognizeClause clause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (clause == null) {
            return;
        }
        MatchRecognizeSpec spec = new MatchRecognizeSpec();
        spec.setPartitionByExpressions(StatementSpecMapper.mapExpressionDeep(clause.getPartitionExpressions(), mapContext));
        ArrayList<MatchRecognizeMeasureItem> measures = new ArrayList<MatchRecognizeMeasureItem>();
        for (SelectClauseExpression item : clause.getMeasures()) {
            measures.add(new MatchRecognizeMeasureItem(StatementSpecMapper.mapExpressionDeep(item.getExpression(), mapContext), item.getAsName()));
        }
        spec.setMeasures(measures);
        spec.setAllMatches(clause.isAll());
        spec.setSkip(new MatchRecognizeSkip(MatchRecognizeSkipEnum.values()[clause.getSkipClause().ordinal()]));
        ArrayList<MatchRecognizeDefineItem> defines = new ArrayList<MatchRecognizeDefineItem>();
        for (MatchRecognizeDefine define : clause.getDefines()) {
            defines.add(new MatchRecognizeDefineItem(define.getName(), StatementSpecMapper.mapExpressionDeep(define.getExpression(), mapContext)));
        }
        spec.setDefines(defines);
        if (clause.getIntervalClause() != null) {
            spec.setInterval(new MatchRecognizeInterval((ExprTimePeriod)StatementSpecMapper.mapExpressionDeep(clause.getIntervalClause().getExpression(), mapContext)));
        }
        spec.setPattern(StatementSpecMapper.mapExpressionDeepRowRegex(clause.getPattern(), mapContext));
        raw.setMatchRecognizeSpec(spec);
    }

    private static void mapHaving(Expression havingClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (havingClause == null) {
            return;
        }
        ExprNode node = StatementSpecMapper.mapExpressionDeep(havingClause, mapContext);
        raw.setHavingExprRootNode(node);
    }

    private static void unmapHaving(ExprNode havingExprRootNode, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (havingExprRootNode == null) {
            return;
        }
        Expression expr = StatementSpecMapper.unmapExpressionDeep(havingExprRootNode, unmapContext);
        model.setHavingClause(expr);
    }

    private static void mapGroupBy(GroupByClause groupByClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (groupByClause == null) {
            return;
        }
        for (Expression expr : groupByClause.getGroupByExpressions()) {
            ExprNode node = StatementSpecMapper.mapExpressionDeep(expr, mapContext);
            raw.getGroupByExpressions().add(node);
        }
    }

    private static void unmapGroupBy(List<ExprNode> groupByExpressions, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (groupByExpressions.size() == 0) {
            return;
        }
        GroupByClause clause = new GroupByClause();
        for (ExprNode node : groupByExpressions) {
            Expression expr = StatementSpecMapper.unmapExpressionDeep(node, unmapContext);
            clause.getGroupByExpressions().add(expr);
        }
        model.setGroupByClause(clause);
    }

    private static void mapWhere(Expression whereClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (whereClause == null) {
            return;
        }
        ExprNode node = StatementSpecMapper.mapExpressionDeep(whereClause, mapContext);
        raw.setFilterRootNode(node);
    }

    private static void unmapWhere(ExprNode filterRootNode, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        if (filterRootNode == null) {
            return;
        }
        Expression expr = StatementSpecMapper.unmapExpressionDeep(filterRootNode, unmapContext);
        model.setWhereClause(expr);
    }

    private static void unmapFrom(List<StreamSpecRaw> streamSpecs, List<OuterJoinDesc> outerJoinDescList, EPStatementObjectModel model, StatementSpecUnMapContext unmapContext) {
        FromClause from = new FromClause();
        model.setFromClause(from);
        for (StreamSpecRaw stream : streamSpecs) {
            Stream targetStream;
            if (stream instanceof FilterStreamSpecRaw) {
                FilterStreamSpecRaw filterStreamSpec = (FilterStreamSpecRaw)stream;
                Filter filter = StatementSpecMapper.unmapFilter(filterStreamSpec.getRawFilterSpec(), unmapContext);
                FilterStream filterStream = new FilterStream(filter, filterStreamSpec.getOptionalStreamName());
                StatementSpecMapper.unmapStreamOpts(stream.getOptions(), filterStream);
                targetStream = filterStream;
            } else if (stream instanceof DBStatementStreamSpec) {
                DBStatementStreamSpec db = (DBStatementStreamSpec)stream;
                targetStream = new SQLStream(db.getDatabaseName(), db.getSqlWithSubsParams(), db.getOptionalStreamName(), db.getMetadataSQL());
            } else if (stream instanceof PatternStreamSpecRaw) {
                PatternStreamSpecRaw pattern = (PatternStreamSpecRaw)stream;
                PatternExpr patternExpr = StatementSpecMapper.unmapPatternEvalDeep(pattern.getEvalNode(), unmapContext);
                PatternStream patternStream = new PatternStream(patternExpr, pattern.getOptionalStreamName());
                StatementSpecMapper.unmapStreamOpts(stream.getOptions(), patternStream);
                targetStream = patternStream;
            } else if (stream instanceof MethodStreamSpec) {
                MethodStreamSpec method = (MethodStreamSpec)stream;
                MethodInvocationStream methodStream = new MethodInvocationStream(method.getClassName(), method.getMethodName(), method.getOptionalStreamName());
                for (ExprNode exprNode : method.getExpressions()) {
                    Expression expr = StatementSpecMapper.unmapExpressionDeep(exprNode, unmapContext);
                    methodStream.addParameter(expr);
                }
                targetStream = methodStream;
            } else {
                throw new IllegalArgumentException("Stream modelled by " + stream.getClass() + " cannot be unmapped");
            }
            if (targetStream instanceof ProjectedStream) {
                ProjectedStream projStream = (ProjectedStream)targetStream;
                for (ViewSpec viewSpec : stream.getViewSpecs()) {
                    List<Expression> viewExpressions = StatementSpecMapper.unmapExpressionDeep(viewSpec.getObjectParameters(), unmapContext);
                    projStream.addView(View.create(viewSpec.getObjectNamespace(), viewSpec.getObjectName(), viewExpressions));
                }
            }
            from.add(targetStream);
        }
        for (OuterJoinDesc desc : outerJoinDescList) {
            PropertyValueExpression left = (PropertyValueExpression)StatementSpecMapper.unmapExpressionFlat(desc.getLeftNode(), unmapContext);
            PropertyValueExpression right = (PropertyValueExpression)StatementSpecMapper.unmapExpressionFlat(desc.getRightNode(), unmapContext);
            ArrayList<PropertyValueExpressionPair> additionalProperties = new ArrayList<PropertyValueExpressionPair>();
            if (desc.getAdditionalLeftNodes() != null) {
                for (int i = 0; i < desc.getAdditionalLeftNodes().length; ++i) {
                    ExprIdentNode leftNode = desc.getAdditionalLeftNodes()[i];
                    ExprIdentNode rightNode = desc.getAdditionalRightNodes()[i];
                    PropertyValueExpression propLeft = (PropertyValueExpression)StatementSpecMapper.unmapExpressionFlat(leftNode, unmapContext);
                    PropertyValueExpression propRight = (PropertyValueExpression)StatementSpecMapper.unmapExpressionFlat(rightNode, unmapContext);
                    additionalProperties.add(new PropertyValueExpressionPair(propLeft, propRight));
                }
            }
            from.add(new OuterJoinQualifier(desc.getOuterJoinType(), left, right, additionalProperties));
        }
    }

    private static void unmapStreamOpts(StreamSpecOptions options, ProjectedStream stream) {
        stream.setUnidirectional(options.isUnidirectional());
        stream.setRetainUnion(options.isRetainUnion());
        stream.setRetainIntersection(options.isRetainIntersection());
    }

    private static StreamSpecOptions mapStreamOpts(ProjectedStream stream) {
        return new StreamSpecOptions(stream.isUnidirectional(), stream.isRetainUnion(), stream.isRetainIntersection());
    }

    private static SelectClause unmapSelect(SelectClauseSpecRaw selectClauseSpec, SelectClauseStreamSelectorEnum selectStreamSelectorEnum, StatementSpecUnMapContext unmapContext) {
        SelectClause clause = SelectClause.create();
        clause.setStreamSelector(SelectClauseStreamSelectorEnum.mapFromSODA(selectStreamSelectorEnum));
        for (SelectClauseElementRaw raw : selectClauseSpec.getSelectExprList()) {
            if (raw instanceof SelectClauseStreamRawSpec) {
                SelectClauseStreamRawSpec streamSpec = (SelectClauseStreamRawSpec)raw;
                clause.addStreamWildcard(streamSpec.getStreamName(), streamSpec.getOptionalAsName());
                continue;
            }
            if (raw instanceof SelectClauseElementWildcard) {
                clause.addWildcard();
                continue;
            }
            if (raw instanceof SelectClauseExprRawSpec) {
                SelectClauseExprRawSpec rawSpec = (SelectClauseExprRawSpec)raw;
                Expression expression = StatementSpecMapper.unmapExpressionDeep(rawSpec.getSelectExpression(), unmapContext);
                clause.add(expression, rawSpec.getOptionalAsName());
                continue;
            }
            throw new IllegalStateException("Unexpected select clause element typed " + raw.getClass().getName());
        }
        clause.setDistinct(selectClauseSpec.isDistinct());
        return clause;
    }

    private static InsertIntoClause unmapInsertInto(InsertIntoDesc insertIntoDesc) {
        StreamSelector s = StreamSelector.ISTREAM_ONLY;
        if (insertIntoDesc == null) {
            return null;
        }
        if (!insertIntoDesc.isIStream()) {
            s = StreamSelector.RSTREAM_ONLY;
        }
        return InsertIntoClause.create(insertIntoDesc.getEventTypeName(), insertIntoDesc.getColumnNames().toArray(new String[insertIntoDesc.getColumnNames().size()]), s);
    }

    private static void mapCreateWindow(CreateWindowClause createWindow, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (createWindow == null) {
            return;
        }
        ExprNode insertFromWhereExpr = null;
        if (createWindow.getInsertWhereClause() != null) {
            insertFromWhereExpr = StatementSpecMapper.mapExpressionDeep(createWindow.getInsertWhereClause(), mapContext);
        }
        raw.setCreateWindowDesc(new CreateWindowDesc(createWindow.getWindowName(), StatementSpecMapper.mapViews(createWindow.getViews(), mapContext), new StreamSpecOptions(), createWindow.isInsert(), insertFromWhereExpr));
    }

    private static void mapCreateIndex(CreateIndexClause clause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (clause == null) {
            return;
        }
        CreateIndexDesc desc = new CreateIndexDesc(clause.getIndexName(), clause.getWindowName(), clause.getColumns());
        raw.setCreateIndexDesc(desc);
    }

    private static void mapUpdateClause(UpdateClause updateClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (updateClause == null) {
            return;
        }
        ArrayList<OnTriggerSetAssignment> assignments = new ArrayList<OnTriggerSetAssignment>();
        for (AssignmentPair pair : updateClause.getAssignments()) {
            ExprNode expr = StatementSpecMapper.mapExpressionDeep(pair.getValue(), mapContext);
            assignments.add(new OnTriggerSetAssignment(pair.getName(), expr));
        }
        ExprNode whereClause = null;
        if (updateClause.getOptionalWhereClause() != null) {
            whereClause = StatementSpecMapper.mapExpressionDeep(updateClause.getOptionalWhereClause(), mapContext);
        }
        UpdateDesc desc = new UpdateDesc(updateClause.getOptionalAsClauseStreamName(), assignments, whereClause);
        raw.setUpdateDesc(desc);
        FilterSpecRaw filterSpecRaw = new FilterSpecRaw(updateClause.getEventType(), Collections.EMPTY_LIST, null);
        raw.getStreamSpecs().add(new FilterStreamSpecRaw(filterSpecRaw, Collections.EMPTY_LIST, null, new StreamSpecOptions()));
    }

    private static void mapCreateVariable(CreateVariableClause createVariable, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (createVariable == null) {
            return;
        }
        ExprNode assignment = null;
        if (createVariable.getOptionalAssignment() != null) {
            assignment = StatementSpecMapper.mapExpressionDeep(createVariable.getOptionalAssignment(), mapContext);
        }
        raw.setCreateVariableDesc(new CreateVariableDesc(createVariable.getVariableType(), createVariable.getVariableName(), assignment));
    }

    private static InsertIntoDesc mapInsertInto(InsertIntoClause insertInto) {
        if (insertInto == null) {
            return null;
        }
        boolean isIStream = insertInto.isIStream();
        String eventTypeName = insertInto.getStreamName();
        InsertIntoDesc desc = new InsertIntoDesc(isIStream, eventTypeName);
        for (String name : insertInto.getColumnNames()) {
            desc.add(name);
        }
        return desc;
    }

    private static void mapSelect(SelectClause selectClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (selectClause == null) {
            return;
        }
        SelectClauseSpecRaw spec = StatementSpecMapper.mapSelectRaw(selectClause, mapContext);
        raw.setSelectStreamDirEnum(SelectClauseStreamSelectorEnum.mapFromSODA(selectClause.getStreamSelector()));
        raw.setSelectClauseSpec(spec);
    }

    private static SelectClauseSpecRaw mapSelectRaw(SelectClause selectClause, StatementSpecMapContext mapContext) {
        SelectClauseSpecRaw spec = new SelectClauseSpecRaw();
        for (SelectClauseElement element : selectClause.getSelectList()) {
            if (element instanceof SelectClauseWildcard) {
                spec.add(new SelectClauseElementWildcard());
                continue;
            }
            if (element instanceof SelectClauseExpression) {
                SelectClauseExpression selectExpr = (SelectClauseExpression)element;
                Expression expr = selectExpr.getExpression();
                ExprNode exprNode = StatementSpecMapper.mapExpressionDeep(expr, mapContext);
                SelectClauseExprRawSpec rawElement = new SelectClauseExprRawSpec(exprNode, selectExpr.getAsName());
                spec.add(rawElement);
                continue;
            }
            if (!(element instanceof SelectClauseStreamWildcard)) continue;
            SelectClauseStreamWildcard streamWild = (SelectClauseStreamWildcard)element;
            SelectClauseStreamRawSpec rawElement = new SelectClauseStreamRawSpec(streamWild.getStreamName(), streamWild.getOptionalColumnName());
            spec.add(rawElement);
        }
        spec.setDistinct(selectClause.isDistinct());
        return spec;
    }

    private static Expression unmapExpressionDeep(ExprNode exprNode, StatementSpecUnMapContext unmapContext) {
        Expression parent = StatementSpecMapper.unmapExpressionFlat(exprNode, unmapContext);
        StatementSpecMapper.unmapExpressionRecursive(parent, exprNode, unmapContext);
        return parent;
    }

    private static List<ExprNode> mapExpressionDeep(List<Expression> expressions, StatementSpecMapContext mapContext) {
        ArrayList<ExprNode> result = new ArrayList<ExprNode>();
        for (Expression expr : expressions) {
            result.add(StatementSpecMapper.mapExpressionDeep(expr, mapContext));
        }
        return result;
    }

    private static MatchRecognizeRegEx unmapExpressionDeepRowRegex(RowRegexExprNode exprNode, StatementSpecUnMapContext unmapContext) {
        MatchRecognizeRegEx parent = StatementSpecMapper.unmapExpressionFlatRowregex(exprNode, unmapContext);
        StatementSpecMapper.unmapExpressionRecursiveRowregex(parent, exprNode, unmapContext);
        return parent;
    }

    private static ExprNode mapExpressionDeep(Expression expr, StatementSpecMapContext mapContext) {
        ExprNode parent = StatementSpecMapper.mapExpressionFlat(expr, mapContext);
        StatementSpecMapper.mapExpressionRecursive(parent, expr, mapContext);
        return parent;
    }

    private static RowRegexExprNode mapExpressionDeepRowRegex(MatchRecognizeRegEx expr, StatementSpecMapContext mapContext) {
        RowRegexExprNode parent = StatementSpecMapper.mapExpressionFlatRowregex(expr, mapContext);
        StatementSpecMapper.mapExpressionRecursiveRowregex(parent, expr, mapContext);
        return parent;
    }

    private static ExprNode mapExpressionFlat(Expression expr, StatementSpecMapContext mapContext) {
        if (expr == null) {
            throw new IllegalArgumentException("Null expression parameter");
        }
        if (expr instanceof ArithmaticExpression) {
            ArithmaticExpression arith = (ArithmaticExpression)expr;
            return new ExprMathNode(MathArithTypeEnum.parseOperator(arith.getOperator()), mapContext.getConfiguration().getEngineDefaults().getExpression().isIntegerDivision(), mapContext.getConfiguration().getEngineDefaults().getExpression().isDivisionByZeroReturnsNull());
        }
        if (expr instanceof PropertyValueExpression) {
            PropertyValueExpression prop = (PropertyValueExpression)expr;
            int indexDot = ASTFilterSpecHelper.unescapedIndexOfDot(prop.getPropertyName());
            if (indexDot != -1) {
                String stream = prop.getPropertyName().substring(0, indexDot);
                String property = prop.getPropertyName().substring(indexDot + 1, prop.getPropertyName().length());
                return new ExprIdentNode(property, stream);
            }
            if (mapContext.getVariableService().getReader(prop.getPropertyName()) != null) {
                mapContext.setHasVariables(true);
                return new ExprVariableNode(prop.getPropertyName());
            }
            return new ExprIdentNode(prop.getPropertyName());
        }
        if (expr instanceof Conjunction) {
            return new ExprAndNode();
        }
        if (expr instanceof Disjunction) {
            return new ExprOrNode();
        }
        if (expr instanceof RelationalOpExpression) {
            RelationalOpExpression op = (RelationalOpExpression)expr;
            if (op.getOperator().equals("=")) {
                return new ExprEqualsNode(false);
            }
            if (op.getOperator().equals("!=")) {
                return new ExprEqualsNode(true);
            }
            return new ExprRelationalOpNode(RelationalOpEnum.parse(op.getOperator()));
        }
        if (expr instanceof ConstantExpression) {
            ConstantExpression op = (ConstantExpression)expr;
            Class<?> constantType = null;
            if (op.getConstantType() != null) {
                try {
                    constantType = Class.forName(op.getConstantType());
                }
                catch (ClassNotFoundException e) {
                    throw new EPException("Error looking up class name '" + op.getConstantType() + "' to resolve as constant type");
                }
            }
            return new ExprConstantNode(op.getConstant(), constantType);
        }
        if (expr instanceof ConcatExpression) {
            return new ExprConcatNode();
        }
        if (expr instanceof SubqueryExpression) {
            SubqueryExpression sub = (SubqueryExpression)expr;
            StatementSpecRaw rawSubselect = StatementSpecMapper.map(sub.getModel(), mapContext);
            return new ExprSubselectRowNode(rawSubselect);
        }
        if (expr instanceof SubqueryInExpression) {
            SubqueryInExpression sub = (SubqueryInExpression)expr;
            StatementSpecRaw rawSubselect = StatementSpecMapper.map(sub.getModel(), mapContext);
            ExprSubselectInNode inSub = new ExprSubselectInNode(rawSubselect);
            inSub.setNotIn(sub.isNotIn());
            return inSub;
        }
        if (expr instanceof SubqueryExistsExpression) {
            SubqueryExistsExpression sub = (SubqueryExistsExpression)expr;
            StatementSpecRaw rawSubselect = StatementSpecMapper.map(sub.getModel(), mapContext);
            return new ExprSubselectExistsNode(rawSubselect);
        }
        if (expr instanceof SubqueryQualifiedExpression) {
            SubqueryQualifiedExpression sub = (SubqueryQualifiedExpression)expr;
            StatementSpecRaw rawSubselect = StatementSpecMapper.map(sub.getModel(), mapContext);
            boolean isNot = false;
            RelationalOpEnum relop = null;
            if (sub.getOperator().equals("!=")) {
                isNot = true;
            }
            if (!sub.getOperator().equals("=")) {
                relop = RelationalOpEnum.parse(sub.getOperator());
            }
            return new ExprSubselectAllSomeAnyNode(rawSubselect, isNot, sub.isAll(), relop);
        }
        if (expr instanceof CountStarProjectionExpression) {
            return new ExprCountNode(false);
        }
        if (expr instanceof CountProjectionExpression) {
            CountProjectionExpression count = (CountProjectionExpression)expr;
            return new ExprCountNode(count.isDistinct());
        }
        if (expr instanceof AvgProjectionExpression) {
            AvgProjectionExpression avg = (AvgProjectionExpression)expr;
            return new ExprAvgNode(avg.isDistinct());
        }
        if (expr instanceof SumProjectionExpression) {
            SumProjectionExpression avg = (SumProjectionExpression)expr;
            return new ExprSumNode(avg.isDistinct());
        }
        if (expr instanceof BetweenExpression) {
            BetweenExpression between = (BetweenExpression)expr;
            return new ExprBetweenNode(between.isLowEndpointIncluded(), between.isHighEndpointIncluded(), between.isNotBetween());
        }
        if (expr instanceof PriorExpression) {
            return new ExprPriorNode();
        }
        if (expr instanceof PreviousExpression) {
            return new ExprPreviousNode();
        }
        if (expr instanceof StaticMethodExpression) {
            StaticMethodExpression method = (StaticMethodExpression)expr;
            return new ExprStaticMethodNode(method.getClassName(), method.getMethod(), mapContext.getConfiguration().getEngineDefaults().getExpression().isUdfCache());
        }
        if (expr instanceof MinProjectionExpression) {
            MinProjectionExpression method = (MinProjectionExpression)expr;
            return new ExprMinMaxAggrNode(method.isDistinct(), MinMaxTypeEnum.MIN);
        }
        if (expr instanceof MaxProjectionExpression) {
            MaxProjectionExpression method = (MaxProjectionExpression)expr;
            return new ExprMinMaxAggrNode(method.isDistinct(), MinMaxTypeEnum.MAX);
        }
        if (expr instanceof NotExpression) {
            return new ExprNotNode();
        }
        if (expr instanceof InExpression) {
            InExpression in = (InExpression)expr;
            return new ExprInNode(in.isNotIn());
        }
        if (expr instanceof CoalesceExpression) {
            return new ExprCoalesceNode();
        }
        if (expr instanceof CaseWhenThenExpression) {
            return new ExprCaseNode(false);
        }
        if (expr instanceof CaseSwitchExpression) {
            return new ExprCaseNode(true);
        }
        if (expr instanceof MaxRowExpression) {
            return new ExprMinMaxRowNode(MinMaxTypeEnum.MAX);
        }
        if (expr instanceof MinRowExpression) {
            return new ExprMinMaxRowNode(MinMaxTypeEnum.MIN);
        }
        if (expr instanceof BitwiseOpExpression) {
            BitwiseOpExpression bit = (BitwiseOpExpression)expr;
            return new ExprBitWiseNode(bit.getBinaryOp());
        }
        if (expr instanceof ArrayExpression) {
            return new ExprArrayNode();
        }
        if (expr instanceof LikeExpression) {
            LikeExpression like = (LikeExpression)expr;
            return new ExprLikeNode(like.isNot());
        }
        if (expr instanceof RegExpExpression) {
            RegExpExpression regexp = (RegExpExpression)expr;
            return new ExprRegexpNode(regexp.isNot());
        }
        if (expr instanceof MedianProjectionExpression) {
            MedianProjectionExpression median = (MedianProjectionExpression)expr;
            return new ExprMedianNode(median.isDistinct());
        }
        if (expr instanceof AvedevProjectionExpression) {
            AvedevProjectionExpression node = (AvedevProjectionExpression)expr;
            return new ExprAvedevNode(node.isDistinct());
        }
        if (expr instanceof StddevProjectionExpression) {
            StddevProjectionExpression node = (StddevProjectionExpression)expr;
            return new ExprStddevNode(node.isDistinct());
        }
        if (expr instanceof LastProjectionExpression) {
            LastProjectionExpression node = (LastProjectionExpression)expr;
            return new ExprLastNode(node.isDistinct());
        }
        if (expr instanceof FirstProjectionExpression) {
            FirstProjectionExpression node = (FirstProjectionExpression)expr;
            return new ExprFirstNode(node.isDistinct());
        }
        if (expr instanceof InstanceOfExpression) {
            InstanceOfExpression node = (InstanceOfExpression)expr;
            return new ExprInstanceofNode(node.getTypeNames());
        }
        if (expr instanceof CastExpression) {
            CastExpression node = (CastExpression)expr;
            return new ExprCastNode(node.getTypeName());
        }
        if (expr instanceof PropertyExistsExpression) {
            return new ExprPropertyExistsNode();
        }
        if (expr instanceof CurrentTimestampExpression) {
            return new ExprTimestampNode();
        }
        if (expr instanceof TimePeriodExpression) {
            TimePeriodExpression tpe = (TimePeriodExpression)expr;
            return new ExprTimePeriod(tpe.isHasDays(), tpe.isHasHours(), tpe.isHasMinutes(), tpe.isHasSeconds(), tpe.isHasMilliseconds());
        }
        if (expr instanceof CompareListExpression) {
            CompareListExpression exp = (CompareListExpression)expr;
            if (exp.getOperator().equals("=") || exp.getOperator().equals("!=")) {
                return new ExprEqualsAllAnyNode(exp.getOperator().equals("!="), exp.isAll());
            }
            return new ExprRelationalOpAllAnyNode(RelationalOpEnum.parse(exp.getOperator()), exp.isAll());
        }
        if (expr instanceof SubstitutionParameterExpression) {
            SubstitutionParameterExpression node = (SubstitutionParameterExpression)expr;
            if (!node.isSatisfied()) {
                throw new EPException("Substitution parameter value for index " + node.getIndex() + " not set, please provide a value for this parameter");
            }
            return new ExprConstantNode(node.getConstant());
        }
        if (expr instanceof PlugInProjectionExpression) {
            PlugInProjectionExpression node = (PlugInProjectionExpression)expr;
            try {
                AggregationSupport aggregation = mapContext.getEngineImportService().resolveAggregation(node.getFunctionName());
                return new ExprPlugInAggFunctionNode(node.isDistinct(), aggregation, node.getFunctionName());
            }
            catch (Exception e) {
                ExprNode exprNode = mapContext.getEngineImportService().resolveAggExtendedBuiltin(node.getFunctionName(), node.isDistinct());
                if (exprNode != null) {
                    return exprNode;
                }
                throw new EPException("Error resolving aggregation: " + e.getMessage(), e);
            }
        }
        if (expr instanceof OrderedObjectParamExpression) {
            OrderedObjectParamExpression order = (OrderedObjectParamExpression)expr;
            return new ExprOrderedExpr(order.isDescending());
        }
        if (expr instanceof CrontabFrequencyExpression) {
            return new ExprNumberSetFrequency();
        }
        if (expr instanceof CrontabRangeExpression) {
            return new ExprNumberSetRange();
        }
        if (expr instanceof CrontabParameterSetExpression) {
            return new ExprNumberSetList();
        }
        if (expr instanceof CrontabParameterExpression) {
            CronOperatorEnum operator;
            CrontabParameterExpression cronParam = (CrontabParameterExpression)expr;
            if (cronParam.getType() == ScheduleItemType.WILDCARD) {
                return new ExprNumberSetWildcard();
            }
            if (cronParam.getType() == ScheduleItemType.LASTDAY) {
                operator = CronOperatorEnum.LASTDAY;
            } else if (cronParam.getType() == ScheduleItemType.WEEKDAY) {
                operator = CronOperatorEnum.WEEKDAY;
            } else if (cronParam.getType() == ScheduleItemType.LASTWEEKDAY) {
                operator = CronOperatorEnum.LASTWEEKDAY;
            } else {
                throw new IllegalArgumentException("Cron parameter not recognized: " + (Object)((Object)cronParam.getType()));
            }
            return new ExprNumberSetCronParam(operator);
        }
        throw new IllegalArgumentException("Could not map expression node of type " + expr.getClass().getSimpleName());
    }

    private static List<Expression> unmapExpressionDeep(List<ExprNode> expressions, StatementSpecUnMapContext unmapContext) {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (ExprNode expr : expressions) {
            result.add(StatementSpecMapper.unmapExpressionDeep(expr, unmapContext));
        }
        return result;
    }

    private static MatchRecognizeRegEx unmapExpressionFlatRowregex(RowRegexExprNode expr, StatementSpecUnMapContext unmapContext) {
        if (expr instanceof RowRegexExprNodeAlteration) {
            return new MatchRecognizeRegExAlteration();
        }
        if (expr instanceof RowRegexExprNodeAtom) {
            RowRegexExprNodeAtom atom = (RowRegexExprNodeAtom)expr;
            return new MatchRecognizeRegExAtom(atom.getTag(), MatchRecogizePatternElementType.values()[atom.getType().ordinal()]);
        }
        if (expr instanceof RowRegexExprNodeConcatenation) {
            return new MatchRecognizeRegExConcatenation();
        }
        RowRegexExprNodeNested nested = (RowRegexExprNodeNested)expr;
        return new MatchRecognizeRegExNested(MatchRecogizePatternElementType.values()[nested.getType().ordinal()]);
    }

    private static RowRegexExprNode mapExpressionFlatRowregex(MatchRecognizeRegEx expr, StatementSpecMapContext mapContext) {
        if (expr instanceof MatchRecognizeRegExAlteration) {
            return new RowRegexExprNodeAlteration();
        }
        if (expr instanceof MatchRecognizeRegExAtom) {
            MatchRecognizeRegExAtom atom = (MatchRecognizeRegExAtom)expr;
            return new RowRegexExprNodeAtom(atom.getName(), RegexNFATypeEnum.values()[atom.getType().ordinal()]);
        }
        if (expr instanceof MatchRecognizeRegExConcatenation) {
            return new RowRegexExprNodeConcatenation();
        }
        MatchRecognizeRegExNested nested = (MatchRecognizeRegExNested)expr;
        return new RowRegexExprNodeNested(RegexNFATypeEnum.values()[nested.getType().ordinal()]);
    }

    private static Expression unmapExpressionFlat(ExprNode expr, StatementSpecUnMapContext unmapContext) {
        if (expr instanceof ExprMathNode) {
            ExprMathNode math = (ExprMathNode)expr;
            return new ArithmaticExpression(math.getMathArithTypeEnum().getExpressionText());
        }
        if (expr instanceof ExprIdentNode) {
            ExprIdentNode prop = (ExprIdentNode)expr;
            String propertyName = prop.getUnresolvedPropertyName();
            if (prop.getStreamOrPropertyName() != null) {
                propertyName = prop.getStreamOrPropertyName() + "." + prop.getUnresolvedPropertyName();
            }
            return new PropertyValueExpression(propertyName);
        }
        if (expr instanceof ExprVariableNode) {
            ExprVariableNode prop = (ExprVariableNode)expr;
            String propertyName = prop.getVariableName();
            return new PropertyValueExpression(propertyName);
        }
        if (expr instanceof ExprEqualsNode) {
            ExprEqualsNode equals = (ExprEqualsNode)expr;
            String operator = "=";
            if (equals.isNotEquals()) {
                operator = "!=";
            }
            return new RelationalOpExpression(operator);
        }
        if (expr instanceof ExprRelationalOpNode) {
            ExprRelationalOpNode rel = (ExprRelationalOpNode)expr;
            return new RelationalOpExpression(rel.getRelationalOpEnum().getExpressionText());
        }
        if (expr instanceof ExprAndNode) {
            return new Conjunction();
        }
        if (expr instanceof ExprOrNode) {
            return new Disjunction();
        }
        if (expr instanceof ExprConstantNode) {
            ExprConstantNode constNode = (ExprConstantNode)expr;
            String constantType = null;
            if (constNode.getType() != null) {
                constantType = constNode.getType().getName();
            }
            return new ConstantExpression(constNode.getValue(), constantType);
        }
        if (expr instanceof ExprConcatNode) {
            return new ConcatExpression();
        }
        if (expr instanceof ExprSubselectRowNode) {
            ExprSubselectRowNode sub = (ExprSubselectRowNode)expr;
            StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(sub.getStatementSpecRaw());
            unmapContext.addAll(unmapped.getIndexedParams());
            return new SubqueryExpression(unmapped.getObjectModel());
        }
        if (expr instanceof ExprSubselectInNode) {
            ExprSubselectInNode sub = (ExprSubselectInNode)expr;
            StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(sub.getStatementSpecRaw());
            unmapContext.addAll(unmapped.getIndexedParams());
            return new SubqueryInExpression(unmapped.getObjectModel(), sub.isNotIn());
        }
        if (expr instanceof ExprSubselectExistsNode) {
            ExprSubselectExistsNode sub = (ExprSubselectExistsNode)expr;
            StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(sub.getStatementSpecRaw());
            unmapContext.addAll(unmapped.getIndexedParams());
            return new SubqueryExistsExpression(unmapped.getObjectModel());
        }
        if (expr instanceof ExprSubselectAllSomeAnyNode) {
            ExprSubselectAllSomeAnyNode sub = (ExprSubselectAllSomeAnyNode)expr;
            StatementSpecUnMapResult unmapped = StatementSpecMapper.unmap(sub.getStatementSpecRaw());
            unmapContext.addAll(unmapped.getIndexedParams());
            String operator = "=";
            if (sub.isNot()) {
                operator = "!=";
            }
            if (sub.getRelationalOp() != null) {
                operator = sub.getRelationalOp().getExpressionText();
            }
            return new SubqueryQualifiedExpression(unmapped.getObjectModel(), operator, sub.isAll());
        }
        if (expr instanceof ExprCountNode) {
            ExprCountNode sub = (ExprCountNode)expr;
            if (sub.getChildNodes().size() == 0) {
                return new CountStarProjectionExpression();
            }
            return new CountProjectionExpression(sub.isDistinct());
        }
        if (expr instanceof ExprAvgNode) {
            ExprAvgNode sub = (ExprAvgNode)expr;
            return new AvgProjectionExpression(sub.isDistinct());
        }
        if (expr instanceof ExprSumNode) {
            ExprSumNode sub = (ExprSumNode)expr;
            return new SumProjectionExpression(sub.isDistinct());
        }
        if (expr instanceof ExprBetweenNode) {
            ExprBetweenNode between = (ExprBetweenNode)expr;
            return new BetweenExpression(between.isLowEndpointIncluded(), between.isHighEndpointIncluded(), between.isNotBetween());
        }
        if (expr instanceof ExprPriorNode) {
            return new PriorExpression();
        }
        if (expr instanceof ExprRateAggNode) {
            return new PlugInProjectionExpression("rate", false);
        }
        if (expr instanceof ExprNthAggNode) {
            return new PlugInProjectionExpression("nth", false);
        }
        if (expr instanceof ExprLeavingAggNode) {
            return new PlugInProjectionExpression("leaving", false);
        }
        if (expr instanceof ExprPreviousNode) {
            return new PreviousExpression();
        }
        if (expr instanceof ExprStaticMethodNode) {
            ExprStaticMethodNode node = (ExprStaticMethodNode)expr;
            return new StaticMethodExpression(node.getClassName(), node.getMethodName());
        }
        if (expr instanceof ExprMinMaxAggrNode) {
            ExprMinMaxAggrNode node = (ExprMinMaxAggrNode)expr;
            if (node.getMinMaxTypeEnum() == MinMaxTypeEnum.MIN) {
                return new MinProjectionExpression(node.isDistinct());
            }
            return new MaxProjectionExpression(node.isDistinct());
        }
        if (expr instanceof ExprNotNode) {
            return new NotExpression();
        }
        if (expr instanceof ExprInNode) {
            ExprInNode in = (ExprInNode)expr;
            return new InExpression(in.isNotIn());
        }
        if (expr instanceof ExprCoalesceNode) {
            return new CoalesceExpression();
        }
        if (expr instanceof ExprCaseNode) {
            ExprCaseNode mycase = (ExprCaseNode)expr;
            if (mycase.isCase2()) {
                return new CaseSwitchExpression();
            }
            return new CaseWhenThenExpression();
        }
        if (expr instanceof ExprMinMaxRowNode) {
            ExprMinMaxRowNode node = (ExprMinMaxRowNode)expr;
            if (node.getMinMaxTypeEnum() == MinMaxTypeEnum.MAX) {
                return new MaxRowExpression();
            }
            return new MinRowExpression();
        }
        if (expr instanceof ExprBitWiseNode) {
            ExprBitWiseNode node = (ExprBitWiseNode)expr;
            return new BitwiseOpExpression(node.getBitWiseOpEnum());
        }
        if (expr instanceof ExprArrayNode) {
            return new ArrayExpression();
        }
        if (expr instanceof ExprLikeNode) {
            ExprLikeNode exprLikeNode = (ExprLikeNode)expr;
            return new LikeExpression(exprLikeNode.isNot());
        }
        if (expr instanceof ExprRegexpNode) {
            ExprRegexpNode exprRegexNode = (ExprRegexpNode)expr;
            return new RegExpExpression(exprRegexNode.isNot());
        }
        if (expr instanceof ExprMedianNode) {
            ExprMedianNode median = (ExprMedianNode)expr;
            return new MedianProjectionExpression(median.isDistinct());
        }
        if (expr instanceof ExprLastNode) {
            ExprLastNode last = (ExprLastNode)expr;
            return new LastProjectionExpression(last.isDistinct());
        }
        if (expr instanceof ExprFirstNode) {
            ExprFirstNode first = (ExprFirstNode)expr;
            return new FirstProjectionExpression(first.isDistinct());
        }
        if (expr instanceof ExprAvedevNode) {
            ExprAvedevNode node = (ExprAvedevNode)expr;
            return new AvedevProjectionExpression(node.isDistinct());
        }
        if (expr instanceof ExprStddevNode) {
            ExprStddevNode node = (ExprStddevNode)expr;
            return new StddevProjectionExpression(node.isDistinct());
        }
        if (expr instanceof ExprPlugInAggFunctionNode) {
            ExprPlugInAggFunctionNode node = (ExprPlugInAggFunctionNode)expr;
            return new PlugInProjectionExpression(node.getAggregationFunctionName(), node.isDistinct());
        }
        if (expr instanceof ExprInstanceofNode) {
            ExprInstanceofNode node = (ExprInstanceofNode)expr;
            return new InstanceOfExpression(node.getClassIdentifiers());
        }
        if (expr instanceof ExprCastNode) {
            ExprCastNode node = (ExprCastNode)expr;
            return new CastExpression(node.getClassIdentifier());
        }
        if (expr instanceof ExprPropertyExistsNode) {
            return new PropertyExistsExpression();
        }
        if (expr instanceof ExprTimestampNode) {
            return new CurrentTimestampExpression();
        }
        if (expr instanceof ExprSubstitutionNode) {
            ExprSubstitutionNode node = (ExprSubstitutionNode)expr;
            SubstitutionParameterExpression subParam = new SubstitutionParameterExpression(node.getIndex());
            unmapContext.add(node.getIndex(), subParam);
            return subParam;
        }
        if (expr instanceof ExprTimePeriod) {
            ExprTimePeriod node = (ExprTimePeriod)expr;
            return new TimePeriodExpression(node.isHasDay(), node.isHasHour(), node.isHasMinute(), node.isHasSecond(), node.isHasMillisecond());
        }
        if (expr instanceof ExprNumberSetWildcard) {
            return new CrontabParameterExpression(ScheduleItemType.WILDCARD);
        }
        if (expr instanceof ExprNumberSetFrequency) {
            return new CrontabFrequencyExpression();
        }
        if (expr instanceof ExprNumberSetRange) {
            return new CrontabRangeExpression();
        }
        if (expr instanceof ExprNumberSetList) {
            return new CrontabParameterSetExpression();
        }
        if (expr instanceof ExprOrderedExpr) {
            ExprOrderedExpr order = (ExprOrderedExpr)expr;
            return new OrderedObjectParamExpression(order.isDescending());
        }
        if (expr instanceof ExprEqualsAllAnyNode) {
            ExprEqualsAllAnyNode node = (ExprEqualsAllAnyNode)expr;
            String operator = node.isNot() ? "!=" : "=";
            return new CompareListExpression(node.isAll(), operator);
        }
        if (expr instanceof ExprRelationalOpAllAnyNode) {
            ExprRelationalOpAllAnyNode node = (ExprRelationalOpAllAnyNode)expr;
            return new CompareListExpression(node.isAll(), node.getRelationalOpEnum().getExpressionText());
        }
        if (expr instanceof ExprNumberSetCronParam) {
            ScheduleItemType type;
            ExprNumberSetCronParam cronParam = (ExprNumberSetCronParam)expr;
            if (cronParam.getCronOperator() == CronOperatorEnum.LASTDAY) {
                type = ScheduleItemType.LASTDAY;
            } else if (cronParam.getCronOperator() == CronOperatorEnum.LASTWEEKDAY) {
                type = ScheduleItemType.LASTWEEKDAY;
            } else if (cronParam.getCronOperator() == CronOperatorEnum.WEEKDAY) {
                type = ScheduleItemType.WEEKDAY;
            } else {
                throw new IllegalArgumentException("Cron parameter not recognized: " + (Object)((Object)cronParam.getCronOperator()));
            }
            return new CrontabParameterExpression(type);
        }
        throw new IllegalArgumentException("Could not map expression node of type " + expr.getClass().getSimpleName());
    }

    private static void unmapExpressionRecursive(Expression parent, ExprNode expr, StatementSpecUnMapContext unmapContext) {
        for (ExprNode child : expr.getChildNodes()) {
            Expression result = StatementSpecMapper.unmapExpressionFlat(child, unmapContext);
            parent.getChildren().add(result);
            StatementSpecMapper.unmapExpressionRecursive(result, child, unmapContext);
        }
    }

    private static void unmapExpressionRecursiveRowregex(MatchRecognizeRegEx parent, RowRegexExprNode expr, StatementSpecUnMapContext unmapContext) {
        for (RowRegexExprNode child : expr.getChildNodes()) {
            MatchRecognizeRegEx result = StatementSpecMapper.unmapExpressionFlatRowregex(child, unmapContext);
            parent.getChildren().add(result);
            StatementSpecMapper.unmapExpressionRecursiveRowregex(result, child, unmapContext);
        }
    }

    private static void mapExpressionRecursive(ExprNode parent, Expression expr, StatementSpecMapContext mapContext) {
        for (Expression child : expr.getChildren()) {
            ExprNode result = StatementSpecMapper.mapExpressionFlat(child, mapContext);
            parent.addChildNode(result);
            StatementSpecMapper.mapExpressionRecursive(result, child, mapContext);
        }
    }

    private static void mapExpressionRecursiveRowregex(RowRegexExprNode parent, MatchRecognizeRegEx expr, StatementSpecMapContext mapContext) {
        for (MatchRecognizeRegEx child : expr.getChildren()) {
            RowRegexExprNode result = StatementSpecMapper.mapExpressionFlatRowregex(child, mapContext);
            parent.addChildNode(result);
            StatementSpecMapper.mapExpressionRecursiveRowregex(result, child, mapContext);
        }
    }

    private static void mapFrom(FromClause fromClause, StatementSpecRaw raw, StatementSpecMapContext mapContext) {
        if (fromClause == null) {
            return;
        }
        for (Stream stream : fromClause.getStreams()) {
            StreamSpecBase spec;
            StreamSpecOptions options;
            if (stream instanceof FilterStream) {
                FilterStream filterStream = (FilterStream)stream;
                FilterSpecRaw filterSpecRaw = StatementSpecMapper.mapFilter(filterStream.getFilter(), mapContext);
                options = StatementSpecMapper.mapStreamOpts(filterStream);
                spec = new FilterStreamSpecRaw(filterSpecRaw, new ArrayList<ViewSpec>(), filterStream.getStreamName(), options);
            } else if (stream instanceof SQLStream) {
                SQLStream sqlStream = (SQLStream)stream;
                spec = new DBStatementStreamSpec(sqlStream.getStreamName(), new ArrayList<ViewSpec>(), sqlStream.getDatabaseName(), sqlStream.getSqlWithSubsParams(), sqlStream.getOptionalMetadataSQL());
            } else if (stream instanceof PatternStream) {
                PatternStream patternStream = (PatternStream)stream;
                EvalNode child = StatementSpecMapper.mapPatternEvalDeep(patternStream.getExpression(), mapContext);
                options = StatementSpecMapper.mapStreamOpts(patternStream);
                spec = new PatternStreamSpecRaw(child, new ArrayList<ViewSpec>(), patternStream.getStreamName(), options);
            } else if (stream instanceof MethodInvocationStream) {
                MethodInvocationStream methodStream = (MethodInvocationStream)stream;
                ArrayList<ExprNode> expressions = new ArrayList<ExprNode>();
                for (Expression expr : methodStream.getParameterExpressions()) {
                    ExprNode exprNode = StatementSpecMapper.mapExpressionDeep(expr, mapContext);
                    expressions.add(exprNode);
                }
                spec = new MethodStreamSpec(methodStream.getStreamName(), new ArrayList<ViewSpec>(), "method", methodStream.getClassName(), methodStream.getMethodName(), expressions);
            } else {
                throw new IllegalArgumentException("Could not map from stream " + stream + " to an internal representation");
            }
            raw.getStreamSpecs().add((StreamSpecRaw)((Object)spec));
            if (!(stream instanceof ProjectedStream)) continue;
            ProjectedStream projectedStream = (ProjectedStream)stream;
            spec.getViewSpecs().addAll(StatementSpecMapper.mapViews(projectedStream.getViews(), mapContext));
        }
        for (OuterJoinQualifier qualifier : fromClause.getOuterJoinQualifiers()) {
            ExprIdentNode left = (ExprIdentNode)StatementSpecMapper.mapExpressionFlat(qualifier.getLeft(), mapContext);
            ExprIdentNode right = (ExprIdentNode)StatementSpecMapper.mapExpressionFlat(qualifier.getRight(), mapContext);
            ExprIdentNode[] additionalLeft = null;
            ExprIdentNode[] additionalRight = null;
            if (qualifier.getAdditionalProperties().size() != 0) {
                additionalLeft = new ExprIdentNode[qualifier.getAdditionalProperties().size()];
                additionalRight = new ExprIdentNode[qualifier.getAdditionalProperties().size()];
                int count = 0;
                for (PropertyValueExpressionPair pair : qualifier.getAdditionalProperties()) {
                    additionalLeft[count] = (ExprIdentNode)StatementSpecMapper.mapExpressionFlat(pair.getLeft(), mapContext);
                    additionalRight[count] = (ExprIdentNode)StatementSpecMapper.mapExpressionFlat(pair.getRight(), mapContext);
                    ++count;
                }
            }
            raw.getOuterJoinDescList().add(new OuterJoinDesc(qualifier.getType(), left, right, additionalLeft, additionalRight));
        }
    }

    private static List<ViewSpec> mapViews(List<View> views, StatementSpecMapContext mapContext) {
        ArrayList<ViewSpec> viewSpecs = new ArrayList<ViewSpec>();
        for (View view : views) {
            List<ExprNode> viewExpressions = StatementSpecMapper.mapExpressionDeep(view.getParameters(), mapContext);
            viewSpecs.add(new ViewSpec(view.getNamespace(), view.getName(), viewExpressions));
        }
        return viewSpecs;
    }

    private static List<View> unmapViews(List<ViewSpec> viewSpecs, StatementSpecUnMapContext unmapContext) {
        ArrayList<View> views = new ArrayList<View>();
        for (ViewSpec viewSpec : viewSpecs) {
            List<Expression> viewExpressions = StatementSpecMapper.unmapExpressionDeep(viewSpec.getObjectParameters(), unmapContext);
            views.add(View.create(viewSpec.getObjectNamespace(), viewSpec.getObjectName(), viewExpressions));
        }
        return views;
    }

    private static EvalNode mapPatternEvalFlat(PatternExpr eval, StatementSpecMapContext mapContext) {
        if (eval == null) {
            throw new IllegalArgumentException("Null expression parameter");
        }
        if (eval instanceof PatternAndExpr) {
            return new EvalAndNode();
        }
        if (eval instanceof PatternOrExpr) {
            return new EvalOrNode();
        }
        if (eval instanceof PatternFollowedByExpr) {
            return new EvalFollowedByNode();
        }
        if (eval instanceof PatternEveryExpr) {
            return new EvalEveryNode();
        }
        if (eval instanceof PatternFilterExpr) {
            PatternFilterExpr filterExpr = (PatternFilterExpr)eval;
            FilterSpecRaw filterSpec = StatementSpecMapper.mapFilter(filterExpr.getFilter(), mapContext);
            return new EvalFilterNode(filterSpec, filterExpr.getTagName());
        }
        if (eval instanceof PatternObserverExpr) {
            PatternObserverExpr observer = (PatternObserverExpr)eval;
            List<ExprNode> expressions = StatementSpecMapper.mapExpressionDeep(observer.getParameters(), mapContext);
            return new EvalObserverNode(new PatternObserverSpec(observer.getNamespace(), observer.getName(), expressions));
        }
        if (eval instanceof PatternGuardExpr) {
            PatternGuardExpr guard = (PatternGuardExpr)eval;
            List<ExprNode> expressions = StatementSpecMapper.mapExpressionDeep(guard.getParameters(), mapContext);
            return new EvalGuardNode(new PatternGuardSpec(guard.getNamespace(), guard.getName(), expressions));
        }
        if (eval instanceof PatternNotExpr) {
            return new EvalNotNode();
        }
        if (eval instanceof PatternMatchUntilExpr) {
            PatternMatchUntilExpr until = (PatternMatchUntilExpr)eval;
            return new EvalMatchUntilNode(new EvalMatchUntilSpec(until.getLow(), until.getHigh()));
        }
        if (eval instanceof PatternEveryDistinctExpr) {
            PatternEveryDistinctExpr everyDist = (PatternEveryDistinctExpr)eval;
            List<ExprNode> expressions = StatementSpecMapper.mapExpressionDeep(everyDist.getExpressions(), mapContext);
            return new EvalEveryDistinctNode(expressions, null);
        }
        throw new IllegalArgumentException("Could not map pattern expression node of type " + eval.getClass().getSimpleName());
    }

    private static PatternExpr unmapPatternEvalFlat(EvalNode eval, StatementSpecUnMapContext unmapContext) {
        if (eval instanceof EvalAndNode) {
            return new PatternAndExpr();
        }
        if (eval instanceof EvalOrNode) {
            return new PatternOrExpr();
        }
        if (eval instanceof EvalFollowedByNode) {
            return new PatternFollowedByExpr();
        }
        if (eval instanceof EvalEveryNode) {
            return new PatternEveryExpr();
        }
        if (eval instanceof EvalNotNode) {
            return new PatternNotExpr();
        }
        if (eval instanceof EvalFilterNode) {
            EvalFilterNode filterNode = (EvalFilterNode)eval;
            Filter filter = StatementSpecMapper.unmapFilter(filterNode.getRawFilterSpec(), unmapContext);
            return new PatternFilterExpr(filter, filterNode.getEventAsName());
        }
        if (eval instanceof EvalObserverNode) {
            EvalObserverNode observerNode = (EvalObserverNode)eval;
            List<Expression> expressions = StatementSpecMapper.unmapExpressionDeep(observerNode.getPatternObserverSpec().getObjectParameters(), unmapContext);
            return new PatternObserverExpr(observerNode.getPatternObserverSpec().getObjectNamespace(), observerNode.getPatternObserverSpec().getObjectName(), expressions);
        }
        if (eval instanceof EvalGuardNode) {
            EvalGuardNode guardNode = (EvalGuardNode)eval;
            List<Expression> expressions = StatementSpecMapper.unmapExpressionDeep(guardNode.getPatternGuardSpec().getObjectParameters(), unmapContext);
            return new PatternGuardExpr(guardNode.getPatternGuardSpec().getObjectNamespace(), guardNode.getPatternGuardSpec().getObjectName(), expressions);
        }
        if (eval instanceof EvalMatchUntilNode) {
            EvalMatchUntilNode matchUntilNode = (EvalMatchUntilNode)eval;
            return new PatternMatchUntilExpr(matchUntilNode.getSpec().getLowerBounds(), matchUntilNode.getSpec().getUpperBounds());
        }
        if (eval instanceof EvalEveryDistinctNode) {
            EvalEveryDistinctNode everyDistinctNode = (EvalEveryDistinctNode)eval;
            List<Expression> expressions = StatementSpecMapper.unmapExpressionDeep(everyDistinctNode.getExpressions(), unmapContext);
            return new PatternEveryDistinctExpr(expressions);
        }
        throw new IllegalArgumentException("Could not map pattern expression node of type " + eval.getClass().getSimpleName());
    }

    private static void unmapPatternEvalRecursive(PatternExpr parent, EvalNode eval, StatementSpecUnMapContext unmapContext) {
        for (EvalNode child : eval.getChildNodes()) {
            PatternExpr result = StatementSpecMapper.unmapPatternEvalFlat(child, unmapContext);
            parent.getChildren().add(result);
            StatementSpecMapper.unmapPatternEvalRecursive(result, child, unmapContext);
        }
    }

    private static void mapPatternEvalRecursive(EvalNode parent, PatternExpr expr, StatementSpecMapContext mapContext) {
        for (PatternExpr child : expr.getChildren()) {
            EvalNode result = StatementSpecMapper.mapPatternEvalFlat(child, mapContext);
            parent.addChildNode(result);
            StatementSpecMapper.mapPatternEvalRecursive(result, child, mapContext);
        }
    }

    private static PatternExpr unmapPatternEvalDeep(EvalNode exprNode, StatementSpecUnMapContext unmapContext) {
        PatternExpr parent = StatementSpecMapper.unmapPatternEvalFlat(exprNode, unmapContext);
        StatementSpecMapper.unmapPatternEvalRecursive(parent, exprNode, unmapContext);
        return parent;
    }

    private static EvalNode mapPatternEvalDeep(PatternExpr expr, StatementSpecMapContext mapContext) {
        EvalNode parent = StatementSpecMapper.mapPatternEvalFlat(expr, mapContext);
        StatementSpecMapper.mapPatternEvalRecursive(parent, expr, mapContext);
        return parent;
    }

    private static FilterSpecRaw mapFilter(Filter filter, StatementSpecMapContext mapContext) {
        ArrayList<ExprNode> expr = new ArrayList<ExprNode>();
        if (filter.getFilter() != null) {
            ExprNode exprNode = StatementSpecMapper.mapExpressionDeep(filter.getFilter(), mapContext);
            expr.add(exprNode);
        }
        PropertyEvalSpec evalSpec = null;
        if (filter.getOptionalPropertySelects() != null) {
            evalSpec = new PropertyEvalSpec();
            for (ContainedEventSelect propertySelect : filter.getOptionalPropertySelects()) {
                SelectClauseSpecRaw selectSpec = null;
                if (propertySelect.getSelectClause() != null) {
                    selectSpec = StatementSpecMapper.mapSelectRaw(propertySelect.getSelectClause(), mapContext);
                }
                ExprNode exprNodeWhere = null;
                if (propertySelect.getWhereClause() != null) {
                    exprNodeWhere = StatementSpecMapper.mapExpressionDeep(propertySelect.getWhereClause(), mapContext);
                }
                evalSpec.add(new PropertyEvalAtom(propertySelect.getPropertyName(), propertySelect.getPropertyAsName(), selectSpec, exprNodeWhere));
            }
        }
        return new FilterSpecRaw(filter.getEventTypeName(), expr, evalSpec);
    }

    private static Filter unmapFilter(FilterSpecRaw filter, StatementSpecUnMapContext unmapContext) {
        Expression expr = null;
        if (filter.getFilterExpressions().size() > 1) {
            expr = new Conjunction();
            for (ExprNode exprNode : filter.getFilterExpressions()) {
                Expression expression = StatementSpecMapper.unmapExpressionDeep(exprNode, unmapContext);
                expr.getChildren().add(expression);
            }
        } else if (filter.getFilterExpressions().size() == 1) {
            expr = StatementSpecMapper.unmapExpressionDeep(filter.getFilterExpressions().get(0), unmapContext);
        }
        Filter filterDef = new Filter(filter.getEventTypeName(), expr);
        if (filter.getOptionalPropertyEvalSpec() != null) {
            ArrayList<ContainedEventSelect> propertySelects = new ArrayList<ContainedEventSelect>();
            for (PropertyEvalAtom atom : filter.getOptionalPropertyEvalSpec().getAtoms()) {
                SelectClause selectClause = null;
                if (atom.getOptionalSelectClause() != null) {
                    selectClause = StatementSpecMapper.unmapSelect(atom.getOptionalSelectClause(), SelectClauseStreamSelectorEnum.ISTREAM_ONLY, unmapContext);
                }
                if (selectClause.getSelectList().isEmpty()) {
                    selectClause.getSelectList().add(new SelectClauseWildcard());
                }
                Expression filterExpression = null;
                if (atom.getOptionalWhereClause() != null) {
                    filterExpression = StatementSpecMapper.unmapExpressionDeep(atom.getOptionalWhereClause(), unmapContext);
                }
                propertySelects.add(new ContainedEventSelect(atom.getPropertyName(), atom.getOptionalAsName(), selectClause, filterExpression));
            }
            filterDef.setOptionalPropertySelects(propertySelects);
        }
        return filterDef;
    }

    private static List<AnnotationPart> unmapAnnotations(List<AnnotationDesc> annotations) {
        ArrayList<AnnotationPart> result = new ArrayList<AnnotationPart>();
        for (AnnotationDesc desc : annotations) {
            result.add(StatementSpecMapper.unmapAnnotation(desc));
        }
        return result;
    }

    private static AnnotationPart unmapAnnotation(AnnotationDesc desc) {
        if (desc.getAttributes() == null || desc.getAttributes().isEmpty()) {
            return new AnnotationPart(desc.getName());
        }
        ArrayList<AnnotationAttribute> attributes = new ArrayList<AnnotationAttribute>();
        for (Pair<String, Object> pair : desc.getAttributes()) {
            if (pair.getSecond() instanceof AnnotationDesc) {
                attributes.add(new AnnotationAttribute(pair.getFirst(), StatementSpecMapper.unmapAnnotation((AnnotationDesc)pair.getSecond())));
                continue;
            }
            attributes.add(new AnnotationAttribute(pair.getFirst(), pair.getSecond()));
        }
        return new AnnotationPart(desc.getName(), attributes);
    }

    private static void mapAnnotations(List<AnnotationPart> annotations, StatementSpecRaw raw) {
        List<AnnotationDesc> result;
        if (annotations != null) {
            result = new ArrayList();
            for (AnnotationPart part : annotations) {
                result.add(StatementSpecMapper.mapAnnotation(part));
            }
        } else {
            result = Collections.emptyList();
        }
        raw.setAnnotations(result);
    }

    private static AnnotationDesc mapAnnotation(AnnotationPart part) {
        if (part.getAttributes() == null || part.getAttributes().isEmpty()) {
            return new AnnotationDesc(part.getName(), Collections.EMPTY_LIST);
        }
        ArrayList<Pair<String, Object>> attributes = new ArrayList<Pair<String, Object>>();
        for (AnnotationAttribute pair : part.getAttributes()) {
            if (pair.getValue() instanceof AnnotationPart) {
                attributes.add(new Pair<String, AnnotationDesc>(pair.getName(), StatementSpecMapper.mapAnnotation((AnnotationPart)pair.getValue())));
                continue;
            }
            attributes.add(new Pair<String, Object>(pair.getName(), pair.getValue()));
        }
        return new AnnotationDesc(part.getName(), attributes);
    }
}

