/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.variable;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.SingleEventIterator;
import com.espertech.esper.core.StatementResultService;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OnTriggerSetDesc;
import com.espertech.esper.epl.variable.VariableReadWritePackage;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.ViewSupport;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnSetVariableView
extends ViewSupport {
    private static final Log log = LogFactory.getLog(OnSetVariableView.class);
    private final OnTriggerSetDesc desc;
    private final EventAdapterService eventAdapterService;
    private final VariableService variableService;
    private final EventType eventType;
    private final VariableReadWritePackage variableReadWritePackage;
    private final EventBean[] eventsPerStream = new EventBean[1];
    private final StatementResultService statementResultService;
    private final ExprEvaluatorContext exprEvaluatorContext;

    public OnSetVariableView(OnTriggerSetDesc desc, EventAdapterService eventAdapterService, VariableService variableService, StatementResultService statementResultService, ExprEvaluatorContext exprEvaluatorContext) throws ExprValidationException {
        this.desc = desc;
        this.eventAdapterService = eventAdapterService;
        this.variableService = variableService;
        this.statementResultService = statementResultService;
        this.exprEvaluatorContext = exprEvaluatorContext;
        this.variableReadWritePackage = new VariableReadWritePackage(desc.getAssignments(), variableService, eventAdapterService);
        this.eventType = eventAdapterService.createAnonymousMapType(this.variableReadWritePackage.getVariableTypes());
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        boolean produceOutputEvents;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        if (newData == null || newData.length == 0) {
            return;
        }
        HashMap<String, Object> values = null;
        boolean bl = produceOutputEvents = this.statementResultService.isMakeNatural() || this.statementResultService.isMakeSynthetic();
        if (produceOutputEvents) {
            values = new HashMap<String, Object>();
        }
        this.eventsPerStream[0] = newData[newData.length - 1];
        this.variableReadWritePackage.writeVariables(this.variableService, this.eventsPerStream, values, this.exprEvaluatorContext);
        if (values != null) {
            EventBean[] newDataOut = new EventBean[]{this.eventAdapterService.adaptorForTypedMap(values, this.eventType)};
            this.updateChildren(newDataOut, null);
        }
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Iterator<EventBean> iterator() {
        Map<String, Object> values = this.variableReadWritePackage.iterate();
        EventBean event = this.eventAdapterService.adaptorForTypedMap(values, this.eventType);
        return new SingleEventIterator(event);
    }
}

