/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.core.EPStatementHandleCallback;
import com.espertech.esper.core.ExtensionServicesContext;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeIdentifierVisitor;
import com.espertech.esper.epl.expression.ExprNodeVariableVisitor;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OnTriggerSetAssignment;
import com.espertech.esper.epl.variable.VariableChangeCallback;
import com.espertech.esper.epl.variable.VariableReadWritePackage;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleCallback;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.view.StatementStopCallback;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputConditionExpression
implements OutputCondition,
VariableChangeCallback {
    private static final Log log = LogFactory.getLog(OutputConditionExpression.class);
    private final ExprNode whenExpressionNode;
    private final OutputCallback outputCallback;
    private final ScheduleSlot scheduleSlot;
    private final StatementContext context;
    private final VariableReadWritePackage variableReadWritePackage;
    private boolean isCallbackScheduled;
    private boolean ignoreVariableCallbacks;
    private Map<String, Object> builtinProperties;
    private EventBean[] eventsPerStream;
    private EventType builtinPropertiesEventType;
    private int totalNewEventsCount;
    private int totalOldEventsCount;
    private Long lastOutputTimestamp;

    public OutputConditionExpression(ExprNode whenExpressionNode, List<OnTriggerSetAssignment> assignments, final StatementContext context, OutputCallback outputCallback) throws ExprValidationException {
        this.whenExpressionNode = whenExpressionNode;
        this.outputCallback = outputCallback;
        this.scheduleSlot = context.getScheduleBucket().allocateSlot();
        this.context = context;
        this.eventsPerStream = new EventBean[1];
        ExprNodeVariableVisitor variableVisitor = new ExprNodeVariableVisitor();
        whenExpressionNode.accept(variableVisitor);
        Set<String> variableNames = variableVisitor.getVariableNames();
        boolean containsBuiltinProperties = false;
        if (this.containsBuiltinProperties(whenExpressionNode)) {
            containsBuiltinProperties = true;
        } else if (assignments != null) {
            for (OnTriggerSetAssignment assignment : assignments) {
                if (!this.containsBuiltinProperties(assignment.getExpression())) continue;
                containsBuiltinProperties = true;
            }
        }
        if (containsBuiltinProperties) {
            this.builtinProperties = new HashMap<String, Object>();
            this.builtinPropertiesEventType = OutputConditionExpression.getBuiltInEventType(context.getEventAdapterService());
            this.lastOutputTimestamp = context.getSchedulingService().getTime();
        }
        if (variableNames != null) {
            for (String variableName : variableNames) {
                final VariableReader reader = context.getVariableService().getReader(variableName);
                context.getVariableService().registerCallback(reader.getVariableNumber(), this);
                context.getStatementStopService().addSubscriber(new StatementStopCallback(){

                    public void statementStopped() {
                        context.getVariableService().unregisterCallback(reader.getVariableNumber(), OutputConditionExpression.this);
                    }
                });
            }
        }
        this.variableReadWritePackage = assignments != null ? new VariableReadWritePackage(assignments, context.getVariableService(), context.getEventAdapterService()) : null;
    }

    @Override
    public void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        this.totalNewEventsCount += newEventsCount;
        this.totalOldEventsCount += oldEventsCount;
        boolean isOutput = this.evaluate();
        if (isOutput) {
            this.outputCallback.continueOutputProcessing(true, true);
            this.resetBuiltinProperties();
        }
    }

    @Override
    public void update(Object newValue, Object oldValue) {
        if (this.ignoreVariableCallbacks) {
            log.debug(".update Ignoring variable callback");
            return;
        }
        this.context.getVariableService().setLocalVersion();
        boolean isOutput = this.evaluate();
        if (isOutput && !this.isCallbackScheduled) {
            this.scheduleCallback();
        }
    }

    private boolean evaluate() {
        if (this.builtinProperties != null) {
            this.builtinProperties.put("count_insert", this.totalNewEventsCount);
            this.builtinProperties.put("count_remove", this.totalOldEventsCount);
            this.builtinProperties.put("last_output_timestamp", this.lastOutputTimestamp);
            this.eventsPerStream[0] = this.context.getEventAdapterService().adaptorForTypedMap(this.builtinProperties, this.builtinPropertiesEventType);
        }
        boolean result = false;
        Boolean output = (Boolean)this.whenExpressionNode.evaluate(this.eventsPerStream, true, this.context);
        if (output != null && output.booleanValue()) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleCallback() {
        this.isCallbackScheduled = true;
        long current = this.context.getSchedulingService().getTime();
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".scheduleCallback Scheduled new callback for  afterMsec=0 now=" + current);
        }
        ScheduleHandleCallback callback = new ScheduleHandleCallback(){

            public void scheduledTrigger(ExtensionServicesContext extensionServicesContext) {
                OutputConditionExpression.this.isCallbackScheduled = false;
                OutputConditionExpression.this.outputCallback.continueOutputProcessing(true, true);
                OutputConditionExpression.this.resetBuiltinProperties();
            }
        };
        EPStatementHandleCallback handle = new EPStatementHandleCallback(this.context.getEpStatementHandle(), callback);
        this.context.getSchedulingService().add(0L, (ScheduleHandle)handle, this.scheduleSlot);
        if (this.variableReadWritePackage != null) {
            if (this.builtinProperties != null) {
                this.builtinProperties.put("count_insert", this.totalNewEventsCount);
                this.builtinProperties.put("count_remove", this.totalOldEventsCount);
                this.builtinProperties.put("last_output_timestamp", this.lastOutputTimestamp);
                this.eventsPerStream[0] = this.context.getEventAdapterService().adaptorForTypedMap(this.builtinProperties, this.builtinPropertiesEventType);
            }
            this.ignoreVariableCallbacks = true;
            try {
                this.variableReadWritePackage.writeVariables(this.context.getVariableService(), this.eventsPerStream, null, this.context);
            }
            finally {
                this.ignoreVariableCallbacks = false;
            }
        }
    }

    public static EventType getBuiltInEventType(EventAdapterService eventAdapterService) {
        HashMap<String, Object> outputLimitProperties = new HashMap<String, Object>();
        outputLimitProperties.put("count_insert", Integer.class);
        outputLimitProperties.put("count_remove", Integer.class);
        outputLimitProperties.put("last_output_timestamp", Long.class);
        return eventAdapterService.createAnonymousMapType(outputLimitProperties);
    }

    private void resetBuiltinProperties() {
        if (this.builtinProperties != null) {
            this.totalNewEventsCount = 0;
            this.totalOldEventsCount = 0;
            this.lastOutputTimestamp = this.context.getSchedulingService().getTime();
        }
    }

    private boolean containsBuiltinProperties(ExprNode expr) {
        ExprNodeIdentifierVisitor propertyVisitor = new ExprNodeIdentifierVisitor(false);
        expr.accept(propertyVisitor);
        return !propertyVisitor.getExprProperties().isEmpty();
    }
}

