/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitRateType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.variable.VariableReader;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;
import com.espertech.esper.epl.view.OutputConditionCount;
import com.espertech.esper.epl.view.OutputConditionCrontab;
import com.espertech.esper.epl.view.OutputConditionExpression;
import com.espertech.esper.epl.view.OutputConditionFactory;
import com.espertech.esper.epl.view.OutputConditionFirst;
import com.espertech.esper.epl.view.OutputConditionNull;
import com.espertech.esper.epl.view.OutputConditionTime;
import com.espertech.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OutputConditionFactoryDefault
implements OutputConditionFactory {
    private static final Log log = LogFactory.getLog(OutputConditionFactoryDefault.class);

    public OutputCondition createCondition(OutputLimitSpec outputLimitSpec, StatementContext statementContext, OutputCallback outputCallback) throws ExprValidationException {
        if (outputCallback == null) {
            throw new NullPointerException("Output condition by count requires a non-null callback");
        }
        if (outputLimitSpec == null) {
            return new OutputConditionNull(outputCallback);
        }
        VariableReader reader = null;
        if (outputLimitSpec.getVariableName() != null && (reader = statementContext.getVariableService().getReader(outputLimitSpec.getVariableName())) == null) {
            throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' has not been declared");
        }
        if (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.FIRST) {
            log.debug(".createCondition creating OutputConditionFirst");
            return new OutputConditionFirst(outputLimitSpec, statementContext, outputCallback);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.CRONTAB) {
            return new OutputConditionCrontab(outputLimitSpec.getCrontabAtSchedule(), statementContext, outputCallback);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.WHEN_EXPRESSION) {
            return new OutputConditionExpression(outputLimitSpec.getWhenExpressionNode(), outputLimitSpec.getThenExpressions(), statementContext, outputCallback);
        }
        if (outputLimitSpec.getRateType() == OutputLimitRateType.EVENTS) {
            if (log.isDebugEnabled()) {
                log.debug(".createCondition creating OutputConditionCount with event rate " + outputLimitSpec);
            }
            if (reader != null && !JavaClassHelper.isNumericNonFP(reader.getType())) {
                throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be type integer, long or short");
            }
            int rate = -1;
            if (outputLimitSpec.getRate() != null) {
                rate = outputLimitSpec.getRate().intValue();
            }
            return new OutputConditionCount(rate, reader, outputCallback);
        }
        if (log.isDebugEnabled()) {
            log.debug(".createCondition creating OutputConditionTime with interval length " + outputLimitSpec.getRate());
        }
        if (reader != null && !JavaClassHelper.isNumeric(reader.getType())) {
            throw new IllegalArgumentException("Variable named '" + outputLimitSpec.getVariableName() + "' must be of numeric type");
        }
        return new OutputConditionTime(outputLimitSpec.getTimePeriodExpr(), statementContext, outputCallback);
    }
}

