/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.view.OutputCallback;
import com.espertech.esper.epl.view.OutputCondition;

public class OutputConditionFirst
implements OutputCondition {
    private final OutputCallback outputCallback;
    private final OutputCondition innerCondition;
    private boolean witnessedFirst;

    public OutputConditionFirst(OutputLimitSpec outputLimitSpec, StatementContext statementContext, OutputCallback outputCallback) throws ExprValidationException {
        if (outputCallback == null) {
            throw new NullPointerException("Output condition by count requires a non-null callback");
        }
        this.outputCallback = outputCallback;
        OutputLimitSpec innerSpec = new OutputLimitSpec(outputLimitSpec.getRate(), outputLimitSpec.getVariableName(), outputLimitSpec.getRateType(), OutputLimitLimitType.DEFAULT, outputLimitSpec.getWhenExpressionNode(), outputLimitSpec.getThenExpressions(), outputLimitSpec.getCrontabAtSchedule(), outputLimitSpec.getTimePeriodExpr(), outputLimitSpec.getAfterTimePeriodExpr(), outputLimitSpec.getAfterNumberOfEvents());
        OutputCallback localCallback = this.createCallbackToLocal();
        this.innerCondition = statementContext.getOutputConditionFactory().createCondition(innerSpec, statementContext, localCallback);
        this.witnessedFirst = false;
    }

    public void updateOutputCondition(int newEventsCount, int oldEventsCount) {
        if (!this.witnessedFirst) {
            this.witnessedFirst = true;
            boolean doOutput = true;
            boolean forceUpdate = false;
            this.outputCallback.continueOutputProcessing(doOutput, forceUpdate);
        }
        this.innerCondition.updateOutputCondition(newEventsCount, oldEventsCount);
    }

    private OutputCallback createCallbackToLocal() {
        return new OutputCallback(){

            public void continueOutputProcessing(boolean doOutput, boolean forceUpdate) {
                OutputConditionFirst.this.continueOutputProcessing(forceUpdate);
            }
        };
    }

    private void continueOutputProcessing(boolean forceUpdate) {
        boolean doOutput = !this.witnessedFirst;
        this.outputCallback.continueOutputProcessing(doOutput, forceUpdate);
        this.witnessedFirst = false;
    }
}

