/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprTimePeriod;
import com.espertech.esper.epl.view.OutputProcessView;
import com.espertech.esper.epl.view.OutputStrategy;
import com.espertech.esper.util.AuditPath;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputProcessViewDirect
extends OutputProcessView {
    private static final Log log = LogFactory.getLog(OutputProcessViewDirect.class);

    public OutputProcessViewDirect(ResultSetProcessor resultSetProcessor, OutputStrategy outputStrategy, boolean isInsertInto, StatementContext statementContext, boolean isDistinct, ExprTimePeriod afterTimePeriod, Integer afterConditionNumberOfEvents) {
        super(resultSetProcessor, outputStrategy, isInsertInto, statementContext, isDistinct, afterTimePeriod, afterConditionNumberOfEvents);
        log.debug(".ctor");
        if (resultSetProcessor == null) {
            throw new IllegalArgumentException("Null result set processor, no output processor required");
        }
    }

    @Override
    public void update(EventBean[] newData, EventBean[] oldData) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".update Received update,   newData.length==" + (newData == null ? 0 : newData.length) + "  oldData.length==" + (oldData == null ? 0 : oldData.length));
        }
        boolean isGenerateSynthetic = this.statementResultService.isMakeSynthetic();
        boolean isGenerateNatural = this.statementResultService.isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processViewResult(newData, oldData, isGenerateSynthetic);
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                super.indicateEarlyReturn(newOldEvents);
            }
            return;
        }
        boolean forceOutput = false;
        if (newData == null && oldData == null && (newOldEvents == null || newOldEvents.getFirst() == null && newOldEvents.getSecond() == null)) {
            forceOutput = true;
        }
        if (this.childView != null) {
            this.outputStrategy.output(forceOutput, newOldEvents, this.childView);
        }
    }

    @Override
    public void process(Set<MultiKey<EventBean>> newEvents, Set<MultiKey<EventBean>> oldEvents, ExprEvaluatorContext exprEvaluatorContext) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".process Received update,   newData.length==" + (newEvents == null ? 0 : newEvents.size()) + "  oldData.length==" + (oldEvents == null ? 0 : oldEvents.size()));
        }
        boolean isGenerateSynthetic = this.statementResultService.isMakeSynthetic();
        boolean isGenerateNatural = this.statementResultService.isMakeNatural();
        UniformPair<EventBean[]> newOldEvents = this.resultSetProcessor.processJoinResult(newEvents, oldEvents, isGenerateSynthetic);
        if (!isGenerateSynthetic && !isGenerateNatural) {
            if (AuditPath.isAuditEnabled) {
                super.indicateEarlyReturn(newOldEvents);
            }
            return;
        }
        if (newOldEvents == null) {
            return;
        }
        if (this.childView != null) {
            this.outputStrategy.output(false, newOldEvents, this.childView);
        }
    }
}

