/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.epl.view;

import com.espertech.esper.core.InternalEventRouter;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.core.ResultSetProcessor;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.epl.spec.OutputLimitLimitType;
import com.espertech.esper.epl.spec.OutputLimitRateType;
import com.espertech.esper.epl.spec.OutputLimitSpec;
import com.espertech.esper.epl.spec.SelectClauseStreamSelectorEnum;
import com.espertech.esper.epl.spec.StatementSpecCompiled;
import com.espertech.esper.epl.view.OutputProcessView;
import com.espertech.esper.epl.view.OutputProcessViewDirect;
import com.espertech.esper.epl.view.OutputProcessViewDistinctOrAfter;
import com.espertech.esper.epl.view.OutputProcessViewPolicy;
import com.espertech.esper.epl.view.OutputProcessViewSnapshot;
import com.espertech.esper.epl.view.OutputStrategy;
import com.espertech.esper.epl.view.OutputStrategyPostProcess;
import com.espertech.esper.epl.view.OutputStrategySimple;

public class OutputProcessViewFactory {
    public static OutputProcessView makeView(ResultSetProcessor resultSetProcessor, StatementSpecCompiled statementSpec, StatementContext statementContext, InternalEventRouter internalEventRouter) throws ExprValidationException {
        OutputProcessView outputProcessView;
        OutputStrategy outputStrategy;
        boolean isRouted = false;
        if (statementSpec.getInsertIntoDesc() != null) {
            isRouted = true;
        }
        if (statementSpec.getInsertIntoDesc() != null || statementSpec.getSelectStreamSelectorEnum() == SelectClauseStreamSelectorEnum.RSTREAM_ONLY) {
            boolean isRouteRStream = false;
            if (statementSpec.getInsertIntoDesc() != null) {
                isRouteRStream = !statementSpec.getInsertIntoDesc().isIStream();
            }
            outputStrategy = new OutputStrategyPostProcess(isRouted, isRouteRStream, statementSpec.getSelectStreamSelectorEnum(), internalEventRouter, statementContext.getEpStatementHandle(), statementContext);
        } else {
            outputStrategy = new OutputStrategySimple();
        }
        int streamCount = statementSpec.getStreamSpecs().size();
        OutputLimitSpec outputLimitSpec = statementSpec.getOutputLimitSpec();
        boolean isDistinct = statementSpec.getSelectClauseSpec().isDistinct();
        try {
            outputProcessView = outputLimitSpec == null ? (!isDistinct ? new OutputProcessViewDirect(resultSetProcessor, outputStrategy, isRouted, statementContext, false, null, null) : new OutputProcessViewDistinctOrAfter(resultSetProcessor, outputStrategy, isRouted, statementContext, true, null, null)) : (outputLimitSpec.getRateType() == OutputLimitRateType.AFTER ? new OutputProcessViewDistinctOrAfter(resultSetProcessor, outputStrategy, isRouted, statementContext, isDistinct, outputLimitSpec.getAfterTimePeriodExpr(), outputLimitSpec.getAfterNumberOfEvents()) : (outputLimitSpec.getDisplayLimit() == OutputLimitLimitType.SNAPSHOT ? new OutputProcessViewSnapshot(resultSetProcessor, outputStrategy, isRouted, streamCount, outputLimitSpec, statementContext, isDistinct) : new OutputProcessViewPolicy(resultSetProcessor, outputStrategy, isRouted, streamCount, outputLimitSpec, statementContext, isDistinct)));
        }
        catch (RuntimeException ex) {
            throw new ExprValidationException("Error in the output rate limiting clause: " + ex.getMessage(), ex);
        }
        return outputProcessView;
    }
}

