/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.Configuration;
import com.espertech.esper.client.ConfigurationEventTypeLegacy;
import com.espertech.esper.client.ConfigurationEventTypeXMLDOM;
import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.EventTypeException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.EPRuntimeEventSender;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.event.DecoratingEventBean;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventAdapterServiceHelper;
import com.espertech.esper.event.EventBeanManufactureException;
import com.espertech.esper.event.EventBeanManufacturer;
import com.espertech.esper.event.EventSenderBean;
import com.espertech.esper.event.EventSenderImpl;
import com.espertech.esper.event.EventSenderMap;
import com.espertech.esper.event.EventSenderURIDesc;
import com.espertech.esper.event.EventSenderXMLDOM;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.MappedEventBean;
import com.espertech.esper.event.WrapperEventBean;
import com.espertech.esper.event.WrapperEventType;
import com.espertech.esper.event.WriteablePropertyDescriptor;
import com.espertech.esper.event.bean.BeanEventAdapter;
import com.espertech.esper.event.bean.BeanEventBean;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.bean.BeanEventTypeFactory;
import com.espertech.esper.event.map.MapEventBean;
import com.espertech.esper.event.map.MapEventType;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.SchemaModel;
import com.espertech.esper.event.xml.SchemaXMLEventType;
import com.espertech.esper.event.xml.SimpleXMLEventType;
import com.espertech.esper.event.xml.XMLEventBean;
import com.espertech.esper.plugin.PlugInEventBeanFactory;
import com.espertech.esper.plugin.PlugInEventBeanReflectorContext;
import com.espertech.esper.plugin.PlugInEventRepresentation;
import com.espertech.esper.plugin.PlugInEventTypeHandler;
import com.espertech.esper.plugin.PlugInEventTypeHandlerContext;
import com.espertech.esper.util.URIUtil;
import com.espertech.esper.util.UuidGenerator;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventAdapterServiceImpl
implements EventAdapterService {
    private static Log log = LogFactory.getLog(EventAdapterServiceImpl.class);
    private final ConcurrentHashMap<Class, BeanEventType> typesPerJavaBean;
    private final Map<String, EventType> nameToTypeMap = new HashMap<String, EventType>();
    private final Map<String, PlugInEventTypeHandler> nameToHandlerMap;
    private BeanEventAdapter beanEventAdapter;
    private Map<String, EventType> xmldomRootElementNames = new HashMap<String, EventType>();
    private LinkedHashSet<String> javaPackageNames = new LinkedHashSet();
    private final Map<URI, PlugInEventRepresentation> plugInRepresentations;

    public EventAdapterServiceImpl() {
        this.nameToHandlerMap = new HashMap<String, PlugInEventTypeHandler>();
        this.typesPerJavaBean = new ConcurrentHashMap();
        this.beanEventAdapter = new BeanEventAdapter(this.typesPerJavaBean, this);
        this.plugInRepresentations = new HashMap<URI, PlugInEventRepresentation>();
    }

    @Override
    public Set<WriteablePropertyDescriptor> getWriteableProperties(EventType eventType) {
        return EventAdapterServiceHelper.getWriteableProperties(eventType);
    }

    @Override
    public EventBeanManufacturer getManufacturer(EventType eventType, WriteablePropertyDescriptor[] properties, MethodResolutionService methodResolutionService) throws EventBeanManufactureException {
        return EventAdapterServiceHelper.getManufacturer(this, eventType, properties, methodResolutionService);
    }

    @Override
    public EventType[] getAllTypes() {
        Collection<EventType> types = this.nameToTypeMap.values();
        return types.toArray(new EventType[types.size()]);
    }

    @Override
    public synchronized void addTypeByName(String name, EventType eventType) throws EventAdapterException {
        if (this.nameToTypeMap.containsKey(name)) {
            throw new EventAdapterException("Event type by name '" + name + "' already exists");
        }
        this.nameToTypeMap.put(name, eventType);
    }

    @Override
    public void addEventRepresentation(URI eventRepURI, PlugInEventRepresentation pluginEventRep) throws EventAdapterException {
        if (this.plugInRepresentations.containsKey(eventRepURI)) {
            throw new EventAdapterException("Plug-in event representation URI by name " + eventRepURI + " already exists");
        }
        this.plugInRepresentations.put(eventRepURI, pluginEventRep);
    }

    @Override
    public EventType addPlugInEventType(String eventTypeName, URI[] resolutionURIs, Serializable initializer) throws EventAdapterException {
        if (this.nameToTypeMap.containsKey(eventTypeName)) {
            throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared");
        }
        PlugInEventRepresentation handlingFactory = null;
        URI handledEventTypeURI = null;
        if (resolutionURIs == null || resolutionURIs.length == 0) {
            throw new EventAdapterException("Event type named '" + eventTypeName + "' could not be created as" + " no resolution URIs for dynamic resolution of event type names through a plug-in event representation have been defined");
        }
        for (URI eventTypeURI : resolutionURIs) {
            HashMap<URI, Object> allFactories = new HashMap<URI, Object>(this.plugInRepresentations);
            Collection<Map.Entry<URI, Object>> factories = URIUtil.filterSort(eventTypeURI, allFactories);
            if (factories.isEmpty()) continue;
            for (Map.Entry<URI, Object> entry : factories) {
                PlugInEventTypeHandlerContext context;
                PlugInEventRepresentation factory = (PlugInEventRepresentation)entry.getValue();
                if (!factory.acceptsType(context = new PlugInEventTypeHandlerContext(eventTypeURI, initializer, eventTypeName))) continue;
                handlingFactory = factory;
                handledEventTypeURI = eventTypeURI;
                break;
            }
            if (handlingFactory != null) break;
        }
        if (handlingFactory == null) {
            throw new EventAdapterException("Event type named '" + eventTypeName + "' could not be created as none of the " + "registered plug-in event representations accepts any of the resolution URIs '" + Arrays.toString(resolutionURIs) + "' and initializer");
        }
        PlugInEventTypeHandlerContext context = new PlugInEventTypeHandlerContext(handledEventTypeURI, initializer, eventTypeName);
        PlugInEventTypeHandler handler = handlingFactory.getTypeHandler(context);
        if (handler == null) {
            throw new EventAdapterException("Event type named '" + eventTypeName + "' could not be created as no handler was returned");
        }
        EventType eventType = handler.getType();
        this.nameToTypeMap.put(eventTypeName, eventType);
        this.nameToHandlerMap.put(eventTypeName, handler);
        return eventType;
    }

    @Override
    public EventSender getStaticTypeEventSender(EPRuntimeEventSender runtimeEventSender, String eventTypeName, ThreadingService threadingService) throws EventTypeException {
        EventType eventType = this.nameToTypeMap.get(eventTypeName);
        if (eventType == null) {
            throw new EventTypeException("Event type named '" + eventTypeName + "' could not be found");
        }
        if (eventType instanceof BeanEventType) {
            return new EventSenderBean(runtimeEventSender, (BeanEventType)eventType, this, threadingService);
        }
        if (eventType instanceof MapEventType) {
            return new EventSenderMap(runtimeEventSender, (MapEventType)eventType, this, threadingService);
        }
        if (eventType instanceof BaseXMLEventType) {
            return new EventSenderXMLDOM(runtimeEventSender, (BaseXMLEventType)eventType, this, threadingService);
        }
        PlugInEventTypeHandler handlers = this.nameToHandlerMap.get(eventTypeName);
        if (handlers != null) {
            return handlers.getSender(runtimeEventSender);
        }
        throw new EventTypeException("An event sender for event type named '" + eventTypeName + "' could not be created as the type is internal");
    }

    @Override
    public void updateMapEventType(String mapeventTypeName, Map<String, Object> typeMap) throws EventAdapterException {
        EventType type = this.nameToTypeMap.get(mapeventTypeName);
        if (type == null) {
            throw new EventAdapterException("Event type name '" + mapeventTypeName + "' has not been declared");
        }
        if (!(type instanceof MapEventType)) {
            throw new EventAdapterException("Event type by name '" + mapeventTypeName + "' is not a Map event type");
        }
        MapEventType mapEventType = (MapEventType)type;
        mapEventType.addAdditionalProperties(typeMap, this);
    }

    @Override
    public EventSender getDynamicTypeEventSender(EPRuntimeEventSender epRuntime, URI[] uri, ThreadingService threadingService) throws EventTypeException {
        ArrayList<EventSenderURIDesc> handlingFactories = new ArrayList<EventSenderURIDesc>();
        for (URI resolutionURI : uri) {
            HashMap<URI, Object> allFactories = new HashMap<URI, Object>(this.plugInRepresentations);
            Collection<Map.Entry<URI, Object>> factories = URIUtil.filterSort(resolutionURI, allFactories);
            if (factories.isEmpty()) continue;
            for (Map.Entry<URI, Object> entry : factories) {
                PlugInEventBeanReflectorContext context;
                PlugInEventRepresentation factory = (PlugInEventRepresentation)entry.getValue();
                if (!factory.acceptsEventBeanResolution(context = new PlugInEventBeanReflectorContext(resolutionURI))) continue;
                PlugInEventBeanFactory beanFactory = factory.getEventBeanFactory(context);
                if (beanFactory == null) {
                    log.warn("Plug-in event representation returned a null bean factory, ignoring entry");
                    continue;
                }
                EventSenderURIDesc desc = new EventSenderURIDesc(beanFactory, resolutionURI, entry.getKey());
                handlingFactories.add(desc);
            }
        }
        if (handlingFactories.isEmpty()) {
            throw new EventTypeException("Event sender for resolution URIs '" + Arrays.toString(uri) + "' did not return at least one event representation's event factory");
        }
        return new EventSenderImpl(handlingFactories, epRuntime, threadingService);
    }

    @Override
    public BeanEventTypeFactory getBeanEventTypeFactory() {
        return this.beanEventAdapter;
    }

    @Override
    public void setClassLegacyConfigs(Map<String, ConfigurationEventTypeLegacy> classToLegacyConfigs) {
        this.beanEventAdapter.setClassToLegacyConfigs(classToLegacyConfigs);
    }

    @Override
    public void setDefaultPropertyResolutionStyle(Configuration.PropertyResolutionStyle defaultPropertyResolutionStyle) {
        this.beanEventAdapter.setDefaultPropertyResolutionStyle(defaultPropertyResolutionStyle);
    }

    @Override
    public EventType getExistsTypeByName(String eventTypeName) {
        if (eventTypeName == null) {
            throw new IllegalStateException("Null event type name parameter");
        }
        return this.nameToTypeMap.get(eventTypeName);
    }

    @Override
    public synchronized EventType addBeanType(String eventTypeName, Class clazz, boolean isConfigured) throws EventAdapterException {
        EventType existingType;
        if (log.isDebugEnabled()) {
            log.debug(".addBeanType Adding " + eventTypeName + " for type " + clazz.getName());
        }
        if ((existingType = this.nameToTypeMap.get(eventTypeName)) != null) {
            if (existingType.getUnderlyingType().equals(clazz)) {
                return existingType;
            }
            throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing underlying type information:" + existingType.getUnderlyingType().getName() + " versus " + clazz.getName());
        }
        BeanEventType eventType = this.beanEventAdapter.createBeanType(eventTypeName, clazz, isConfigured);
        this.nameToTypeMap.put(eventTypeName, eventType);
        return eventType;
    }

    @Override
    public EventBean adapterForBean(Object event) {
        EventType eventType = this.typesPerJavaBean.get(event.getClass());
        if (eventType == null) {
            eventType = this.beanEventAdapter.createBeanType(event.getClass().getName(), event.getClass(), false);
        }
        return new BeanEventBean(event, eventType);
    }

    @Override
    public synchronized EventType addBeanType(String eventTypeName, String fullyQualClassName, boolean considerAutoName) throws EventAdapterException {
        Class<?> clazz;
        block11: {
            EventType existingType;
            if (log.isDebugEnabled()) {
                log.debug(".addBeanType Adding " + eventTypeName + " for type " + fullyQualClassName);
            }
            if ((existingType = this.nameToTypeMap.get(eventTypeName)) != null) {
                if (existingType.getUnderlyingType().getName().equals(fullyQualClassName)) {
                    if (log.isDebugEnabled()) {
                        log.debug(".addBeanType Returning existing type for " + eventTypeName);
                    }
                    return existingType;
                }
                throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing underlying type information: Class " + existingType.getUnderlyingType().getName() + " versus " + fullyQualClassName);
            }
            clazz = null;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                clazz = Class.forName(fullyQualClassName, true, cl);
            }
            catch (ClassNotFoundException ex) {
                if (!considerAutoName) {
                    throw new EventAdapterException("Event type or class named '" + fullyQualClassName + "' was not found", ex);
                }
                for (String javaPackageName : this.javaPackageNames) {
                    String generatedClassName = javaPackageName + "." + fullyQualClassName;
                    try {
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        Class<?> resolvedClass = Class.forName(generatedClassName, true, cl);
                        if (clazz != null) {
                            throw new EventAdapterException("Failed to resolve name '" + eventTypeName + "', the class was ambigously found both in " + "package '" + clazz.getPackage().getName() + "' and in " + "package '" + resolvedClass.getPackage().getName() + "'", ex);
                        }
                        clazz = resolvedClass;
                    }
                    catch (ClassNotFoundException ex1) {}
                }
                if (clazz != null) break block11;
                throw new EventAdapterException("Event type or class named '" + fullyQualClassName + "' was not found", ex);
            }
        }
        BeanEventType eventType = this.beanEventAdapter.createBeanType(eventTypeName, clazz, true);
        this.nameToTypeMap.put(eventTypeName, eventType);
        return eventType;
    }

    @Override
    public synchronized EventType addNestableMapType(String eventTypeName, Map<String, Object> propertyTypes, Set<String> optionalSuperType, boolean isConfigured, boolean namedWindow, boolean insertInto) throws EventAdapterException {
        Pair<EventType[], Set<EventType>> mapSuperTypes = this.getMapSuperTypes(optionalSuperType);
        EventTypeMetadata metadata = EventTypeMetadata.createMapType(eventTypeName, isConfigured, namedWindow, insertInto);
        MapEventType newEventType = new MapEventType(metadata, eventTypeName, this, propertyTypes, mapSuperTypes.getFirst(), mapSuperTypes.getSecond());
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (existingType != null) {
            if (!newEventType.equals(existingType)) {
                String message = newEventType.getEqualsMessage(existingType);
                throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing column name or type information: " + message);
            }
            return existingType;
        }
        this.nameToTypeMap.put(eventTypeName, newEventType);
        return newEventType;
    }

    @Override
    public EventBean adapterForMap(Map<String, Object> event, String eventTypeName) throws EventAdapterException {
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (existingType == null) {
            throw new EventAdapterException("Event type name '" + eventTypeName + "' has not been defined");
        }
        return this.adaptorForTypedMap(event, existingType);
    }

    @Override
    public EventBean adapterForDOM(Node node) {
        EventType eventType;
        Node namedNode;
        if (node instanceof Document) {
            namedNode = ((Document)node).getDocumentElement();
        } else if (node instanceof Element) {
            namedNode = node;
        } else {
            throw new EPException("Unexpected DOM node of type '" + node.getClass() + "' encountered, please supply a Document or Element node");
        }
        String rootElementName = namedNode.getLocalName();
        if (rootElementName == null) {
            rootElementName = namedNode.getNodeName();
        }
        if ((eventType = this.xmldomRootElementNames.get(rootElementName)) == null) {
            throw new EventAdapterException("DOM event root element name '" + rootElementName + "' has not been configured");
        }
        return new XMLEventBean(namedNode, eventType);
    }

    @Override
    public EventBean adapterForTypedDOM(Node node, EventType eventType) {
        return new XMLEventBean(node, eventType);
    }

    @Override
    public synchronized EventType addXMLDOMType(String eventTypeName, ConfigurationEventTypeXMLDOM configurationEventTypeXMLDOM, SchemaModel optionalSchemaModel) {
        BaseXMLEventType type;
        if (configurationEventTypeXMLDOM.getRootElementName() == null) {
            throw new EventAdapterException("Required root element name has not been supplied");
        }
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (existingType != null) {
            String message = "Event type named '" + eventTypeName + "' has already been declared with differing column name or type information";
            if (!(existingType instanceof BaseXMLEventType)) {
                throw new EventAdapterException(message);
            }
            ConfigurationEventTypeXMLDOM config = ((BaseXMLEventType)existingType).getConfigurationEventTypeXMLDOM();
            if (!config.equals(configurationEventTypeXMLDOM)) {
                throw new EventAdapterException(message);
            }
            return existingType;
        }
        EventTypeMetadata metadata = EventTypeMetadata.createXMLType(eventTypeName, configurationEventTypeXMLDOM.getSchemaResource() == null);
        if (configurationEventTypeXMLDOM.getSchemaResource() == null) {
            type = new SimpleXMLEventType(metadata, configurationEventTypeXMLDOM, this);
        } else {
            if (optionalSchemaModel == null) {
                throw new EPException("Schema model has not been provided");
            }
            type = new SchemaXMLEventType(metadata, configurationEventTypeXMLDOM, optionalSchemaModel, this);
        }
        this.nameToTypeMap.put(eventTypeName, type);
        this.xmldomRootElementNames.put(configurationEventTypeXMLDOM.getRootElementName(), type);
        return type;
    }

    @Override
    public final EventBean adapterForType(Object event, EventType eventType) {
        return EventAdapterServiceHelper.adapterForType(event, eventType, this);
    }

    @Override
    public final EventBean adaptorForTypedMap(Map<String, Object> properties, EventType eventType) {
        return new MapEventBean(properties, eventType);
    }

    @Override
    public synchronized EventType addWrapperType(String eventTypeName, EventType underlyingEventType, Map<String, Object> propertyTypes, boolean isNamedWindow, boolean isInsertInto) throws EventAdapterException {
        if (underlyingEventType instanceof WrapperEventType) {
            WrapperEventType underlyingWrapperType = (WrapperEventType)underlyingEventType;
            underlyingEventType = underlyingWrapperType.getUnderlyingEventType();
            HashMap<String, Object> propertiesSuperset = new HashMap<String, Object>();
            propertiesSuperset.putAll(underlyingWrapperType.getUnderlyingMapType().getTypes());
            propertiesSuperset.putAll(propertyTypes);
            propertyTypes = propertiesSuperset;
        }
        boolean isPropertyAgnostic = false;
        if (underlyingEventType instanceof EventTypeSPI) {
            isPropertyAgnostic = ((EventTypeSPI)underlyingEventType).getMetadata().isPropertyAgnostic();
        }
        EventTypeMetadata metadata = EventTypeMetadata.createWrapper(eventTypeName, isNamedWindow, isInsertInto, isPropertyAgnostic);
        WrapperEventType newEventType = new WrapperEventType(metadata, eventTypeName, underlyingEventType, propertyTypes, this);
        EventType existingType = this.nameToTypeMap.get(eventTypeName);
        if (existingType != null) {
            if (!newEventType.equals(existingType)) {
                String message = EventAdapterServiceImpl.isCompatibleWrapper(existingType, underlyingEventType, propertyTypes);
                if (message == null) {
                    return existingType;
                }
                throw new EventAdapterException("Event type named '" + eventTypeName + "' has already been declared with differing column name or type information: " + message);
            }
            return existingType;
        }
        this.nameToTypeMap.put(eventTypeName, newEventType);
        return newEventType;
    }

    public static String isCompatibleWrapper(EventType existingType, EventType underlyingType, Map<String, Object> propertyTypes) {
        if (!(existingType instanceof WrapperEventType)) {
            return "Type '" + existingType.getName() + "' is not compatible";
        }
        WrapperEventType existingWrapper = (WrapperEventType)existingType;
        String message = MapEventType.isDeepEqualsProperties(existingType.getName(), existingWrapper.getUnderlyingMapType().getTypes(), propertyTypes);
        if (message != null) {
            return message;
        }
        EventType existingUnderlyingType = existingWrapper.getUnderlyingEventType();
        if (underlyingType.getSuperTypes() == null) {
            return "Type '" + existingType.getName() + "' is not compatible";
        }
        for (EventType superUnderlying : underlyingType.getSuperTypes()) {
            if (superUnderlying != existingUnderlyingType) continue;
            return null;
        }
        return "Type '" + existingType.getName() + "' is not compatible";
    }

    @Override
    public final EventType createAnonymousMapType(Map<String, Object> propertyTypes) throws EventAdapterException {
        String name = UuidGenerator.generate();
        EventTypeMetadata metadata = EventTypeMetadata.createAnonymous(name);
        return new MapEventType(metadata, name, this, propertyTypes, null, null);
    }

    @Override
    public EventType createSemiAnonymousMapType(Map<String, Pair<EventType, String>> taggedEventTypes, Map<String, Pair<EventType, String>> arrayEventTypes, boolean isUsedByChildViews) {
        LinkedHashMap<String, Object> mapProperties = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Pair<EventType, String>> entry : taggedEventTypes.entrySet()) {
            mapProperties.put(entry.getKey(), entry.getValue().getFirst());
        }
        for (Map.Entry<String, Pair<EventType, String>> entry : arrayEventTypes.entrySet()) {
            mapProperties.put(entry.getKey(), new EventType[]{entry.getValue().getFirst()});
        }
        return this.createAnonymousMapType(mapProperties);
    }

    @Override
    public final EventType createAnonymousWrapperType(EventType underlyingEventType, Map<String, Object> propertyTypes) throws EventAdapterException {
        String name = UuidGenerator.generate();
        EventTypeMetadata metadata = EventTypeMetadata.createAnonymous(name);
        if (underlyingEventType instanceof WrapperEventType) {
            WrapperEventType underlyingWrapperType = (WrapperEventType)underlyingEventType;
            underlyingEventType = underlyingWrapperType.getUnderlyingEventType();
            HashMap<String, Object> propertiesSuperset = new HashMap<String, Object>();
            propertiesSuperset.putAll(underlyingWrapperType.getUnderlyingMapType().getTypes());
            propertiesSuperset.putAll(propertyTypes);
            propertyTypes = propertiesSuperset;
        }
        return new WrapperEventType(metadata, name, underlyingEventType, propertyTypes, this);
    }

    @Override
    public final EventBean adaptorForTypedWrapper(EventBean event, Map<String, Object> properties, EventType eventType) {
        if (event instanceof DecoratingEventBean) {
            DecoratingEventBean wrapper = (DecoratingEventBean)((Object)event);
            properties.putAll(wrapper.getDecoratingProperties());
            return new WrapperEventBean(wrapper.getUnderlyingEvent(), properties, eventType);
        }
        return new WrapperEventBean(event, properties, eventType);
    }

    @Override
    public final EventBean adapterForTypedBean(Object bean, BeanEventType eventType) {
        return new BeanEventBean(bean, eventType);
    }

    @Override
    public void addAutoNamePackage(String javaPackageName) {
        this.javaPackageNames.add(javaPackageName);
    }

    private Pair<EventType[], Set<EventType>> getMapSuperTypes(Set<String> optionalSuperTypes) throws EventAdapterException {
        if (optionalSuperTypes == null || optionalSuperTypes.isEmpty()) {
            return new Pair<Object, Object>(null, null);
        }
        EventType[] superTypes = new EventType[optionalSuperTypes.size()];
        LinkedHashSet<EventType> deepSuperTypes = new LinkedHashSet<EventType>();
        int count = 0;
        for (String superName : optionalSuperTypes) {
            EventType type = this.nameToTypeMap.get(superName);
            if (type == null) {
                throw new EventAdapterException("Map supertype by name '" + superName + "' could not be found");
            }
            if (!(type instanceof MapEventType)) {
                throw new EventAdapterException("Supertype by name '" + superName + "' is not a Map, expected a Map event type as a supertype");
            }
            superTypes[count++] = type;
            deepSuperTypes.add(type);
            EventAdapterServiceImpl.addRecursiveSupertypes(deepSuperTypes, type);
        }
        return new Pair<EventType[], Set<EventType>>(superTypes, deepSuperTypes);
    }

    private static void addRecursiveSupertypes(Set<EventType> superTypes, EventType child) {
        if (child.getSuperTypes() != null) {
            for (int i = 0; i < child.getSuperTypes().length; ++i) {
                superTypes.add(child.getSuperTypes()[i]);
                EventAdapterServiceImpl.addRecursiveSupertypes(superTypes, child.getSuperTypes()[i]);
            }
        }
    }

    @Override
    public EventBean[] typeCast(List<EventBean> events, EventType targetType) {
        EventBean[] convertedArray = new EventBean[events.size()];
        int count = 0;
        for (EventBean event : events) {
            EventBean converted;
            if (event instanceof DecoratingEventBean) {
                DecoratingEventBean wrapper = (DecoratingEventBean)((Object)event);
                if (targetType instanceof MapEventType) {
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    props.putAll(wrapper.getDecoratingProperties());
                    for (EventPropertyDescriptor propDesc : wrapper.getUnderlyingEvent().getEventType().getPropertyDescriptors()) {
                        props.put(propDesc.getPropertyName(), wrapper.getUnderlyingEvent().get(propDesc.getPropertyName()));
                    }
                    converted = this.adaptorForTypedMap(props, targetType);
                } else {
                    converted = this.adaptorForTypedWrapper(wrapper.getUnderlyingEvent(), wrapper.getDecoratingProperties(), targetType);
                }
            } else if (event.getEventType() instanceof MapEventType && targetType instanceof MapEventType) {
                MappedEventBean mapEvent = (MappedEventBean)((Object)event);
                converted = this.adaptorForTypedMap(mapEvent.getProperties(), targetType);
            } else if (event.getEventType() instanceof MapEventType && targetType instanceof WrapperEventType) {
                converted = this.adaptorForTypedWrapper(event, Collections.EMPTY_MAP, targetType);
            } else {
                throw new EPException("Unknown event type " + event.getEventType());
            }
            convertedArray[count] = converted;
            ++count;
        }
        return convertedArray;
    }

    @Override
    public boolean removeType(String name) {
        EventType eventType = this.nameToTypeMap.remove(name);
        if (eventType == null) {
            return false;
        }
        if (eventType instanceof BaseXMLEventType) {
            BaseXMLEventType baseXML = (BaseXMLEventType)eventType;
            this.xmldomRootElementNames.remove(baseXML.getRootElementName());
        }
        this.nameToHandlerMap.remove(name);
        return true;
    }
}

