/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.collection.MultiKeyUntypedEventPair;
import com.espertech.esper.collection.UniformPair;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.NaturalEventBean;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.util.JavaClassHelper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBeanUtility {
    private static final EventBean[] nullArray = new EventBean[0];

    public static EventBean[] resizeArray(EventBean[] oldArray, int newSize) {
        if (oldArray == null) {
            return null;
        }
        if (oldArray.length == newSize) {
            return oldArray;
        }
        EventBean[] newArray = new EventBean[newSize];
        int preserveLength = Math.min(oldArray.length, newSize);
        if (preserveLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, preserveLength);
        }
        return newArray;
    }

    public static UniformPair<EventBean[]> flattenList(ArrayDequeJDK6Backport<UniformPair<EventBean[]>> eventVector) {
        if (eventVector.isEmpty()) {
            return null;
        }
        if (eventVector.size() == 1) {
            return eventVector.getFirst();
        }
        int totalNew = 0;
        int totalOld = 0;
        for (UniformPair<EventBean[]> pair : eventVector) {
            if (pair == null) continue;
            if (pair.getFirst() != null) {
                totalNew += pair.getFirst().length;
            }
            if (pair.getSecond() == null) continue;
            totalOld += pair.getSecond().length;
        }
        if (totalNew + totalOld == 0) {
            return null;
        }
        EventBean[] resultNew = null;
        if (totalNew > 0) {
            resultNew = new EventBean[totalNew];
        }
        EventBean[] resultOld = null;
        if (totalOld > 0) {
            resultOld = new EventBean[totalOld];
        }
        int destPosNew = 0;
        int destPosOld = 0;
        for (UniformPair<EventBean[]> pair : eventVector) {
            if (pair == null) continue;
            if (pair.getFirst() != null) {
                System.arraycopy(pair.getFirst(), 0, resultNew, destPosNew, pair.getFirst().length);
                destPosNew += pair.getFirst().length;
            }
            if (pair.getSecond() == null) continue;
            System.arraycopy(pair.getSecond(), 0, resultOld, destPosOld, pair.getSecond().length);
            destPosOld += pair.getSecond().length;
        }
        return new UniformPair<EventBean[]>(resultNew, resultOld);
    }

    public static EventBean[] flatten(ArrayDequeJDK6Backport<EventBean[]> eventVector) {
        if (eventVector.isEmpty()) {
            return null;
        }
        if (eventVector.size() == 1) {
            return eventVector.getFirst();
        }
        int totalElements = 0;
        for (EventBean[] arr : eventVector) {
            if (arr == null) continue;
            totalElements += arr.length;
        }
        if (totalElements == 0) {
            return null;
        }
        EventBean[] result = new EventBean[totalElements];
        int destPos = 0;
        for (EventBean[] arr : eventVector) {
            if (arr == null) continue;
            System.arraycopy(arr, 0, result, destPos, arr.length);
            destPos += arr.length;
        }
        return result;
    }

    public static UniformPair<EventBean[]> flattenBatchStream(List<UniformPair<EventBean[]>> updateVector) {
        if (updateVector.isEmpty()) {
            return new UniformPair<Object>(null, null);
        }
        if (updateVector.size() == 1) {
            return new UniformPair<EventBean[]>(updateVector.get(0).getFirst(), updateVector.get(0).getSecond());
        }
        int totalNewEvents = 0;
        int totalOldEvents = 0;
        for (UniformPair<EventBean[]> pair : updateVector) {
            if (pair.getFirst() != null) {
                totalNewEvents += pair.getFirst().length;
            }
            if (pair.getSecond() == null) continue;
            totalOldEvents += pair.getSecond().length;
        }
        if (totalNewEvents == 0 && totalOldEvents == 0) {
            return new UniformPair<Object>(null, null);
        }
        EventBean[] newEvents = null;
        EventBean[] oldEvents = null;
        if (totalNewEvents != 0) {
            newEvents = new EventBean[totalNewEvents];
        }
        if (totalOldEvents != 0) {
            oldEvents = new EventBean[totalOldEvents];
        }
        int destPosNew = 0;
        int destPosOld = 0;
        for (UniformPair<EventBean[]> pair : updateVector) {
            EventBean[] newData = pair.getFirst();
            EventBean[] oldData = pair.getSecond();
            if (newData != null) {
                int newDataLen = newData.length;
                System.arraycopy(newData, 0, newEvents, destPosNew, newDataLen);
                destPosNew += newDataLen;
            }
            if (oldData == null) continue;
            int oldDataLen = oldData.length;
            System.arraycopy(oldData, 0, oldEvents, destPosOld, oldDataLen);
            destPosOld += oldDataLen;
        }
        return new UniformPair<EventBean[]>(newEvents, oldEvents);
    }

    protected static EventBean[] append(EventBean[] source, EventBean[] append) {
        EventBean[] result = new EventBean[source.length + append.length];
        System.arraycopy(source, 0, result, 0, source.length);
        System.arraycopy(append, 0, result, source.length, append.length);
        return result;
    }

    public static EventBean[] toArray(List<EventBean> eventList) {
        if (eventList == null || eventList.isEmpty()) {
            return null;
        }
        return eventList.toArray(new EventBean[eventList.size()]);
    }

    public static Object[] getPropertyArray(EventBean event, EventPropertyGetter[] propertyGetters) {
        Object[] keyValues = new Object[propertyGetters.length];
        for (int i = 0; i < propertyGetters.length; ++i) {
            keyValues[i] = propertyGetters[i].get(event);
        }
        return keyValues;
    }

    public static MultiKeyUntyped getMultiKey(EventBean event, EventPropertyGetter[] propertyGetters) {
        Object[] keyValues = EventBeanUtility.getPropertyArray(event, propertyGetters);
        return new MultiKeyUntyped(keyValues);
    }

    public static String printEvent(EventBean event) {
        StringWriter writer = new StringWriter();
        PrintWriter buf = new PrintWriter(writer);
        EventBeanUtility.printEvent(buf, event);
        return writer.toString();
    }

    private static void printEvent(PrintWriter writer, EventBean event) {
        String[] properties = event.getEventType().getPropertyNames();
        for (int i = 0; i < properties.length; ++i) {
            String propName = properties[i];
            Object property = event.get(propName);
            String printProperty = property == null ? "null" : (property.getClass().isArray() ? "Array :" + Arrays.toString((Object[])property) : property.toString());
            writer.println("#" + i + "  " + propName + " = " + printProperty);
        }
    }

    public static UniformPair<Set<MultiKey<EventBean>>> flattenBatchJoin(List<UniformPair<Set<MultiKey<EventBean>>>> joinPostings) {
        if (joinPostings.isEmpty()) {
            return new UniformPair<Object>(null, null);
        }
        if (joinPostings.size() == 1) {
            return new UniformPair<Set<MultiKey<EventBean>>>(joinPostings.get(0).getFirst(), joinPostings.get(0).getSecond());
        }
        LinkedHashSet<MultiKey<EventBean>> newEvents = new LinkedHashSet<MultiKey<EventBean>>();
        LinkedHashSet<MultiKey<EventBean>> oldEvents = new LinkedHashSet<MultiKey<EventBean>>();
        for (UniformPair<Set<MultiKey<EventBean>>> pair : joinPostings) {
            Set<MultiKey<EventBean>> newData = pair.getFirst();
            Set<MultiKey<EventBean>> oldData = pair.getSecond();
            if (newData != null) {
                newEvents.addAll(newData);
            }
            if (oldData == null) continue;
            oldEvents.addAll(oldData);
        }
        return new UniformPair<Set<MultiKey<EventBean>>>(newEvents, oldEvents);
    }

    public static EventBean[] addToArray(EventBean[] array, EventBean eventToAdd) {
        EventBean[] newArray = new EventBean[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[newArray.length - 1] = eventToAdd;
        return newArray;
    }

    public static EventBean[] addToArray(EventBean[] array, List<EventBean> eventsToAdd) {
        EventBean[] newArray = new EventBean[array.length + eventsToAdd.size()];
        System.arraycopy(array, 0, newArray, 0, array.length);
        int counter = array.length;
        for (EventBean eventToAdd : eventsToAdd) {
            newArray[counter++] = eventToAdd;
        }
        return newArray;
    }

    public static FragmentEventType createNativeFragmentType(Class propertyType, Class genericType, EventAdapterService eventAdapterService) {
        boolean isIndexed = false;
        if (propertyType.isArray()) {
            isIndexed = true;
            propertyType = propertyType.getComponentType();
        } else if (JavaClassHelper.isImplementsInterface(propertyType, Iterable.class)) {
            isIndexed = true;
            if (genericType == null) {
                return null;
            }
            propertyType = genericType;
        }
        if (!JavaClassHelper.isFragmentableType(propertyType)) {
            return null;
        }
        BeanEventType type = eventAdapterService.getBeanEventTypeFactory().createBeanType(propertyType.getName(), propertyType, false);
        return new FragmentEventType(type, isIndexed, true);
    }

    public static EventBean[] getDistinctByProp(ArrayDequeJDK6Backport<EventBean> events, EventBeanReader reader) {
        if (events == null || events.size() < 2) {
            return events.toArray(new EventBean[events.size()]);
        }
        LinkedHashSet<MultiKeyUntypedEventPair> set = new LinkedHashSet<MultiKeyUntypedEventPair>();
        if (events.getFirst() instanceof NaturalEventBean) {
            for (EventBean event : events) {
                EventBean inner = ((NaturalEventBean)event).getOptionalSynthetic();
                Object[] keys = reader.read(inner);
                MultiKeyUntypedEventPair pair = new MultiKeyUntypedEventPair(keys, event);
                set.add(pair);
            }
        } else {
            for (EventBean event : events) {
                Object[] keys = reader.read(event);
                MultiKeyUntypedEventPair pair = new MultiKeyUntypedEventPair(keys, event);
                set.add(pair);
            }
        }
        EventBean[] result = new EventBean[set.size()];
        int count = 0;
        for (MultiKeyUntypedEventPair row : set) {
            result[count++] = row.getEventBean();
        }
        return result;
    }

    public static EventBean[] getDistinctByProp(EventBean[] events, EventBeanReader reader) {
        if (events == null || events.length < 2) {
            return events;
        }
        LinkedHashSet<MultiKeyUntypedEventPair> set = new LinkedHashSet<MultiKeyUntypedEventPair>();
        if (events[0] instanceof NaturalEventBean) {
            for (EventBean event : events) {
                EventBean inner = ((NaturalEventBean)event).getOptionalSynthetic();
                Object[] keys = reader.read(inner);
                MultiKeyUntypedEventPair pair = new MultiKeyUntypedEventPair(keys, event);
                set.add(pair);
            }
        } else {
            for (EventBean event : events) {
                Object[] keys = reader.read(event);
                MultiKeyUntypedEventPair pair = new MultiKeyUntypedEventPair(keys, event);
                set.add(pair);
            }
        }
        EventBean[] result = new EventBean[set.size()];
        int count = 0;
        for (MultiKeyUntypedEventPair row : set) {
            result[count++] = row.getEventBean();
        }
        return result;
    }
}

