/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventSender;
import com.espertech.esper.client.time.CurrentTimeEvent;
import com.espertech.esper.core.EPRuntimeEventSender;
import com.espertech.esper.core.thread.InboundUnitSendWrapped;
import com.espertech.esper.core.thread.ThreadingOption;
import com.espertech.esper.core.thread.ThreadingService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.util.ExecutionPathDebugLog;
import com.espertech.esper.util.JavaClassHelper;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventSenderBean
implements EventSender {
    private static final Log log = LogFactory.getLog(EventSenderBean.class);
    private final EPRuntimeEventSender runtime;
    private final BeanEventType beanEventType;
    private final EventAdapterService eventAdapterService;
    private final Set<Class> compatibleClasses;
    private final ThreadingService threadingService;

    public EventSenderBean(EPRuntimeEventSender runtime, BeanEventType beanEventType, EventAdapterService eventAdapterService, ThreadingService threadingService) {
        this.runtime = runtime;
        this.beanEventType = beanEventType;
        this.eventAdapterService = eventAdapterService;
        this.compatibleClasses = new HashSet<Class>();
        this.threadingService = threadingService;
    }

    public void sendEvent(Object event) {
        if (event == null) {
            throw new NullPointerException("No event object provided to sendEvent method");
        }
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled() && (!(event instanceof CurrentTimeEvent) || ExecutionPathDebugLog.isTimerDebugEnabled)) {
            log.debug(".sendEvent Processing event " + event);
        }
        EventBean eventBean = this.getEventBean(event);
        if (ThreadingOption.isThreadingEnabled && this.threadingService.isInboundThreading()) {
            this.threadingService.submitInbound(new InboundUnitSendWrapped(eventBean, this.runtime));
        } else {
            this.runtime.processWrappedEvent(eventBean);
        }
    }

    public void route(Object event) throws EPException {
        EventBean eventBean = this.getEventBean(event);
        this.runtime.routeEventBean(eventBean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventBean getEventBean(Object event) {
        if (event.getClass() != this.beanEventType.getUnderlyingType()) {
            EventSenderBean eventSenderBean = this;
            synchronized (eventSenderBean) {
                if (!this.compatibleClasses.contains(event.getClass())) {
                    if (JavaClassHelper.isSubclassOrImplementsInterface(event.getClass(), this.beanEventType.getUnderlyingType())) {
                        this.compatibleClasses.add(event.getClass());
                    } else {
                        throw new EPException("Event object of type " + event.getClass().getName() + " does not equal, extend or implement the type " + this.beanEventType.getUnderlyingType().getName() + " of event type '" + this.beanEventType.getName() + "'");
                    }
                }
            }
        }
        return this.eventAdapterService.adapterForTypedBean(event, this.beanEventType);
    }
}

