/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.event.DecoratingEventBean;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrapperEventBean
implements EventBean,
DecoratingEventBean {
    private final EventBean event;
    private final Map<String, Object> map;
    private final EventType eventType;

    public WrapperEventBean(EventBean event, Map<String, Object> properties, EventType eventType) {
        this.event = event;
        this.map = properties;
        this.eventType = eventType;
    }

    @Override
    public Object get(String property) throws PropertyAccessException {
        EventPropertyGetter getter = this.eventType.getGetter(property);
        if (getter == null) {
            throw new PropertyAccessException("Property named '" + property + "' is not a valid property name for this type");
        }
        return this.eventType.getGetter(property).get(this);
    }

    @Override
    public EventType getEventType() {
        return this.eventType;
    }

    @Override
    public Object getUnderlying() {
        if (this.map.isEmpty()) {
            return this.event.getUnderlying();
        }
        return new Pair<Object, Map<String, Object>>(this.event.getUnderlying(), this.map);
    }

    public Map getUnderlyingMap() {
        return this.map;
    }

    @Override
    public Map<String, Object> getDecoratingProperties() {
        return this.map;
    }

    @Override
    public EventBean getUnderlyingEvent() {
        return this.event;
    }

    public String toString() {
        return "WrapperEventBean [event=" + this.event + "] " + "[properties=" + this.map + "]";
    }

    @Override
    public Object getFragment(String propertyExpression) {
        EventPropertyGetter getter = this.eventType.getGetter(propertyExpression);
        if (getter == null) {
            throw new PropertyAccessException("Property named '" + propertyExpression + "' is not a valid property name for this type");
        }
        return getter.getFragment(this);
    }
}

