/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.reflect.FastMethod;

public class ArrayFastPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter {
    private final FastMethod fastMethod;
    private final int index;

    public ArrayFastPropertyGetter(FastMethod fastMethod, int index, EventAdapterService eventAdapterService) {
        super(eventAdapterService, fastMethod.getReturnType().getComponentType(), null);
        this.index = index;
        this.fastMethod = fastMethod;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    public Object getBeanProp(Object object) throws PropertyAccessException {
        try {
            Object value = this.fastMethod.invoke(object, null);
            if (Array.getLength(value) <= this.index) {
                return null;
            }
            return Array.get(value, this.index);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
    }

    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "ArrayFastPropertyGetter  fastMethod=" + this.fastMethod.toString() + " index=" + this.index;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

