/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;

public class ArrayFieldPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter {
    private final Field field;
    private final int index;

    public ArrayFieldPropertyGetter(Field field, int index, EventAdapterService eventAdapterService) {
        super(eventAdapterService, field.getType().getComponentType(), null);
        this.index = index;
        this.field = field;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    public Object getBeanProp(Object object) throws PropertyAccessException {
        try {
            Object value = this.field.get(object);
            if (Array.getLength(value) <= this.index) {
                return null;
            }
            return Array.get(value, this.index);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        }
    }

    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "ArrayFieldPropertyGetter  field=" + this.field.toString() + " index=" + this.index;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

