/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ArrayMethodPropertyGetter
extends BaseNativePropertyGetter
implements BeanEventPropertyGetter {
    private final Method method;
    private final int index;

    public ArrayMethodPropertyGetter(Method method, int index, EventAdapterService eventAdapterService) {
        super(eventAdapterService, method.getReturnType().getComponentType(), null);
        this.index = index;
        this.method = method;
        if (index < 0) {
            throw new IllegalArgumentException("Invalid negative index value");
        }
    }

    public Object getBeanProp(Object object) throws PropertyAccessException {
        try {
            Object value = this.method.invoke(object, (Object[])null);
            if (Array.getLength(value) <= this.index) {
                return null;
            }
            return Array.get(value, this.index);
        }
        catch (ClassCastException e) {
            throw new PropertyAccessException("Mismatched getter instance to event bean type");
        }
        catch (InvocationTargetException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new PropertyAccessException(e);
        }
        catch (IllegalArgumentException e) {
            throw new PropertyAccessException(e);
        }
    }

    public boolean isBeanExistsProperty(Object object) {
        return true;
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        Object underlying = obj.getUnderlying();
        return this.getBeanProp(underlying);
    }

    public String toString() {
        return "ArrayMethodPropertyGetter  method=" + this.method.toString() + " index=" + this.index;
    }

    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }
}

