/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.collection.ArrayDequeJDK6Backport;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.Iterator;

public abstract class BaseNativePropertyGetter
implements EventPropertyGetter {
    private final EventAdapterService eventAdapterService;
    private volatile BeanEventType fragmentEventType;
    private final Class fragmentClassType;
    private boolean isFragmentable;
    private final boolean isArray;
    private final boolean isIterable;

    public BaseNativePropertyGetter(EventAdapterService eventAdapterService, Class returnType, Class genericType) {
        this.eventAdapterService = eventAdapterService;
        if (returnType.isArray()) {
            this.fragmentClassType = returnType.getComponentType();
            this.isArray = true;
            this.isIterable = false;
        } else if (JavaClassHelper.isImplementsInterface(returnType, Iterable.class)) {
            this.fragmentClassType = genericType;
            this.isArray = false;
            this.isIterable = true;
        } else {
            this.fragmentClassType = returnType;
            this.isArray = false;
            this.isIterable = false;
        }
        this.isFragmentable = true;
    }

    public static Object getFragmentDynamic(Object object, EventAdapterService eventAdapterService) {
        if (object == null) {
            return null;
        }
        BeanEventType fragmentEventType = null;
        boolean isArray = false;
        if (object.getClass().isArray()) {
            if (JavaClassHelper.isFragmentableType(object.getClass().getComponentType())) {
                isArray = true;
                fragmentEventType = eventAdapterService.getBeanEventTypeFactory().createBeanTypeDefaultName(object.getClass().getComponentType());
            }
        } else if (JavaClassHelper.isFragmentableType(object.getClass())) {
            fragmentEventType = eventAdapterService.getBeanEventTypeFactory().createBeanTypeDefaultName(object.getClass());
        }
        if (fragmentEventType == null) {
            return null;
        }
        if (isArray) {
            int len = Array.getLength(object);
            EventBean[] events = new EventBean[len];
            int countFilled = 0;
            for (int i = 0; i < len; ++i) {
                Object element = Array.get(object, i);
                if (element == null) continue;
                events[countFilled] = eventAdapterService.adapterForTypedBean(element, fragmentEventType);
                ++countFilled;
            }
            if (countFilled == len) {
                return events;
            }
            if (countFilled == 0) {
                return new EventBean[0];
            }
            EventBean[] returnVal = new EventBean[countFilled];
            System.arraycopy(events, 0, returnVal, 0, countFilled);
            return returnVal;
        }
        return eventAdapterService.adapterForTypedBean(object, fragmentEventType);
    }

    public Object getFragment(EventBean eventBean) {
        Object object = this.get(eventBean);
        if (object == null) {
            return null;
        }
        if (!this.isFragmentable) {
            return null;
        }
        if (this.fragmentEventType == null) {
            if (JavaClassHelper.isFragmentableType(this.fragmentClassType)) {
                this.fragmentEventType = this.eventAdapterService.getBeanEventTypeFactory().createBeanTypeDefaultName(this.fragmentClassType);
            } else {
                this.isFragmentable = false;
                return null;
            }
        }
        if (this.isArray) {
            int len = Array.getLength(object);
            EventBean[] events = new EventBean[len];
            int countFilled = 0;
            for (int i = 0; i < len; ++i) {
                Object element = Array.get(object, i);
                if (element == null) continue;
                events[countFilled] = this.eventAdapterService.adapterForTypedBean(element, this.fragmentEventType);
                ++countFilled;
            }
            if (countFilled == len) {
                return events;
            }
            if (countFilled == 0) {
                return new EventBean[0];
            }
            EventBean[] returnVal = new EventBean[countFilled];
            System.arraycopy(events, 0, returnVal, 0, countFilled);
            return returnVal;
        }
        if (this.isIterable) {
            if (!(object instanceof Iterable)) {
                return null;
            }
            Iterator iterator = ((Iterable)object).iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            ArrayDequeJDK6Backport<EventBean> events = new ArrayDequeJDK6Backport<EventBean>();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (next == null) continue;
                events.add(this.eventAdapterService.adapterForTypedBean(next, this.fragmentEventType));
            }
            return events.toArray(new EventBean[events.size()]);
        }
        return this.eventAdapterService.adapterForTypedBean(object, this.fragmentEventType);
    }
}

