/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.bean.BeanEventType;
import java.lang.reflect.InvocationTargetException;
import net.sf.cglib.reflect.FastMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BeanEventBeanConfiguredCopyMethod
implements EventBeanCopyMethod {
    private static final Log log = LogFactory.getLog(BeanEventBeanConfiguredCopyMethod.class);
    private final BeanEventType beanEventType;
    private final EventAdapterService eventAdapterService;
    private final FastMethod copyMethod;

    public BeanEventBeanConfiguredCopyMethod(BeanEventType beanEventType, EventAdapterService eventAdapterService, FastMethod copyMethod) {
        this.beanEventType = beanEventType;
        this.eventAdapterService = eventAdapterService;
        this.copyMethod = copyMethod;
    }

    public EventBean copy(EventBean event) {
        Object copied;
        Object underlying = event.getUnderlying();
        try {
            copied = this.copyMethod.invoke(underlying, null);
        }
        catch (InvocationTargetException e) {
            log.error("InvocationTargetException copying event object for update: " + e.getMessage(), e);
            return null;
        }
        catch (RuntimeException e) {
            log.error("RuntimeException copying event object for update: " + e.getMessage(), e);
            return null;
        }
        return this.eventAdapterService.adapterForTypedBean(copied, this.beanEventType);
    }
}

