/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.bean;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.bean.BaseNativePropertyGetter;
import com.espertech.esper.event.bean.BeanEventPropertyGetter;
import com.espertech.esper.event.bean.DynamicPropertyDescriptor;
import java.lang.reflect.Method;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;

public abstract class DynamicPropertyGetterBase
implements BeanEventPropertyGetter {
    private final EventAdapterService eventAdapterService;
    private final CopyOnWriteArrayList<DynamicPropertyDescriptor> cache = new CopyOnWriteArrayList();

    protected abstract Method determineMethod(Class var1);

    protected abstract Object call(DynamicPropertyDescriptor var1, Object var2);

    public DynamicPropertyGetterBase(EventAdapterService eventAdapterService) {
        this.eventAdapterService = eventAdapterService;
    }

    public Object getBeanProp(Object object) throws PropertyAccessException {
        DynamicPropertyDescriptor desc = this.getPopulateCache(object);
        if (desc.getMethod() == null) {
            return null;
        }
        return this.call(desc, object);
    }

    public boolean isBeanExistsProperty(Object object) {
        DynamicPropertyDescriptor desc = this.getPopulateCache(object);
        return desc.getMethod() != null;
    }

    public final Object get(EventBean obj) throws PropertyAccessException {
        DynamicPropertyDescriptor desc = this.getPopulateCache(obj.getUnderlying());
        if (desc.getMethod() == null) {
            return null;
        }
        return this.call(desc, obj.getUnderlying());
    }

    public boolean isExistsProperty(EventBean eventBean) {
        DynamicPropertyDescriptor desc = this.getPopulateCache(eventBean.getUnderlying());
        return desc.getMethod() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DynamicPropertyDescriptor getPopulateCache(Object obj) {
        Class<?> target = obj.getClass();
        for (DynamicPropertyDescriptor desc : this.cache) {
            if (desc.getClazz() != target) continue;
            return desc;
        }
        DynamicPropertyGetterBase dynamicPropertyGetterBase = this;
        synchronized (dynamicPropertyGetterBase) {
            FastClass fastClass;
            FastMethod fastMethod;
            for (DynamicPropertyDescriptor desc : this.cache) {
                if (desc.getClazz() != target) continue;
                return desc;
            }
            Method method = this.determineMethod(target);
            DynamicPropertyDescriptor propertyDescriptor = method == null ? new DynamicPropertyDescriptor(target, null, false) : new DynamicPropertyDescriptor(target, fastMethod, (fastMethod = (fastClass = FastClass.create(Thread.currentThread().getContextClassLoader(), target)).getMethod(method)).getParameterTypes().length > 0);
            this.cache.add(propertyDescriptor);
            return propertyDescriptor;
        }
    }

    public Object getFragment(EventBean eventBean) {
        Object result = this.get(eventBean);
        return BaseNativePropertyGetter.getFragmentDynamic(result, this.eventAdapterService);
    }
}

