/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import java.lang.reflect.Array;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapArrayMaptypedEntryPropertyGetter
implements MapEventPropertyGetter {
    private final String propertyMap;
    private final int index;
    private final EventPropertyGetter eventBeanEntryGetter;
    private final EventType innerType;
    private final EventAdapterService eventAdapterService;

    public MapArrayMaptypedEntryPropertyGetter(String propertyMap, int index, EventPropertyGetter eventBeanEntryGetter, EventType innerType, EventAdapterService eventAdapterService) {
        this.propertyMap = propertyMap;
        this.index = index;
        this.eventBeanEntryGetter = eventBeanEntryGetter;
        this.innerType = innerType;
        this.eventAdapterService = eventAdapterService;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        Object value = map.get(this.propertyMap);
        if (value == null) {
            return null;
        }
        if (!value.getClass().isArray()) {
            return null;
        }
        if (Array.getLength(value) <= this.index) {
            return null;
        }
        Object valueMap = Array.get(value, this.index);
        if (!(valueMap instanceof Map)) {
            return null;
        }
        EventBean eventBean = this.eventAdapterService.adaptorForTypedMap((Map)valueMap, this.innerType);
        return this.eventBeanEntryGetter.get(eventBean);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object get(EventBean obj) {
        Object underlying = obj.getUnderlying();
        if (!(underlying instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)underlying;
        return this.getMap(map);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean obj) {
        Object underlying = obj.getUnderlying();
        if (!(underlying instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)underlying;
        Object value = map.get(this.propertyMap);
        if (value == null) {
            return null;
        }
        if (!value.getClass().isArray()) {
            return null;
        }
        if (Array.getLength(value) <= this.index) {
            return null;
        }
        Object valueMap = Array.get(value, this.index);
        if (!(valueMap instanceof Map)) {
            return null;
        }
        EventBean eventBean = this.eventAdapterService.adaptorForTypedMap((Map)valueMap, this.innerType);
        return this.eventBeanEntryGetter.getFragment(eventBean);
    }
}

