/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEventBeanEntryPropertyGetter
implements MapEventPropertyGetter {
    private final String propertyMap;
    private final EventPropertyGetter eventBeanEntryGetter;

    public MapEventBeanEntryPropertyGetter(String propertyMap, EventPropertyGetter eventBeanEntryGetter) {
        this.propertyMap = propertyMap;
        this.eventBeanEntryGetter = eventBeanEntryGetter;
    }

    @Override
    public Object getMap(Map<String, Object> map) throws PropertyAccessException {
        Object value = map.get(this.propertyMap);
        if (value == null) {
            return null;
        }
        EventBean event = (EventBean)value;
        return this.eventBeanEntryGetter.get(event);
    }

    @Override
    public boolean isMapExistsProperty(Map<String, Object> map) {
        return true;
    }

    @Override
    public Object get(EventBean obj) {
        Object underlying = obj.getUnderlying();
        if (!(underlying instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)underlying;
        return this.getMap(map);
    }

    @Override
    public boolean isExistsProperty(EventBean eventBean) {
        return true;
    }

    @Override
    public Object getFragment(EventBean obj) {
        Object underlying = obj.getUnderlying();
        if (!(underlying instanceof Map)) {
            throw new PropertyAccessException("Mismatched property getter to event bean type, the underlying data object is not of type java.lang.Map");
        }
        Map map = (Map)underlying;
        Object value = map.get(this.propertyMap);
        if (value == null) {
            return null;
        }
        EventBean event = (EventBean)value;
        return this.eventBeanEntryGetter.getFragment(event);
    }
}

