/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.map;

import com.espertech.esper.client.EPException;
import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyDescriptor;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.client.FragmentEventType;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.parse.ASTFilterSpecHelper;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.EventBeanCopyMethod;
import com.espertech.esper.event.EventBeanReader;
import com.espertech.esper.event.EventBeanUtility;
import com.espertech.esper.event.EventBeanWriter;
import com.espertech.esper.event.EventPropertyWriter;
import com.espertech.esper.event.EventTypeMetadata;
import com.espertech.esper.event.EventTypeSPI;
import com.espertech.esper.event.MappedEventBean;
import com.espertech.esper.event.bean.BeanEventType;
import com.espertech.esper.event.map.MapArrayMaptypedEntryPropertyGetter;
import com.espertech.esper.event.map.MapArrayMaptypedUndPropertyGetter;
import com.espertech.esper.event.map.MapArrayPOJOBeanEntryIndexedPropertyGetter;
import com.espertech.esper.event.map.MapArrayPOJOEntryIndexedPropertyGetter;
import com.espertech.esper.event.map.MapEntryPropertyGetter;
import com.espertech.esper.event.map.MapEventBeanArrayIndexedElementPropertyGetter;
import com.espertech.esper.event.map.MapEventBeanArrayIndexedPropertyGetter;
import com.espertech.esper.event.map.MapEventBeanArrayPropertyGetter;
import com.espertech.esper.event.map.MapEventBeanCopyMethod;
import com.espertech.esper.event.map.MapEventBeanEntryPropertyGetter;
import com.espertech.esper.event.map.MapEventBeanPropertyGetter;
import com.espertech.esper.event.map.MapEventBeanReader;
import com.espertech.esper.event.map.MapEventBeanWriter;
import com.espertech.esper.event.map.MapEventPropertyGetter;
import com.espertech.esper.event.map.MapMappedPropertyGetter;
import com.espertech.esper.event.map.MapMaptypedArrayPropertyGetter;
import com.espertech.esper.event.map.MapMaptypedEntryPropertyGetter;
import com.espertech.esper.event.map.MapMaptypedPropertyGetter;
import com.espertech.esper.event.map.MapMaptypedUndPropertyGetter;
import com.espertech.esper.event.map.MapPOJOEntryPropertyGetter;
import com.espertech.esper.event.map.MapPropertyGetter;
import com.espertech.esper.event.property.DynamicProperty;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.MappedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.PropertyParser;
import com.espertech.esper.util.GraphUtil;
import com.espertech.esper.util.JavaClassHelper;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEventType
implements EventTypeSPI {
    private final EventTypeMetadata metadata;
    private final String typeName;
    private final EventAdapterService eventAdapterService;
    private final EventType[] optionalSuperTypes;
    private final Set<EventType> optionalDeepSupertypes;
    private String[] propertyNames;
    private EventPropertyDescriptor[] propertyDescriptors;
    private Map<String, EventPropertyDescriptor> propertyDescriptorMap;
    private final Map<String, FragmentEventType> simpleFragmentTypes;
    private final Map<String, Class> simplePropertyTypes;
    private final Map<String, MapEventPropertyGetter> propertyGetters;
    private final Map<String, MapEventPropertyGetter> propertyGetterCache;
    private Map<String, Object> nestableTypes;
    private Map<String, Pair<EventPropertyDescriptor, EventPropertyWriter>> propertyWriters;
    private EventPropertyDescriptor[] writablePropertyDescriptors;
    private int hashCode;

    public MapEventType(EventTypeMetadata metadata, String typeName, EventAdapterService eventAdapterService, Map<String, Object> propertyTypes, EventType[] optionalSuperTypes, Set<EventType> optionalDeepSupertypes) {
        this.metadata = metadata;
        this.typeName = typeName;
        this.eventAdapterService = eventAdapterService;
        this.nestableTypes = new HashMap<String, Object>();
        this.nestableTypes.putAll(propertyTypes);
        this.optionalSuperTypes = optionalSuperTypes;
        this.optionalDeepSupertypes = optionalDeepSupertypes == null ? Collections.EMPTY_SET : optionalDeepSupertypes;
        PropertySetDescriptor propertySet = MapEventType.getNestableMapProperties(propertyTypes, eventAdapterService);
        List<String> propertyNameList = propertySet.getPropertyNameList();
        this.propertyNames = propertyNameList.toArray(new String[propertyNameList.size()]);
        this.propertyGetters = propertySet.getPropertyGetters();
        this.propertyGetterCache = new HashMap<String, MapEventPropertyGetter>();
        this.simplePropertyTypes = propertySet.getSimplePropertyTypes();
        this.simpleFragmentTypes = propertySet.getSimpleFragmentTypes();
        this.propertyDescriptors = propertySet.getPropertyDescriptors().toArray(new EventPropertyDescriptor[propertySet.getPropertyDescriptors().size()]);
        this.propertyDescriptorMap = new HashMap<String, EventPropertyDescriptor>();
        for (EventPropertyDescriptor desc : this.propertyDescriptors) {
            this.propertyDescriptorMap.put(desc.getPropertyName(), desc);
        }
        this.hashCode = typeName.hashCode();
        for (Map.Entry<String, Class> entry : this.simplePropertyTypes.entrySet()) {
            this.hashCode *= 31;
            this.hashCode ^= entry.getKey().hashCode();
        }
        this.copySuperTypes();
    }

    @Override
    public String getName() {
        return this.metadata.getPublicName();
    }

    @Override
    public EventBeanReader getReader() {
        return new MapEventBeanReader(this);
    }

    @Override
    public final Class getPropertyType(String propertyName) {
        Object nestedType;
        Class result = this.simplePropertyTypes.get(ASTFilterSpecHelper.unescapeDot(propertyName));
        if (result != null) {
            return result;
        }
        int index = ASTFilterSpecHelper.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            if (propertyName.endsWith("?")) {
                return Object.class;
            }
            Property property = PropertyParser.parse(propertyName, false);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = this.nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof EventType[]) {
                    return ((EventType[])type)[0].getUnderlyingType();
                }
                if (type instanceof String) {
                    String propTypeName = type.toString();
                    boolean isArray = MapEventType.isPropertyArray(propTypeName);
                    if (isArray) {
                        propTypeName = MapEventType.getPropertyRemoveArray(propTypeName);
                    }
                    EventType innerType = this.eventAdapterService.getExistsTypeByName(propTypeName);
                    return innerType.getUnderlyingType();
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                return ((Class)type).getComponentType();
            }
            if (property instanceof MappedProperty) {
                MappedProperty mappedProp = (MappedProperty)property;
                Object type = this.nestableTypes.get(mappedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof Class && JavaClassHelper.isImplementsInterface((Class)type, Map.class)) {
                    return Object.class;
                }
                return null;
            }
            return null;
        }
        String propertyMap = ASTFilterSpecHelper.unescapeDot(propertyName.substring(0, index));
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        boolean isRootedDynamic = false;
        if (propertyMap.endsWith("?")) {
            propertyMap = propertyMap.substring(0, propertyMap.length() - 1);
            isRootedDynamic = true;
        }
        if ((nestedType = this.nestableTypes.get(propertyMap)) == null) {
            Property property = PropertyParser.parse(propertyMap, false);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = this.nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof String) {
                    EventType innerType;
                    String propTypeName = type.toString();
                    boolean isArray = MapEventType.isPropertyArray(propTypeName);
                    if (isArray) {
                        propTypeName = MapEventType.getPropertyRemoveArray(propTypeName);
                    }
                    if (!((innerType = this.eventAdapterService.getExistsTypeByName(propTypeName)) instanceof MapEventType)) {
                        return null;
                    }
                    return innerType.getPropertyType(propertyNested);
                }
                if (type instanceof EventType[]) {
                    EventType innerType = ((EventType[])type)[0];
                    return innerType.getPropertyType(propertyNested);
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                Class<?> componentType = ((Class)type).getComponentType();
                EventType nestedEventType = this.eventAdapterService.addBeanType(componentType.getName(), componentType, false);
                return nestedEventType.getPropertyType(propertyNested);
            }
            if (property instanceof MappedProperty) {
                return null;
            }
            return null;
        }
        if (nestedType == Map.class) {
            Property prop = PropertyParser.parse(propertyNested, isRootedDynamic);
            return prop.getPropertyTypeMap(null, this.eventAdapterService);
        }
        if (nestedType instanceof Map) {
            Property prop = PropertyParser.parse(propertyNested, isRootedDynamic);
            Map nestedTypes = (Map)nestedType;
            return prop.getPropertyTypeMap(nestedTypes, this.eventAdapterService);
        }
        if (nestedType instanceof Class) {
            Class simpleClass = (Class)nestedType;
            EventType nestedEventType = this.eventAdapterService.addBeanType(simpleClass.getName(), simpleClass, false);
            return nestedEventType.getPropertyType(propertyNested);
        }
        if (nestedType instanceof EventType) {
            EventType innerType = (EventType)nestedType;
            return innerType.getPropertyType(propertyNested);
        }
        if (nestedType instanceof EventType[]) {
            return null;
        }
        if (nestedType instanceof String) {
            EventType innerType;
            String nestedName = nestedType.toString();
            boolean isArray = MapEventType.isPropertyArray(nestedName);
            if (isArray) {
                nestedName = MapEventType.getPropertyRemoveArray(nestedName);
            }
            if (!((innerType = this.eventAdapterService.getExistsTypeByName(nestedName)) instanceof MapEventType)) {
                return null;
            }
            return innerType.getPropertyType(propertyNested);
        }
        String message = "Nestable map type configuration encountered an unexpected value type of '" + nestedType.getClass() + " for property '" + propertyName + "', expected Class, Map.class or Map<String, Object> as value type";
        throw new PropertyAccessException(message);
    }

    @Override
    public final Class getUnderlyingType() {
        return Map.class;
    }

    @Override
    public MapEventPropertyGetter getGetter(String propertyName) {
        Object nestedType;
        MapEventPropertyGetter cachedGetter = this.propertyGetterCache.get(propertyName);
        if (cachedGetter != null) {
            return cachedGetter;
        }
        String unescapePropName = ASTFilterSpecHelper.unescapeDot(propertyName);
        MapEventPropertyGetter getter = this.propertyGetters.get(unescapePropName);
        if (getter != null) {
            this.propertyGetterCache.put(propertyName, getter);
            return getter;
        }
        int index = ASTFilterSpecHelper.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            Property prop = PropertyParser.parse(propertyName, false);
            if (prop instanceof DynamicProperty) {
                MapEventPropertyGetter getterDyn = prop.getGetterMap(null, this.eventAdapterService);
                this.propertyGetterCache.put(propertyName, getterDyn);
                return getterDyn;
            }
            if (prop instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)prop;
                Object type = this.nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof EventType[]) {
                    MapEventBeanArrayIndexedPropertyGetter getterArr = new MapEventBeanArrayIndexedPropertyGetter(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex());
                    this.propertyGetterCache.put(propertyName, getterArr);
                    return getterArr;
                }
                if (type instanceof String) {
                    EventType innerType;
                    String nestedTypeName = type.toString();
                    boolean isArray = MapEventType.isPropertyArray(nestedTypeName);
                    if (isArray) {
                        nestedTypeName = MapEventType.getPropertyRemoveArray(nestedTypeName);
                    }
                    if (!((innerType = this.eventAdapterService.getExistsTypeByName(nestedTypeName)) instanceof MapEventType)) {
                        return null;
                    }
                    MapEventPropertyGetter typeGetter = !isArray ? new MapMaptypedUndPropertyGetter(indexedProp.getPropertyNameAtomic(), this.eventAdapterService, innerType) : new MapArrayMaptypedUndPropertyGetter(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), this.eventAdapterService, innerType);
                    this.propertyGetterCache.put(propertyName, typeGetter);
                    return typeGetter;
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                Class<?> componentType = ((Class)type).getComponentType();
                MapArrayPOJOEntryIndexedPropertyGetter indexedGetter = new MapArrayPOJOEntryIndexedPropertyGetter(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), this.eventAdapterService, componentType);
                this.propertyGetterCache.put(propertyName, indexedGetter);
                return indexedGetter;
            }
            if (prop instanceof MappedProperty) {
                MappedProperty mappedProp = (MappedProperty)prop;
                Object type = this.nestableTypes.get(mappedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof Class && JavaClassHelper.isImplementsInterface((Class)type, Map.class)) {
                    return new MapMappedPropertyGetter(mappedProp.getPropertyNameAtomic(), mappedProp.getKey());
                }
                return null;
            }
            return null;
        }
        String propertyMap = ASTFilterSpecHelper.unescapeDot(propertyName.substring(0, index));
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        boolean isRootedDynamic = false;
        if (propertyMap.endsWith("?")) {
            propertyMap = propertyMap.substring(0, propertyMap.length() - 1);
            isRootedDynamic = true;
        }
        if ((nestedType = this.nestableTypes.get(propertyMap)) == null) {
            Property property = PropertyParser.parse(propertyMap, false);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = this.nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof String) {
                    EventType innerType;
                    String nestedTypeName = type.toString();
                    boolean isArray = MapEventType.isPropertyArray(nestedTypeName);
                    if (isArray) {
                        nestedTypeName = MapEventType.getPropertyRemoveArray(nestedTypeName);
                    }
                    if (!((innerType = this.eventAdapterService.getExistsTypeByName(nestedTypeName)) instanceof MapEventType)) {
                        return null;
                    }
                    MapEventPropertyGetter typeGetter = !isArray ? new MapMaptypedEntryPropertyGetter(propertyMap, innerType.getGetter(propertyNested), (MapEventType)innerType, this.eventAdapterService) : new MapArrayMaptypedEntryPropertyGetter(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), innerType.getGetter(propertyNested), innerType, this.eventAdapterService);
                    this.propertyGetterCache.put(propertyName, typeGetter);
                    return typeGetter;
                }
                if (type instanceof EventType[]) {
                    EventType componentType = ((EventType[])type)[0];
                    EventPropertyGetter nestedGetter = componentType.getGetter(propertyNested);
                    if (nestedGetter == null) {
                        return null;
                    }
                    MapEventBeanArrayIndexedElementPropertyGetter typeGetter = new MapEventBeanArrayIndexedElementPropertyGetter(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), nestedGetter);
                    this.propertyGetterCache.put(propertyName, typeGetter);
                    return typeGetter;
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                Class<?> componentType = ((Class)type).getComponentType();
                EventType nestedEventType = this.eventAdapterService.addBeanType(componentType.getName(), componentType, false);
                EventPropertyGetter nestedGetter = nestedEventType.getGetter(propertyNested);
                if (nestedGetter == null) {
                    return null;
                }
                Class propertyTypeGetter = nestedEventType.getPropertyType(propertyNested);
                MapArrayPOJOBeanEntryIndexedPropertyGetter indexGetter = new MapArrayPOJOBeanEntryIndexedPropertyGetter(indexedProp.getPropertyNameAtomic(), indexedProp.getIndex(), nestedGetter, this.eventAdapterService, propertyTypeGetter);
                this.propertyGetterCache.put(propertyName, indexGetter);
                return indexGetter;
            }
            if (property instanceof MappedProperty) {
                return null;
            }
            return null;
        }
        if (nestedType == Map.class) {
            Property prop = PropertyParser.parse(propertyNested, isRootedDynamic);
            MapEventPropertyGetter getterNestedMap = prop.getGetterMap(null, this.eventAdapterService);
            if (getterNestedMap == null) {
                return null;
            }
            MapPropertyGetter mapGetter = new MapPropertyGetter(propertyMap, getterNestedMap);
            this.propertyGetterCache.put(propertyName, mapGetter);
            return mapGetter;
        }
        if (nestedType instanceof Map) {
            Map nestedTypes;
            Property prop = PropertyParser.parse(propertyNested, isRootedDynamic);
            MapEventPropertyGetter getterNestedMap = prop.getGetterMap(nestedTypes = (Map)nestedType, this.eventAdapterService);
            if (getterNestedMap == null) {
                return null;
            }
            MapPropertyGetter mapGetter = new MapPropertyGetter(propertyMap, getterNestedMap);
            this.propertyGetterCache.put(propertyName, mapGetter);
            return mapGetter;
        }
        if (nestedType instanceof Class) {
            Class simpleClass = (Class)nestedType;
            EventType nestedEventType = this.eventAdapterService.addBeanType(simpleClass.getName(), simpleClass, false);
            EventPropertyGetter nestedGetter = nestedEventType.getGetter(propertyNested);
            if (nestedGetter == null) {
                return null;
            }
            Class nestedReturnType = nestedEventType.getPropertyType(propertyNested);
            getter = new MapPOJOEntryPropertyGetter(propertyMap, nestedGetter, this.eventAdapterService, nestedReturnType);
            this.propertyGetterCache.put(propertyName, getter);
            return getter;
        }
        if (nestedType instanceof EventType) {
            EventType innerType = (EventType)nestedType;
            EventPropertyGetter nestedGetter = innerType.getGetter(propertyNested);
            if (nestedGetter == null) {
                return null;
            }
            getter = new MapEventBeanEntryPropertyGetter(propertyMap, nestedGetter);
            this.propertyGetterCache.put(propertyName, getter);
            return getter;
        }
        if (nestedType instanceof EventType[]) {
            EventType[] typeArray = (EventType[])nestedType;
            Class underlying = typeArray[0].getUnderlyingType();
            MapEventBeanArrayPropertyGetter beanArrGetter = new MapEventBeanArrayPropertyGetter(propertyMap, underlying);
            this.propertyGetterCache.put(propertyName, beanArrGetter);
            return beanArrGetter;
        }
        if (nestedType instanceof String) {
            EventType innerType;
            String nestedName = nestedType.toString();
            boolean isArray = MapEventType.isPropertyArray(nestedName);
            if (isArray) {
                nestedName = MapEventType.getPropertyRemoveArray(nestedName);
            }
            if (!((innerType = this.eventAdapterService.getExistsTypeByName(nestedName)) instanceof MapEventType)) {
                return null;
            }
            EventPropertyGetter innerGetter = innerType.getGetter(propertyNested);
            if (innerGetter == null) {
                return null;
            }
            MapEventPropertyGetter maptypeGetter = !isArray ? new MapMaptypedEntryPropertyGetter(propertyMap, innerGetter, (MapEventType)innerType, this.eventAdapterService) : new MapArrayMaptypedEntryPropertyGetter(propertyMap, 0, innerGetter, innerType, this.eventAdapterService);
            this.propertyGetterCache.put(propertyName, maptypeGetter);
            return maptypeGetter;
        }
        String message = "Nestable map type configuration encountered an unexpected value type of '" + nestedType.getClass() + " for property '" + propertyName + "', expected Class, Map.class or Map<String, Object> as value type";
        throw new PropertyAccessException(message);
    }

    public Object getValue(String propertyName, Map values) {
        if (this.simplePropertyTypes.get(ASTFilterSpecHelper.unescapeDot(propertyName)) != null) {
            return values.get(ASTFilterSpecHelper.unescapeDot(propertyName));
        }
        int index = ASTFilterSpecHelper.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            return null;
        }
        String propertyMap = ASTFilterSpecHelper.unescapeDot(propertyName.substring(0, index));
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        Class result = this.simplePropertyTypes.get(propertyMap);
        if (result == null) {
            return null;
        }
        EventType nestedType = this.eventAdapterService.addBeanType(result.getName(), result, false);
        EventPropertyGetter nestedGetter = nestedType.getGetter(propertyNested);
        if (nestedGetter == null) {
            return null;
        }
        Object value = values.get(propertyMap);
        if (value == null) {
            return null;
        }
        EventBean event = this.eventAdapterService.adapterForBean(value);
        return nestedGetter.get(event);
    }

    @Override
    public String[] getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public boolean isProperty(String propertyName) {
        Class propertyType = this.getPropertyType(propertyName);
        if (propertyType == null && this.simplePropertyTypes.containsKey(ASTFilterSpecHelper.unescapeDot(propertyName))) {
            return true;
        }
        return propertyType != null;
    }

    @Override
    public EventType[] getSuperTypes() {
        return this.optionalSuperTypes;
    }

    @Override
    public Iterator<EventType> getDeepSuperTypes() {
        return this.optionalDeepSupertypes.iterator();
    }

    public String toString() {
        return "MapEventType typeName=" + this.typeName + " propertyNames=" + Arrays.toString(this.propertyNames);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EventType)) {
            return false;
        }
        String message = this.getEqualsMessage((EventType)obj);
        return message == null;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Map<String, Object> getTypes() {
        return this.nestableTypes;
    }

    public static boolean isEqualsProperties(Map<String, Class> setOne, Map<String, Class> setTwo) {
        if (setOne.size() != setTwo.size()) {
            return false;
        }
        for (Map.Entry<String, Class> entry : setOne.entrySet()) {
            Class boxedThis;
            Class boxedOther;
            Class otherClass = setTwo.get(entry.getKey());
            Class thisClass = entry.getValue();
            if (otherClass == null && thisClass != null || otherClass != null && thisClass == null) {
                return false;
            }
            if (otherClass == null || (boxedOther = JavaClassHelper.getBoxedType(otherClass)).equals(boxedThis = JavaClassHelper.getBoxedType(thisClass))) continue;
            return false;
        }
        return true;
    }

    public void addAdditionalProperties(Map<String, Object> typeMap, EventAdapterService eventAdapterService) {
        this.nestableTypes = GraphUtil.mergeNestableMap(typeMap, this.nestableTypes);
        PropertySetDescriptor propertySet = MapEventType.getNestableMapProperties(typeMap, eventAdapterService);
        ArrayList<EventPropertyDescriptor> newPropertyDescriptors = new ArrayList<EventPropertyDescriptor>();
        for (EventPropertyDescriptor propertyDesc : propertySet.getPropertyDescriptors()) {
            if (this.propertyGetters.containsKey(propertyDesc.getPropertyName())) continue;
            newPropertyDescriptors.add(propertyDesc);
        }
        ArrayList<String> newPropertyNames = new ArrayList<String>();
        for (String propertyName : propertySet.getPropertyNameList()) {
            if (this.propertyGetters.containsKey(propertyName)) continue;
            newPropertyNames.add(propertyName);
            this.propertyGetters.put(propertyName, propertySet.getPropertyGetters().get(propertyName));
            this.simplePropertyTypes.put(propertyName, propertySet.getSimplePropertyTypes().get(propertyName));
        }
        String[] allPropertyNames = new String[this.propertyNames.length + newPropertyNames.size()];
        System.arraycopy(this.propertyNames, 0, allPropertyNames, 0, this.propertyNames.length);
        int count = this.propertyNames.length;
        for (String newProperty : newPropertyNames) {
            allPropertyNames[count++] = newProperty;
        }
        this.propertyNames = allPropertyNames;
        EventPropertyDescriptor[] allPropertyDescriptors = new EventPropertyDescriptor[this.propertyDescriptors.length + newPropertyNames.size()];
        System.arraycopy(this.propertyDescriptors, 0, allPropertyDescriptors, 0, this.propertyDescriptors.length);
        count = this.propertyDescriptors.length;
        for (EventPropertyDescriptor desc : newPropertyDescriptors) {
            allPropertyDescriptors[count++] = desc;
        }
        this.propertyDescriptors = allPropertyDescriptors;
    }

    @Override
    public EventPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public static String isDeepEqualsProperties(String otherName, Map<String, Object> setOne, Map<String, Object> setTwo) {
        if (setOne.size() != setTwo.size()) {
            return "Type by name '" + otherName + "' expects " + setOne.size() + " properties but receives " + setTwo.size() + " properties";
        }
        for (Map.Entry<String, Object> entry : setOne.entrySet()) {
            String propName = entry.getKey();
            Object setTwoType = setTwo.get(entry.getKey());
            Object setOneType = entry.getValue();
            if (setTwoType == null && setOneType != null || setTwoType != null && setOneType == null) {
                return "Type by name '" + otherName + "' in property '" + propName + "' incompatible with null-type";
            }
            if (setTwoType == null) continue;
            if (setTwoType instanceof Class && setOneType instanceof Class) {
                Class boxedThis;
                Class boxedOther = JavaClassHelper.getBoxedType((Class)setTwoType);
                if (boxedOther.equals(boxedThis = JavaClassHelper.getBoxedType((Class)setOneType))) continue;
                return "Type by name '" + otherName + "' in property '" + propName + "' expected " + boxedThis + " but receives " + boxedOther;
            }
            if (setTwoType instanceof Map && setOneType instanceof Map) {
                String messageIsDeepEquals = MapEventType.isDeepEqualsProperties(propName, (Map)setOneType, (Map)setTwoType);
                if (messageIsDeepEquals == null) continue;
                return messageIsDeepEquals;
            }
            if (setTwoType instanceof EventType && setOneType instanceof EventType) {
                if (setOneType.equals(setTwoType)) continue;
                EventType setOneEventType = (EventType)setOneType;
                EventType setTwoEventType = (EventType)setTwoType;
                return "Type by name '" + otherName + "' in property '" + propName + "' expected event type '" + setOneEventType.getName() + "' but receives event type '" + setTwoEventType.getName() + "'";
            }
            String typeOne = MapEventType.getTypeName(setOneType);
            String typeTwo = MapEventType.getTypeName(setTwoType);
            return "Type by name '" + otherName + "' in property '" + propName + "' expected " + typeOne + " but receives " + typeTwo;
        }
        return null;
    }

    private static String getTypeName(Object setOneType) {
        if (setOneType == null) {
            return "null";
        }
        if (setOneType instanceof Class) {
            return ((Class)setOneType).getName();
        }
        if (setOneType instanceof EventType) {
            return "event type '" + ((EventType)setOneType).getName() + "'";
        }
        return setOneType.getClass().getName();
    }

    private static void generateExceptionNestedProp(String name, Object value) throws EPException {
        String clazzName = value == null ? "null" : value.getClass().getSimpleName();
        throw new EPException("Nestable map type configuration encountered an unexpected property type of '" + clazzName + "' for property '" + name + "', expected java.lang.Class or java.util.Map or the name of a previously-declared Map type");
    }

    private void copySuperTypes() {
        if (this.optionalSuperTypes != null) {
            LinkedHashSet<String> allProperties = new LinkedHashSet<String>(Arrays.asList(this.propertyNames));
            LinkedHashMap<String, EventPropertyDescriptor> allDescriptors = new LinkedHashMap<String, EventPropertyDescriptor>();
            for (EventPropertyDescriptor current : this.propertyDescriptors) {
                allDescriptors.put(current.getPropertyName(), current);
            }
            for (int i = 0; i < this.optionalSuperTypes.length; ++i) {
                allProperties.addAll(Arrays.asList(this.optionalSuperTypes[i].getPropertyNames()));
                MapEventType mapSuperType = (MapEventType)this.optionalSuperTypes[i];
                this.simplePropertyTypes.putAll(mapSuperType.simplePropertyTypes);
                this.propertyGetters.putAll(mapSuperType.propertyGetters);
                this.nestableTypes.putAll(mapSuperType.nestableTypes);
                for (EventPropertyDescriptor desc : this.optionalSuperTypes[i].getPropertyDescriptors()) {
                    allDescriptors.put(desc.getPropertyName(), desc);
                }
            }
            this.propertyNames = allProperties.toArray(new String[allProperties.size()]);
            Collection descs = allDescriptors.values();
            for (EventPropertyDescriptor desc : this.propertyDescriptors = descs.toArray(new EventPropertyDescriptor[descs.size()])) {
                this.propertyDescriptorMap.put(desc.getPropertyName(), desc);
            }
        }
    }

    private static PropertySetDescriptor getNestableMapProperties(Map<String, Object> propertiesToAdd, EventAdapterService eventAdapterService) throws EPException {
        ArrayList<String> propertyNameList = new ArrayList<String>();
        ArrayList<EventPropertyDescriptor> propertyDescriptors = new ArrayList<EventPropertyDescriptor>();
        HashMap<String, Class> simplePropertyTypes = new HashMap<String, Class>();
        HashMap<String, MapEventPropertyGetter> propertyGetters = new HashMap<String, MapEventPropertyGetter>();
        HashMap<String, FragmentEventType> eventTypeFragments = new HashMap<String, FragmentEventType>();
        for (Map.Entry<String, Object> entry : propertiesToAdd.entrySet()) {
            EventType eventType;
            MapEntryPropertyGetter getter;
            String value;
            Class clazz;
            if (!(entry.getKey() instanceof String)) {
                throw new EPException("Invalid map type configuration: property name is not a String-type value");
            }
            String name = entry.getKey();
            if (entry.getValue() instanceof String && (clazz = JavaClassHelper.getPrimitiveClassForName(value = entry.getValue().toString().trim())) != null) {
                entry.setValue(clazz);
            }
            if (entry.getValue() instanceof Class) {
                Class classType = (Class)entry.getValue();
                simplePropertyTypes.put(name, classType);
                propertyNameList.add(name);
                boolean isArray = classType.isArray();
                Class<?> componentType = null;
                if (isArray) {
                    componentType = classType.getComponentType();
                }
                boolean isFragment = JavaClassHelper.isFragmentableType(classType);
                BeanEventType nativeFragmentType = null;
                if (isFragment) {
                    FragmentEventType fragmentType = EventBeanUtility.createNativeFragmentType(classType, null, eventAdapterService);
                    if (fragmentType != null) {
                        nativeFragmentType = (BeanEventType)fragmentType.getFragmentType();
                        eventTypeFragments.put(name, fragmentType);
                    } else {
                        isFragment = false;
                    }
                } else {
                    eventTypeFragments.put(name, null);
                }
                propertyDescriptors.add(new EventPropertyDescriptor(name, classType, componentType, false, false, isArray, false, isFragment));
                MapEntryPropertyGetter getter2 = new MapEntryPropertyGetter(name, nativeFragmentType, eventAdapterService);
                propertyGetters.put(name, getter2);
                continue;
            }
            if (entry.getValue() == null) {
                simplePropertyTypes.put(name, null);
                propertyNameList.add(name);
                getter = new MapEntryPropertyGetter(name, null, null);
                propertyGetters.put(name, getter);
                propertyDescriptors.add(new EventPropertyDescriptor(name, null, null, false, false, false, false, false));
                eventTypeFragments.put(name, null);
                continue;
            }
            if (entry.getValue() instanceof Map) {
                simplePropertyTypes.put(name, Map.class);
                propertyNameList.add(name);
                getter = new MapEntryPropertyGetter(name, null, null);
                propertyGetters.put(name, getter);
                propertyDescriptors.add(new EventPropertyDescriptor(name, Map.class, null, false, false, false, true, false));
                eventTypeFragments.put(name, null);
                continue;
            }
            if (entry.getValue() instanceof EventType) {
                eventType = (EventType)entry.getValue();
                simplePropertyTypes.put(name, eventType.getUnderlyingType());
                propertyNameList.add(name);
                MapEventBeanPropertyGetter getter3 = new MapEventBeanPropertyGetter(name);
                propertyGetters.put(name, getter3);
                propertyDescriptors.add(new EventPropertyDescriptor(name, eventType.getUnderlyingType(), null, false, false, false, false, true));
                eventTypeFragments.put(name, new FragmentEventType(eventType, false, false));
                continue;
            }
            if (entry.getValue() instanceof EventType[]) {
                eventType = ((EventType[])entry.getValue())[0];
                Object prototypeArray = Array.newInstance(eventType.getUnderlyingType(), 0);
                simplePropertyTypes.put(name, prototypeArray.getClass());
                propertyNameList.add(name);
                MapEventBeanArrayPropertyGetter getter4 = new MapEventBeanArrayPropertyGetter(name, eventType.getUnderlyingType());
                propertyGetters.put(name, getter4);
                propertyDescriptors.add(new EventPropertyDescriptor(name, prototypeArray.getClass(), eventType.getUnderlyingType(), false, false, true, false, true));
                eventTypeFragments.put(name, new FragmentEventType(eventType, true, false));
                continue;
            }
            if (entry.getValue() instanceof String) {
                EventType eventType2;
                String propertyName = entry.getValue().toString();
                boolean isArray = MapEventType.isPropertyArray(propertyName);
                if (isArray) {
                    propertyName = MapEventType.getPropertyRemoveArray(propertyName);
                }
                if (!((eventType2 = eventAdapterService.getExistsTypeByName(propertyName)) instanceof MapEventType)) {
                    throw new EPException("Nestable map type configuration encountered an unexpected property type name '" + entry.getValue() + "' for property '" + name + "', expected java.lang.Class or java.util.Map or the name of a previously-declared Map type");
                }
                Class<?> underlyingType = eventType2.getUnderlyingType();
                if (isArray) {
                    underlyingType = Array.newInstance(underlyingType, 0).getClass();
                }
                simplePropertyTypes.put(name, underlyingType);
                propertyNameList.add(name);
                MapEventPropertyGetter getter5 = !isArray ? new MapMaptypedPropertyGetter(name, eventType2, eventAdapterService) : new MapMaptypedArrayPropertyGetter(name, eventType2, eventAdapterService);
                propertyGetters.put(name, getter5);
                propertyDescriptors.add(new EventPropertyDescriptor(name, underlyingType, null, false, false, isArray, false, true));
                eventTypeFragments.put(name, new FragmentEventType(eventType2, isArray, false));
                continue;
            }
            MapEventType.generateExceptionNestedProp(name, entry.getValue());
        }
        return new PropertySetDescriptor(propertyNameList, propertyDescriptors, simplePropertyTypes, propertyGetters, eventTypeFragments);
    }

    @Override
    public EventPropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.propertyDescriptorMap.get(propertyName);
    }

    @Override
    public EventTypeMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public FragmentEventType getFragmentType(String propertyName) {
        if (this.simpleFragmentTypes.containsKey(propertyName)) {
            return this.simpleFragmentTypes.get(propertyName);
        }
        int index = ASTFilterSpecHelper.unescapedIndexOfDot(propertyName);
        if (index == -1) {
            if (propertyName.endsWith("?")) {
                return null;
            }
            Property property = PropertyParser.parse(propertyName, false);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = this.nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof EventType[]) {
                    EventType eventType = ((EventType[])type)[0];
                    return new FragmentEventType(eventType, false, false);
                }
                if (type instanceof String) {
                    String propTypeName = type.toString();
                    boolean isArray = MapEventType.isPropertyArray(propTypeName);
                    if (!isArray) {
                        return null;
                    }
                    EventType innerType = this.eventAdapterService.getExistsTypeByName(propTypeName = MapEventType.getPropertyRemoveArray(propTypeName));
                    if (!(innerType instanceof MapEventType)) {
                        return null;
                    }
                    return new FragmentEventType(innerType, false, false);
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                return EventBeanUtility.createNativeFragmentType(((Class)type).getComponentType(), null, this.eventAdapterService);
            }
            if (property instanceof MappedProperty) {
                return null;
            }
            return null;
        }
        String propertyMap = ASTFilterSpecHelper.unescapeDot(propertyName.substring(0, index));
        String propertyNested = propertyName.substring(index + 1, propertyName.length());
        if (propertyMap.endsWith("?")) {
            return null;
        }
        Object nestedType = this.nestableTypes.get(propertyMap);
        if (nestedType == null) {
            Property property = PropertyParser.parse(propertyMap, false);
            if (property instanceof IndexedProperty) {
                IndexedProperty indexedProp = (IndexedProperty)property;
                Object type = this.nestableTypes.get(indexedProp.getPropertyNameAtomic());
                if (type == null) {
                    return null;
                }
                if (type instanceof String) {
                    EventType innerType;
                    String propTypeName = type.toString();
                    boolean isArray = MapEventType.isPropertyArray(propTypeName);
                    if (isArray) {
                        propTypeName = MapEventType.getPropertyRemoveArray(propTypeName);
                    }
                    if (!((innerType = this.eventAdapterService.getExistsTypeByName(propTypeName)) instanceof MapEventType)) {
                        return null;
                    }
                    return innerType.getFragmentType(propertyNested);
                }
                if (type instanceof EventType[]) {
                    EventType innerType = ((EventType[])type)[0];
                    return innerType.getFragmentType(propertyNested);
                }
                if (!(type instanceof Class)) {
                    return null;
                }
                if (!((Class)type).isArray()) {
                    return null;
                }
                FragmentEventType fragmentParent = EventBeanUtility.createNativeFragmentType((Class)type, null, this.eventAdapterService);
                if (fragmentParent == null) {
                    return null;
                }
                return fragmentParent.getFragmentType().getFragmentType(propertyNested);
            }
            if (property instanceof MappedProperty) {
                return null;
            }
            return null;
        }
        if (nestedType == Map.class) {
            return null;
        }
        if (nestedType instanceof Map) {
            return null;
        }
        if (nestedType instanceof Class) {
            Class simpleClass = (Class)nestedType;
            if (!JavaClassHelper.isFragmentableType(simpleClass)) {
                return null;
            }
            BeanEventType nestedEventType = this.eventAdapterService.getBeanEventTypeFactory().createBeanTypeDefaultName(simpleClass);
            return nestedEventType.getFragmentType(propertyNested);
        }
        if (nestedType instanceof EventType) {
            EventType innerType = (EventType)nestedType;
            return innerType.getFragmentType(propertyNested);
        }
        if (nestedType instanceof EventType[]) {
            EventType[] innerType = (EventType[])nestedType;
            return innerType[0].getFragmentType(propertyNested);
        }
        if (nestedType instanceof String) {
            EventType innerType;
            String nestedName = nestedType.toString();
            boolean isArray = MapEventType.isPropertyArray(nestedName);
            if (isArray) {
                nestedName = MapEventType.getPropertyRemoveArray(nestedName);
            }
            if (!((innerType = this.eventAdapterService.getExistsTypeByName(nestedName)) instanceof MapEventType)) {
                return null;
            }
            return innerType.getFragmentType(propertyNested);
        }
        String message = "Nestable map type configuration encountered an unexpected value type of '" + nestedType.getClass() + " for property '" + propertyName + "', expected Class, Map.class or Map<String, Object> as value type";
        throw new PropertyAccessException(message);
    }

    public static boolean isPropertyArray(String name) {
        return name.trim().endsWith("[]");
    }

    public static String getPropertyRemoveArray(String name) {
        return name.replaceAll("\\[", "").replaceAll("\\]", "");
    }

    public String getEqualsMessage(EventType otherType) {
        if (!(otherType instanceof MapEventType)) {
            return "Type by name '" + otherType.getName() + "' is not a compatible type";
        }
        MapEventType other = (MapEventType)otherType;
        if (this.metadata.getTypeClass() != EventTypeMetadata.TypeClass.ANONYMOUS && !other.typeName.equals(this.typeName)) {
            return "Type by name '" + otherType.getName() + "' is not the same name";
        }
        return MapEventType.isDeepEqualsProperties(otherType.getName(), other.nestableTypes, this.nestableTypes);
    }

    @Override
    public EventPropertyWriter getWriter(String propertyName) {
        Pair<EventPropertyDescriptor, EventPropertyWriter> pair;
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.propertyWriters.get(propertyName)) == null) {
            return null;
        }
        return pair.getSecond();
    }

    @Override
    public EventPropertyDescriptor getWritableProperty(String propertyName) {
        Pair<EventPropertyDescriptor, EventPropertyWriter> pair;
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        if ((pair = this.propertyWriters.get(propertyName)) == null) {
            return null;
        }
        return pair.getFirst();
    }

    @Override
    public EventPropertyDescriptor[] getWriteableProperties() {
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        return this.writablePropertyDescriptors;
    }

    private void initializeWriters() {
        ArrayList<EventPropertyDescriptor> writeableProps = new ArrayList<EventPropertyDescriptor>();
        HashMap<String, Pair<EventPropertyDescriptor, EventPropertyWriter>> propertWritersMap = new HashMap<String, Pair<EventPropertyDescriptor, EventPropertyWriter>>();
        for (EventPropertyDescriptor prop : this.propertyDescriptors) {
            if (prop.isFragment() || prop.isIndexed() || prop.isMapped()) continue;
            writeableProps.add(prop);
            final String propertyName = prop.getPropertyName();
            EventPropertyWriter eventPropertyWriter = new EventPropertyWriter(){

                public void write(Object value, EventBean target) {
                    MappedEventBean map = (MappedEventBean)((Object)target);
                    map.getProperties().put(propertyName, value);
                }
            };
            propertWritersMap.put(propertyName, new Pair<EventPropertyDescriptor, 1>(prop, eventPropertyWriter));
        }
        this.propertyWriters = propertWritersMap;
        this.writablePropertyDescriptors = writeableProps.toArray(new EventPropertyDescriptor[writeableProps.size()]);
    }

    @Override
    public EventBeanWriter getWriter(String[] properties) {
        if (this.writablePropertyDescriptors == null) {
            this.initializeWriters();
        }
        for (int i = 0; i < properties.length; ++i) {
            if (this.propertyWriters.containsKey(properties[i])) continue;
            return null;
        }
        return new MapEventBeanWriter(properties);
    }

    @Override
    public EventBeanCopyMethod getCopyMethod(String[] properties) {
        return new MapEventBeanCopyMethod(this, this.eventAdapterService);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertySetDescriptor {
        private final List<String> propertyNameList;
        private final List<EventPropertyDescriptor> propertyDescriptors;
        private final Map<String, Class> simplePropertyTypes;
        private final Map<String, MapEventPropertyGetter> propertyGetters;
        private final Map<String, FragmentEventType> simpleFragmentTypes;

        public PropertySetDescriptor(List<String> propertyNameList, List<EventPropertyDescriptor> propertyDescriptors, Map<String, Class> simplePropertyTypes, Map<String, MapEventPropertyGetter> propertyGetters, Map<String, FragmentEventType> simpleFragmentTypes) {
            this.propertyNameList = propertyNameList;
            this.propertyDescriptors = propertyDescriptors;
            this.simplePropertyTypes = simplePropertyTypes;
            this.propertyGetters = propertyGetters;
            this.simpleFragmentTypes = simpleFragmentTypes;
        }

        public Map<String, Class> getSimplePropertyTypes() {
            return this.simplePropertyTypes;
        }

        public Map<String, MapEventPropertyGetter> getPropertyGetters() {
            return this.propertyGetters;
        }

        public List<String> getPropertyNameList() {
            return this.propertyNameList;
        }

        public List<EventPropertyDescriptor> getPropertyDescriptors() {
            return this.propertyDescriptors;
        }

        public Map<String, FragmentEventType> getSimpleFragmentTypes() {
            return this.simpleFragmentTypes;
        }
    }
}

