/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.property;

import com.espertech.esper.antlr.ASTUtil;
import com.espertech.esper.antlr.NoCaseSensitiveStream;
import com.espertech.esper.client.PropertyAccessException;
import com.espertech.esper.epl.generated.EsperEPL2GrammarLexer;
import com.espertech.esper.epl.generated.EsperEPL2GrammarParser;
import com.espertech.esper.epl.parse.ExceptionConvertor;
import com.espertech.esper.event.property.DynamicIndexedProperty;
import com.espertech.esper.event.property.DynamicMappedProperty;
import com.espertech.esper.event.property.DynamicSimpleProperty;
import com.espertech.esper.event.property.IndexedProperty;
import com.espertech.esper.event.property.MappedProperty;
import com.espertech.esper.event.property.NestedProperty;
import com.espertech.esper.event.property.Property;
import com.espertech.esper.event.property.SimpleProperty;
import com.espertech.esper.type.IntValue;
import com.espertech.esper.type.StringValue;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.Tree;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyParser {
    private static final Log log = LogFactory.getLog(PropertyParser.class);

    public static Property parse(String propertyName, boolean isRootedDynamic) {
        Tree tree = PropertyParser.parse(propertyName);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            ASTUtil.dumpAST(tree);
        }
        if (tree.getChildCount() == 1) {
            return PropertyParser.makeProperty(tree.getChild(0), isRootedDynamic);
        }
        LinkedList<Property> properties = new LinkedList<Property>();
        boolean isRootedInDynamic = isRootedDynamic;
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree child = tree.getChild(i);
            Property property = PropertyParser.makeProperty(child, isRootedInDynamic);
            if (property instanceof DynamicSimpleProperty) {
                isRootedInDynamic = true;
            }
            properties.add(property);
        }
        return new NestedProperty(properties);
    }

    public static Tree parse(String propertyName) {
        EsperEPL2GrammarParser.startEventPropertyRule_return r;
        NoCaseSensitiveStream input;
        try {
            input = new NoCaseSensitiveStream(new StringReader(propertyName));
        }
        catch (IOException ex) {
            throw new PropertyAccessException("IOException parsing property name '" + propertyName + '\'', ex);
        }
        EsperEPL2GrammarLexer lex = new EsperEPL2GrammarLexer(input);
        CommonTokenStream tokens = new CommonTokenStream(lex);
        EsperEPL2GrammarParser g = new EsperEPL2GrammarParser(tokens);
        try {
            r = g.startEventPropertyRule();
        }
        catch (RuntimeException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error parsing property expression [" + propertyName + "]", e);
            }
            if (e.getCause() instanceof RecognitionException) {
                throw ExceptionConvertor.convertProperty((RecognitionException)e.getCause(), propertyName, true, g);
            }
            throw e;
        }
        catch (RecognitionException e) {
            throw ExceptionConvertor.convertProperty(e, propertyName, true, g);
        }
        return (Tree)r.getTree();
    }

    public static boolean isPropertyDynamic(Tree ast) {
        for (int i = 0; i < ast.getChildCount(); ++i) {
            int type = ast.getChild(i).getType();
            if (type != 162 && type != 163 && type != 164) continue;
            return true;
        }
        return false;
    }

    private static Property makeProperty(Tree child, boolean isRootedInDynamic) {
        switch (child.getType()) {
            case 159: {
                if (!isRootedInDynamic) {
                    return new SimpleProperty(child.getChild(0).getText());
                }
                return new DynamicSimpleProperty(child.getChild(0).getText());
            }
            case 160: {
                String key = StringValue.parseString(child.getChild(1).getText());
                if (!isRootedInDynamic) {
                    return new MappedProperty(child.getChild(0).getText(), key);
                }
                return new DynamicMappedProperty(child.getChild(0).getText(), key);
            }
            case 161: {
                int index = IntValue.parseString(child.getChild(1).getText());
                if (!isRootedInDynamic) {
                    return new IndexedProperty(child.getChild(0).getText(), index);
                }
                return new DynamicIndexedProperty(child.getChild(0).getText(), index);
            }
            case 162: {
                return new DynamicSimpleProperty(child.getChild(0).getText());
            }
            case 163: {
                int index = IntValue.parseString(child.getChild(1).getText());
                return new DynamicIndexedProperty(child.getChild(0).getText(), index);
            }
            case 164: {
                String key = StringValue.parseString(child.getChild(1).getText());
                return new DynamicMappedProperty(child.getChild(0).getText(), key);
            }
        }
        throw new IllegalStateException("Event property AST node not recognized, type=" + child.getType());
    }
}

