/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.vaevent;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventPropertyGetter;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.event.vaevent.PropertyGroupDesc;
import com.espertech.esper.event.vaevent.RevisionTypeDesc;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtility {
    private static final Log log = LogFactory.getLog(PropertyUtility.class);

    public static MultiKeyUntyped getKeys(EventBean event, EventPropertyGetter[] keyPropertyGetters) {
        Object[] keys = new Object[keyPropertyGetters.length];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = keyPropertyGetters[i].get(event);
        }
        return new MultiKeyUntyped(keys);
    }

    public static Map<EventType, RevisionTypeDesc> getPerType(PropertyGroupDesc[] groups, String[] changesetProperties, String[] keyProperties) {
        HashMap<EventType, RevisionTypeDesc> perType = new HashMap<EventType, RevisionTypeDesc>();
        for (PropertyGroupDesc group : groups) {
            for (EventType type : group.getTypes().keySet()) {
                EventPropertyGetter[] changesetGetters = PropertyUtility.getGetters(type, changesetProperties);
                EventPropertyGetter[] keyGetters = PropertyUtility.getGetters(type, keyProperties);
                RevisionTypeDesc pair = new RevisionTypeDesc(keyGetters, changesetGetters, group);
                perType.put(type, pair);
            }
        }
        return perType;
    }

    public static Map<String, int[]> getGroupsPerProperty(PropertyGroupDesc[] groups) {
        HashMap<String, int[]> groupsNumsPerProp = new HashMap<String, int[]>();
        for (PropertyGroupDesc group : groups) {
            for (String property : group.getProperties()) {
                int[] value = (int[])groupsNumsPerProp.get(property);
                if (value == null) {
                    value = new int[1];
                    groupsNumsPerProp.put(property, value);
                    value[0] = group.getGroupNum();
                    continue;
                }
                int[] copy = new int[value.length + 1];
                System.arraycopy(value, 0, copy, 0, value.length);
                copy[value.length] = group.getGroupNum();
                Arrays.sort(copy);
                groupsNumsPerProp.put(property, copy);
            }
        }
        return groupsNumsPerProp;
    }

    public static PropertyGroupDesc[] analyzeGroups(String[] allProperties, EventType[] deltaEventTypes, String[] names) {
        if (deltaEventTypes.length != names.length) {
            throw new IllegalArgumentException("Delta event type number and name number of elements don't match");
        }
        allProperties = PropertyUtility.copyAndSort(allProperties);
        LinkedHashMap<MultiKey<String>, PropertyGroupDesc> result = new LinkedHashMap<MultiKey<String>, PropertyGroupDesc>();
        int currentGroupNum = 0;
        for (int i = 0; i < deltaEventTypes.length; ++i) {
            Map<EventType, String> typesForGroup;
            MultiKey<String> props = PropertyUtility.getPropertiesContributed(deltaEventTypes[i], allProperties);
            if (props.getArray().length == 0) {
                log.warn("Event type name '" + names[i] + "' does not contribute (or override) any properties of the revision event type");
                continue;
            }
            PropertyGroupDesc propertyGroup = (PropertyGroupDesc)result.get(props);
            if (propertyGroup == null) {
                typesForGroup = new HashMap<EventType, String>();
                propertyGroup = new PropertyGroupDesc(currentGroupNum++, typesForGroup, props.getArray());
                result.put(props, propertyGroup);
            } else {
                typesForGroup = propertyGroup.getTypes();
            }
            typesForGroup.put(deltaEventTypes[i], names[i]);
        }
        Collection out = result.values();
        Object[] array = out.toArray(new PropertyGroupDesc[out.size()]);
        if (log.isDebugEnabled()) {
            log.debug(".analyzeGroups " + Arrays.toString(array));
        }
        return array;
    }

    private static MultiKey<String> getPropertiesContributed(EventType deltaEventType, String[] allPropertiesSorted) {
        TreeSet<String> props = new TreeSet<String>();
        block0: for (String property : deltaEventType.getPropertyNames()) {
            for (String propInAll : allPropertiesSorted) {
                if (!propInAll.equals(property)) continue;
                props.add(property);
                continue block0;
            }
        }
        return new MultiKey<String>(props.toArray(new String[props.size()]));
    }

    protected static String[] copyAndSort(String[] input) {
        Object[] result = new String[input.length];
        System.arraycopy(input, 0, result, 0, input.length);
        Arrays.sort(result);
        return result;
    }

    public static EventPropertyGetter[] getGetters(EventType eventType, String[] propertyNames) {
        EventPropertyGetter[] getters = new EventPropertyGetter[propertyNames.length];
        for (int i = 0; i < getters.length; ++i) {
            getters[i] = eventType.getGetter(propertyNames[i]);
        }
        return getters;
    }

    protected static String[] uniqueExclusiveSort(String[] values, String[] removeValues) {
        HashSet<String> unique = new HashSet<String>();
        unique.addAll(Arrays.asList(values));
        for (String removeValue : removeValues) {
            unique.remove(removeValue);
        }
        Object[] uniqueArr = unique.toArray(new String[unique.size()]);
        Arrays.sort(uniqueArr);
        return uniqueArr;
    }
}

