/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.event.xml;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.event.xml.BaseXMLEventType;
import com.espertech.esper.event.xml.FragmentFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

public class FragmentFactoryXPathPredefinedGetter
implements FragmentFactory {
    private static final Log log = LogFactory.getLog(FragmentFactoryXPathPredefinedGetter.class);
    private final EventAdapterService eventAdapterService;
    private final String eventTypeName;
    private final String propertyName;
    private volatile EventType eventType;

    public FragmentFactoryXPathPredefinedGetter(EventAdapterService eventAdapterService, String eventTypeName, String propertyName) {
        this.eventAdapterService = eventAdapterService;
        this.eventTypeName = eventTypeName;
        this.propertyName = propertyName;
    }

    public EventBean getEvent(Node result) {
        if (this.eventType == null) {
            EventType candidateEventType = this.eventAdapterService.getExistsTypeByName(this.eventTypeName);
            if (candidateEventType == null) {
                log.warn("Event type by name '" + this.eventTypeName + "' was not found for property '" + this.propertyName + "'");
                return null;
            }
            if (!(candidateEventType instanceof BaseXMLEventType)) {
                log.warn("Event type by name '" + this.eventTypeName + "' is not an XML event type for property '" + this.propertyName + "'");
                return null;
            }
            this.eventType = candidateEventType;
        }
        return this.eventAdapterService.adapterForTypedDOM(result, this.eventType);
    }
}

