/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.filter.EventTypeIndex;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterHandleSetNode;
import com.espertech.esper.filter.FilterSet;
import com.espertech.esper.filter.FilterSetEntry;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.filter.IndexTreeBuilder;
import com.espertech.esper.filter.IndexTreePath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTypeIndexBuilder {
    private final Map<FilterHandle, Pair<FilterValueSet, IndexTreePath>> callbacks;
    private final Lock callbacksLock;
    private final EventTypeIndex eventTypeIndex;

    public EventTypeIndexBuilder(EventTypeIndex eventTypeIndex) {
        this.eventTypeIndex = eventTypeIndex;
        this.callbacks = new HashMap<FilterHandle, Pair<FilterValueSet, IndexTreePath>>();
        this.callbacksLock = new ReentrantLock();
    }

    public void destroy() {
        this.callbacks.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(FilterValueSet filterValueSet, FilterHandle filterCallback) {
        EventType eventType = filterValueSet.getEventType();
        FilterHandleSetNode rootNode = this.eventTypeIndex.get(eventType);
        if (rootNode == null) {
            this.callbacksLock.lock();
            try {
                rootNode = this.eventTypeIndex.get(eventType);
                if (rootNode == null) {
                    rootNode = new FilterHandleSetNode();
                    this.eventTypeIndex.add(eventType, rootNode);
                }
            }
            finally {
                this.callbacksLock.unlock();
            }
        }
        this.callbacksLock.lock();
        try {
            if (this.callbacks.containsKey(filterCallback)) {
                throw new IllegalStateException("Callback for filter specification already exists in collection");
            }
        }
        finally {
            this.callbacksLock.unlock();
        }
        IndexTreeBuilder treeBuilder = new IndexTreeBuilder();
        IndexTreePath path = treeBuilder.add(filterValueSet, filterCallback, rootNode);
        this.callbacksLock.lock();
        try {
            this.callbacks.put(filterCallback, new Pair<FilterValueSet, IndexTreePath>(filterValueSet, path));
        }
        finally {
            this.callbacksLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void remove(FilterHandle filterCallback) {
        Pair<FilterValueSet, IndexTreePath> pair = null;
        this.callbacksLock.lock();
        try {
            pair = this.callbacks.get(filterCallback);
        }
        finally {
            this.callbacksLock.unlock();
        }
        if (pair == null) {
            throw new IllegalArgumentException("Filter callback to be removed not found");
        }
        FilterHandleSetNode rootNode = this.eventTypeIndex.get(pair.getFirst().getEventType());
        IndexTreeBuilder treeBuilder = new IndexTreeBuilder();
        treeBuilder.remove(filterCallback, pair.getSecond(), rootNode);
        this.callbacksLock.lock();
        try {
            this.callbacks.remove(filterCallback);
        }
        finally {
            this.callbacksLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FilterSet take(Set<String> statementIds) {
        ArrayList<FilterSetEntry> list = new ArrayList<FilterSetEntry>();
        this.callbacksLock.lock();
        try {
            for (Map.Entry<FilterHandle, Pair<FilterValueSet, IndexTreePath>> entry : this.callbacks.entrySet()) {
                Pair<FilterValueSet, IndexTreePath> pair = entry.getValue();
                if (!statementIds.contains(entry.getKey().getStatementId())) continue;
                list.add(new FilterSetEntry(entry.getKey(), pair.getFirst()));
                FilterHandleSetNode rootNode = this.eventTypeIndex.get(pair.getFirst().getEventType());
                IndexTreeBuilder treeBuilder = new IndexTreeBuilder();
                treeBuilder.remove(entry.getKey(), pair.getSecond(), rootNode);
            }
            for (FilterSetEntry removed : list) {
                this.callbacks.remove(removed.getHandle());
            }
        }
        finally {
            this.callbacksLock.unlock();
        }
        return new FilterSet(list);
    }

    public void apply(FilterSet filterSet) {
        for (FilterSetEntry entry : filterSet.getFilters()) {
            this.add(entry.getFilterValueSet(), entry.getHandle());
        }
    }
}

