/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.variable.VariableService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExprNodeAdapter {
    private static final Log log = LogFactory.getLog(ExprNodeAdapter.class);
    private final ExprNode exprNode;
    private final EventBean[] prototype;
    private final VariableService variableService;
    private ThreadLocal<EventBean[]> arrayPerThread = new ThreadLocal<EventBean[]>(){

        @Override
        protected synchronized EventBean[] initialValue() {
            EventBean[] eventsPerStream = new EventBean[ExprNodeAdapter.this.prototype.length];
            System.arraycopy(ExprNodeAdapter.this.prototype, 0, eventsPerStream, 0, ExprNodeAdapter.this.prototype.length);
            return eventsPerStream;
        }
    };

    public ExprNodeAdapter(ExprNode exprNode, EventBean[] prototype, VariableService variableService) {
        this.exprNode = exprNode;
        this.variableService = variableService;
        this.prototype = prototype == null ? new EventBean[1] : prototype;
    }

    public boolean evaluate(EventBean event, ExprEvaluatorContext exprEvaluatorContext) {
        if (this.variableService != null) {
            this.variableService.setLocalVersion();
        }
        EventBean[] eventsPerStream = this.arrayPerThread.get();
        eventsPerStream[0] = event;
        try {
            Boolean result = (Boolean)this.exprNode.evaluate(eventsPerStream, true, exprEvaluatorContext);
            if (result == null) {
                return false;
            }
            return result;
        }
        catch (RuntimeException ex) {
            log.error("Error evaluating expression '" + this.exprNode.toExpressionString() + "': " + ex.getMessage(), ex);
            return false;
        }
    }
}

