/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.filter.DoubleRange;
import com.espertech.esper.filter.DoubleRangeComparator;
import com.espertech.esper.filter.EventEvaluator;
import com.espertech.esper.filter.FilterHandle;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterParamIndexPropBase;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterParamIndexNotRange
extends FilterParamIndexPropBase {
    private final TreeMap<DoubleRange, EventEvaluator> ranges;
    private final Set<EventEvaluator> evaluators;
    private final ReadWriteLock rangesRWLock;
    private double largestRangeValueDouble = Double.MIN_VALUE;
    private static final Log log = LogFactory.getLog(FilterParamIndexNotRange.class);

    public FilterParamIndexNotRange(String attributeName, FilterOperator filterOperator, EventType eventType) {
        super(attributeName, filterOperator, eventType);
        this.ranges = new TreeMap(new DoubleRangeComparator());
        this.evaluators = new HashSet<EventEvaluator>();
        this.rangesRWLock = new ReentrantReadWriteLock();
        if (!filterOperator.isInvertedRangeOperator()) {
            throw new IllegalArgumentException("Invalid filter operator " + (Object)((Object)filterOperator));
        }
    }

    @Override
    public final EventEvaluator get(Object expressionValue) {
        if (!(expressionValue instanceof DoubleRange)) {
            throw new IllegalArgumentException("Supplied expressionValue must be of type DoubleRange");
        }
        return this.ranges.get(expressionValue);
    }

    @Override
    public final void put(Object expressionValue, EventEvaluator matcher) {
        if (!(expressionValue instanceof DoubleRange)) {
            throw new IllegalArgumentException("Supplied expressionValue must be of type DoubleRange");
        }
        DoubleRange range = (DoubleRange)expressionValue;
        if (range.getMax() == null || range.getMin() == null) {
            return;
        }
        if (Math.abs(range.getMax() - range.getMin()) > this.largestRangeValueDouble) {
            this.largestRangeValueDouble = Math.abs(range.getMax() - range.getMin());
        }
        this.ranges.put(range, matcher);
        this.evaluators.add(matcher);
    }

    @Override
    public final boolean remove(Object filterConstant) {
        EventEvaluator eval = this.ranges.remove(filterConstant);
        if (eval == null) {
            return false;
        }
        this.evaluators.remove(eval);
        return true;
    }

    @Override
    public final int size() {
        return this.ranges.size();
    }

    @Override
    public final ReadWriteLock getReadWriteLock() {
        return this.rangesRWLock;
    }

    @Override
    public final void matchEvent(EventBean eventBean, Collection<FilterHandle> matches, ExprEvaluatorContext exprEvaluatorContext) {
        Object objAttributeValue = this.getGetter().get(eventBean);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".match Finding range matches, attribute=" + this.getPropertyName() + "  attrValue=" + objAttributeValue);
        }
        if (objAttributeValue == null) {
            return;
        }
        double attributeValue = ((Number)objAttributeValue).doubleValue();
        DoubleRange rangeStart = new DoubleRange(attributeValue - this.largestRangeValueDouble, attributeValue);
        DoubleRange rangeEnd = new DoubleRange(attributeValue, (Double)Double.MAX_VALUE);
        SortedMap<DoubleRange, EventEvaluator> subMap = this.ranges.subMap(rangeStart, rangeEnd);
        HashSet<EventEvaluator> matchingEvals = new HashSet<EventEvaluator>();
        if (this.getFilterOperator() == FilterOperator.NOT_RANGE_OPEN) {
            for (Map.Entry<DoubleRange, EventEvaluator> entry : subMap.entrySet()) {
                if (!(attributeValue > entry.getKey().getMin()) || !(attributeValue < entry.getKey().getMax())) continue;
                matchingEvals.add(entry.getValue());
            }
        } else if (this.getFilterOperator() == FilterOperator.NOT_RANGE_CLOSED) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (!(attributeValue >= ((DoubleRange)entry.getKey()).getMin()) || !(attributeValue <= ((DoubleRange)entry.getKey()).getMax())) continue;
                matchingEvals.add((EventEvaluator)entry.getValue());
            }
        } else if (this.getFilterOperator() == FilterOperator.NOT_RANGE_HALF_CLOSED) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (!(attributeValue > ((DoubleRange)entry.getKey()).getMin()) || !(attributeValue <= ((DoubleRange)entry.getKey()).getMax())) continue;
                matchingEvals.add((EventEvaluator)entry.getValue());
            }
        } else if (this.getFilterOperator() == FilterOperator.NOT_RANGE_HALF_OPEN) {
            for (Map.Entry entry : subMap.entrySet()) {
                if (!(attributeValue >= ((DoubleRange)entry.getKey()).getMin()) || !(attributeValue < ((DoubleRange)entry.getKey()).getMax())) continue;
                matchingEvals.add((EventEvaluator)entry.getValue());
            }
        } else {
            throw new IllegalStateException("Invalid filter operator " + (Object)((Object)this.getFilterOperator()));
        }
        for (EventEvaluator eventEvaluator : this.evaluators) {
            if (matchingEvals.contains(eventEvaluator)) continue;
            eventEvaluator.matchEvent(eventBean, matches, exprEvaluatorContext);
        }
    }
}

