/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventType;
import com.espertech.esper.epl.property.PropertyEvaluator;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.filter.FilterValueSet;
import com.espertech.esper.filter.FilterValueSetImpl;
import com.espertech.esper.filter.FilterValueSetParam;
import com.espertech.esper.filter.FilterValueSetParamImpl;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterSpecCompiled {
    private final EventType filterForEventType;
    private final String filterForEventTypeName;
    private final List<FilterSpecParam> parameters;
    private final PropertyEvaluator optionalPropertyEvaluator;

    public FilterSpecCompiled(EventType eventType, String eventTypeName, List<FilterSpecParam> parameters, PropertyEvaluator optionalPropertyEvaluator) {
        this.filterForEventType = eventType;
        this.filterForEventTypeName = eventTypeName;
        this.parameters = parameters;
        this.optionalPropertyEvaluator = optionalPropertyEvaluator;
    }

    public final EventType getFilterForEventType() {
        return this.filterForEventType;
    }

    public final List<FilterSpecParam> getParameters() {
        return this.parameters;
    }

    public String getFilterForEventTypeName() {
        return this.filterForEventTypeName;
    }

    public PropertyEvaluator getOptionalPropertyEvaluator() {
        return this.optionalPropertyEvaluator;
    }

    public EventType getResultEventType() {
        if (this.optionalPropertyEvaluator != null) {
            return this.optionalPropertyEvaluator.getFragmentEventType();
        }
        return this.filterForEventType;
    }

    public FilterValueSet getValueSet(MatchedEventMap matchedEvents) {
        LinkedList<FilterValueSetParam> valueList = new LinkedList<FilterValueSetParam>();
        for (FilterSpecParam specParam : this.parameters) {
            Object filterForValue = specParam.getFilterValue(matchedEvents);
            FilterValueSetParamImpl valueParam = new FilterValueSetParamImpl(specParam.getPropertyName(), specParam.getFilterOperator(), filterForValue);
            valueList.add(valueParam);
        }
        return new FilterValueSetImpl(this.filterForEventType, valueList);
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("FilterSpecCompiled type=" + this.filterForEventType);
        buffer.append(" parameters=" + Arrays.toString(this.parameters.toArray()));
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecCompiled)) {
            return false;
        }
        FilterSpecCompiled other = (FilterSpecCompiled)obj;
        if (!this.equalsTypeAndFilter(other)) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator == null) {
            return true;
        }
        if (this.optionalPropertyEvaluator != null && other.optionalPropertyEvaluator == null) {
            return false;
        }
        if (this.optionalPropertyEvaluator == null && other.optionalPropertyEvaluator != null) {
            return false;
        }
        return this.optionalPropertyEvaluator.compareTo(other.optionalPropertyEvaluator);
    }

    public boolean equalsTypeAndFilter(FilterSpecCompiled other) {
        if (this.filterForEventType != other.filterForEventType) {
            return false;
        }
        if (this.parameters.size() != other.parameters.size()) {
            return false;
        }
        Iterator<FilterSpecParam> iterOne = this.parameters.iterator();
        Iterator<FilterSpecParam> iterOther = other.parameters.iterator();
        while (iterOne.hasNext()) {
            if (iterOne.next().equals(iterOther.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = this.filterForEventType.hashCode();
        for (FilterSpecParam param : this.parameters) {
            hashCode = 31 * hashCode;
            hashCode ^= param.getPropertyName().hashCode();
            hashCode ^= 31 * param.getFilterHash();
        }
        return hashCode;
    }
}

