/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.util.SimpleNumberCoercer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FilterSpecParamEventPropIndexed
extends FilterSpecParam {
    private static final Log log = LogFactory.getLog(FilterSpecParamEventPropIndexed.class);
    private final String resultEventAsName;
    private final int resultEventIndex;
    private final String resultEventProperty;
    private final boolean isMustCoerce;
    private final SimpleNumberCoercer numberCoercer;
    private final Class coercionType;
    private static final long serialVersionUID = -1781904301744323795L;

    public FilterSpecParamEventPropIndexed(String propertyName, FilterOperator filterOperator, String resultEventAsName, int resultEventIndex, String resultEventProperty, boolean isMustCoerce, SimpleNumberCoercer numberCoercer, Class coercionType) throws IllegalArgumentException {
        super(propertyName, filterOperator);
        this.resultEventAsName = resultEventAsName;
        this.resultEventIndex = resultEventIndex;
        this.resultEventProperty = resultEventProperty;
        this.isMustCoerce = isMustCoerce;
        this.numberCoercer = numberCoercer;
        this.coercionType = coercionType;
        if (filterOperator.isRangeOperator()) {
            throw new IllegalArgumentException("Illegal filter operator " + (Object)((Object)filterOperator) + " supplied to " + "event property filter parameter");
        }
    }

    public boolean isMustCoerce() {
        return this.isMustCoerce;
    }

    public Class getCoercionType() {
        return this.coercionType;
    }

    public String getResultEventAsName() {
        return this.resultEventAsName;
    }

    public String getResultEventProperty() {
        return this.resultEventProperty;
    }

    public Object getFilterValue(MatchedEventMap matchedEvents) {
        EventBean[] events = (EventBean[])matchedEvents.getMatchingEventAsObject(this.resultEventAsName);
        Object value = null;
        if (events == null) {
            log.warn("Matching events for tag '" + this.resultEventAsName + "' returned a null result, using null value in filter criteria");
        } else if (this.resultEventIndex > events.length - 1) {
            log.warn("Matching events for tag '" + this.resultEventAsName + "' returned no result for index " + this.resultEventIndex + " at array length " + events.length + ", using null value in filter criteria");
        } else {
            value = events[this.resultEventIndex].get(this.resultEventProperty);
        }
        if (this.isMustCoerce) {
            value = this.numberCoercer.coerceBoxed((Number)value);
        }
        return value;
    }

    public int getResultEventIndex() {
        return this.resultEventIndex;
    }

    public int getFilterHash() {
        return this.resultEventProperty.hashCode();
    }

    public final String toString() {
        return super.toString() + " resultEventAsName=" + this.resultEventAsName + " resultEventProperty=" + this.resultEventProperty;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamEventPropIndexed)) {
            return false;
        }
        FilterSpecParamEventPropIndexed other = (FilterSpecParamEventPropIndexed)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.resultEventAsName.equals(other.resultEventAsName) && this.resultEventProperty.equals(other.resultEventProperty) && this.resultEventIndex == other.resultEventIndex;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.resultEventProperty.hashCode();
        return result;
    }
}

