/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.epl.expression.ExprNodeVariableVisitor;
import com.espertech.esper.epl.variable.VariableService;
import com.espertech.esper.event.EventAdapterService;
import com.espertech.esper.filter.ExprNodeAdapter;
import com.espertech.esper.filter.FilterOperator;
import com.espertech.esper.filter.FilterSpecParam;
import com.espertech.esper.pattern.MatchedEventMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FilterSpecParamExprNode
extends FilterSpecParam {
    private final ExprNode exprNode;
    private final LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes;
    private final LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes;
    private final EventAdapterService eventAdapterService;
    private final VariableService variableService;
    private final boolean hasVariable;
    private static final long serialVersionUID = 2298436088557677833L;

    public FilterSpecParamExprNode(String propertyName, FilterOperator filterOperator, ExprNode exprNode, LinkedHashMap<String, Pair<EventType, String>> taggedEventTypes, LinkedHashMap<String, Pair<EventType, String>> arrayEventTypes, VariableService variableService, EventAdapterService eventAdapterService) throws IllegalArgumentException {
        super(propertyName, filterOperator);
        if (filterOperator != FilterOperator.BOOLEAN_EXPRESSION) {
            throw new IllegalArgumentException("Invalid filter operator for filter expression node");
        }
        this.exprNode = exprNode;
        this.taggedEventTypes = taggedEventTypes;
        this.arrayEventTypes = arrayEventTypes;
        this.variableService = variableService;
        this.eventAdapterService = eventAdapterService;
        ExprNodeVariableVisitor visitor = new ExprNodeVariableVisitor();
        exprNode.accept(visitor);
        this.hasVariable = visitor.isHasVariables();
    }

    public ExprNode getExprNode() {
        return this.exprNode;
    }

    public LinkedHashMap<String, Pair<EventType, String>> getTaggedEventTypes() {
        return this.taggedEventTypes;
    }

    @Override
    public final Object getFilterValue(MatchedEventMap matchedEvents) {
        EventBean[] events = null;
        if (this.taggedEventTypes != null || this.arrayEventTypes != null) {
            int size = 0;
            size += this.taggedEventTypes != null ? this.taggedEventTypes.size() : 0;
            events = new EventBean[(size += this.arrayEventTypes != null ? this.arrayEventTypes.size() : 0) + 1];
            int count = 1;
            if (this.taggedEventTypes != null) {
                for (String string : this.taggedEventTypes.keySet()) {
                    events[count] = matchedEvents.getMatchingEvent(string);
                    ++count;
                }
            }
            if (this.arrayEventTypes != null) {
                for (Map.Entry entry : this.arrayEventTypes.entrySet()) {
                    EventType compositeEventType = (EventType)((Pair)entry.getValue()).getFirst();
                    events[count] = this.eventAdapterService.adaptorForTypedMap(matchedEvents.getMatchingEvents(), compositeEventType);
                    ++count;
                }
            }
        }
        if (this.hasVariable) {
            return new ExprNodeAdapter(this.exprNode, events, this.variableService);
        }
        return new ExprNodeAdapter(this.exprNode, events, null);
    }

    @Override
    public final String toString() {
        return super.toString() + "  exprNode=" + this.exprNode.toString();
    }

    @Override
    public int getFilterHash() {
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterSpecParamExprNode)) {
            return false;
        }
        FilterSpecParamExprNode other = (FilterSpecParamExprNode)obj;
        if (!super.equals(other)) {
            return false;
        }
        return this.exprNode == other.exprNode;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.exprNode.hashCode();
        return result;
    }
}

