/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.filter;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.filter.FilterSpecParamInValue;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.util.JavaClassHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InSetOfValuesEventPropIndexed
implements FilterSpecParamInValue {
    private static final Log log = LogFactory.getLog(InSetOfValuesEventPropIndexed.class);
    private final String resultEventAsName;
    private final int resultEventIndex;
    private final String resultEventProperty;
    private final boolean isMustCoerce;
    private final Class coercionType;
    private static final long serialVersionUID = -4424097388643812241L;

    public InSetOfValuesEventPropIndexed(String resultEventAsName, int resultEventindex, String resultEventProperty, boolean isMustCoerce, Class coercionType) {
        this.resultEventAsName = resultEventAsName;
        this.resultEventProperty = resultEventProperty;
        this.resultEventIndex = resultEventindex;
        this.coercionType = coercionType;
        this.isMustCoerce = isMustCoerce;
    }

    public final Object getFilterValue(MatchedEventMap matchedEvents) {
        EventBean[] events = (EventBean[])matchedEvents.getMatchingEventAsObject(this.resultEventAsName);
        Object value = null;
        if (events == null) {
            log.warn("Matching events for tag '" + this.resultEventAsName + "' returned a null result, using null value in filter criteria");
        } else if (this.resultEventIndex > events.length - 1) {
            log.warn("Matching events for tag '" + this.resultEventAsName + "' returned no result for index " + this.resultEventIndex + " at array length " + events.length + ", using null value in filter criteria");
        } else {
            value = events[this.resultEventIndex].get(this.resultEventProperty);
        }
        if (this.isMustCoerce) {
            value = JavaClassHelper.coerceBoxed((Number)value, this.coercionType);
        }
        return value;
    }

    public String getResultEventAsName() {
        return this.resultEventAsName;
    }

    public String getResultEventProperty() {
        return this.resultEventProperty;
    }

    public final String toString() {
        return "resultEventProp=" + this.resultEventAsName + '.' + this.resultEventProperty;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InSetOfValuesEventPropIndexed)) {
            return false;
        }
        InSetOfValuesEventPropIndexed other = (InSetOfValuesEventPropIndexed)obj;
        return other.resultEventAsName.equals(this.resultEventAsName) && other.resultEventProperty.equals(this.resultEventProperty);
    }

    public int hashCode() {
        return this.resultEventProperty.hashCode();
    }
}

