/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalAndNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalNotStateNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EvalAndStateNode
extends EvalStateNode
implements Evaluator {
    private final List<EvalStateNode> activeChildNodes;
    private Map<EvalStateNode, List<MatchedEventMap>> eventsPerChild;
    private static final Log log = LogFactory.getLog(EvalAndStateNode.class);

    public EvalAndStateNode(Evaluator parentNode, EvalAndNode evalAndNode, MatchedEventMap beginState, PatternContext context) {
        super(evalAndNode, parentNode, null);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".constructor");
        }
        this.activeChildNodes = new LinkedList<EvalStateNode>();
        this.eventsPerChild = new HashMap<EvalStateNode, List<MatchedEventMap>>();
        for (EvalNode node : evalAndNode.getChildNodes()) {
            EvalStateNode childState = node.newState(this, beginState, context, null);
            this.activeChildNodes.add(childState);
        }
    }

    @Override
    public final void start() {
        EvalStateNode[] activeChildNodesArray;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".start Starting and-expression all children, size=" + this.getFactoryNode().getChildNodes().size());
        }
        if (this.activeChildNodes.size() < 2) {
            throw new IllegalStateException("AND state node is inactive");
        }
        for (EvalStateNode child : activeChildNodesArray = this.activeChildNodes.toArray(new EvalStateNode[this.activeChildNodes.size()])) {
            child.start();
        }
    }

    @Override
    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        List<MatchedEventMap> eventList;
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateTrue fromNode=" + fromNode.hashCode());
        }
        if (isQuitted) {
            this.activeChildNodes.remove(fromNode);
        }
        if ((eventList = this.eventsPerChild.get(fromNode)) == null) {
            eventList = new LinkedList<MatchedEventMap>();
            this.eventsPerChild.put(fromNode, eventList);
        }
        eventList.add(matchEvent);
        if (this.eventsPerChild.size() < this.getFactoryNode().getChildNodes().size()) {
            return;
        }
        List<MatchedEventMap> result = EvalAndStateNode.generateMatchEvents(matchEvent, fromNode, this.eventsPerChild);
        boolean quitted = true;
        if (!this.activeChildNodes.isEmpty()) {
            for (EvalStateNode stateNode : this.activeChildNodes) {
                if (stateNode instanceof EvalNotStateNode) continue;
                quitted = false;
            }
        }
        if (quitted) {
            this.quit();
        }
        for (MatchedEventMap event : result) {
            this.getParentEvaluator().evaluateTrue(event, this, quitted);
        }
    }

    @Override
    public final void evaluateFalse(EvalStateNode fromNode) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateFalse Removing fromNode=" + fromNode.hashCode());
        }
        if (this.eventsPerChild != null) {
            this.eventsPerChild.remove(fromNode);
        }
        this.getParentEvaluator().evaluateFalse(this);
        this.quit();
    }

    protected static List<MatchedEventMap> generateMatchEvents(MatchedEventMap matchEvent, EvalStateNode fromNode, Map<EvalStateNode, List<MatchedEventMap>> eventsPerChild) {
        ArrayList<List<MatchedEventMap>> listArray = new ArrayList<List<MatchedEventMap>>();
        int index = 0;
        for (Map.Entry<EvalStateNode, List<MatchedEventMap>> entry : eventsPerChild.entrySet()) {
            if (fromNode == entry.getKey()) continue;
            listArray.add(index++, entry.getValue());
        }
        LinkedList<MatchedEventMap> results = new LinkedList<MatchedEventMap>();
        EvalAndStateNode.generateMatchEvents(listArray, 0, results, matchEvent);
        return results;
    }

    protected static void generateMatchEvents(ArrayList<List<MatchedEventMap>> eventList, int index, List<MatchedEventMap> result, MatchedEventMap matchEvent) {
        List<MatchedEventMap> events = eventList.get(index);
        for (MatchedEventMap event : events) {
            MatchedEventMap current = matchEvent.shallowCopy();
            current.merge(event);
            if (index + 1 == eventList.size()) {
                result.add(current);
                continue;
            }
            EvalAndStateNode.generateMatchEvents(eventList, index + 1, result, current);
        }
    }

    @Override
    public final void quit() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".quit Stopping all children");
        }
        for (EvalStateNode child : this.activeChildNodes) {
            child.quit();
        }
        this.activeChildNodes.clear();
        this.eventsPerChild = null;
    }

    @Override
    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode node : this.activeChildNodes) {
            node.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalAndStateNode nodes=" + this.activeChildNodes.size();
    }
}

