/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.epl.spec.FilterSpecRaw;
import com.espertech.esper.filter.FilterSpecCompiled;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.util.ExecutionPathDebugLog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalFilterNode
extends EvalNode {
    private static final long serialVersionUID = 0L;
    private final FilterSpecRaw rawFilterSpec;
    private final String eventAsName;
    private transient FilterSpecCompiled filterSpec;
    private static final Log log = LogFactory.getLog(EvalFilterNode.class);

    public EvalFilterNode(FilterSpecRaw filterSpecification, String eventAsName) {
        this.rawFilterSpec = filterSpecification;
        this.eventAsName = eventAsName;
    }

    public final EvalStateNode newState(Evaluator parentNode, MatchedEventMap beginState, PatternContext context, Object stateNodeId) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".newState");
        }
        if (!this.getChildNodes().isEmpty()) {
            throw new IllegalStateException("Expected number of child nodes incorrect, expected no child nodes, found " + this.getChildNodes().size());
        }
        return context.getPatternStateFactory().makeFilterStateNode(parentNode, this, beginState, stateNodeId);
    }

    public FilterSpecRaw getRawFilterSpec() {
        return this.rawFilterSpec;
    }

    public final FilterSpecCompiled getFilterSpec() {
        return this.filterSpec;
    }

    public void setFilterSpec(FilterSpecCompiled filterSpec) {
        this.filterSpec = filterSpec;
    }

    public final String getEventAsName() {
        return this.eventAsName;
    }

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("EvalFilterNode rawFilterSpec=" + this.rawFilterSpec);
        buffer.append(" filterSpec=" + this.filterSpec);
        buffer.append(" eventAsName=" + this.eventAsName);
        return buffer.toString();
    }
}

