/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalFollowedByNode;
import com.espertech.esper.pattern.EvalNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.EvalStateNodeVisitor;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.util.ExecutionPathDebugLog;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EvalFollowedByStateNode
extends EvalStateNode
implements Evaluator {
    private final HashMap<EvalStateNode, Integer> nodes;
    private final PatternContext context;
    private static final Log log = LogFactory.getLog(EvalFollowedByStateNode.class);

    public EvalFollowedByStateNode(Evaluator parentNode, EvalFollowedByNode evalFollowedByNode, MatchedEventMap beginState, PatternContext context) {
        super(evalFollowedByNode, parentNode, null);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".constructor");
        }
        this.nodes = new HashMap();
        this.context = context;
        EvalNode child = evalFollowedByNode.getChildNodes().get(0);
        EvalStateNode childState = child.newState(this, beginState, context, null);
        this.nodes.put(childState, 0);
    }

    public final void start() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".start Starting followed-by expression for the first child");
        }
        if (this.nodes.isEmpty()) {
            throw new IllegalStateException("Followed by state node is inactive");
        }
        for (EvalStateNode child : this.nodes.keySet()) {
            child.start();
        }
    }

    public final void evaluateTrue(MatchedEventMap matchEvent, EvalStateNode fromNode, boolean isQuitted) {
        Integer index = this.nodes.get(fromNode);
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateTrue index=" + index + "  fromNode=" + fromNode.hashCode() + "  isQuitted=" + isQuitted);
        }
        if (isQuitted) {
            this.nodes.remove(fromNode);
        }
        if (index == null) {
            return;
        }
        int numChildNodes = this.getFactoryNode().getChildNodes().size();
        if (index == numChildNodes - 1) {
            boolean isFollowedByQuitted = false;
            if (this.nodes.isEmpty()) {
                isFollowedByQuitted = true;
            }
            this.getParentEvaluator().evaluateTrue(matchEvent, this, isFollowedByQuitted);
        } else {
            EvalNode child = this.getFactoryNode().getChildNodes().get(index + 1);
            EvalStateNode childState = child.newState(this, matchEvent, this.context, null);
            this.nodes.put(childState, index + 1);
            childState.start();
        }
    }

    public final void evaluateFalse(EvalStateNode fromNode) {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".evaluateFalse Child node has indicated permanently false");
        }
        fromNode.quit();
        this.nodes.remove(fromNode);
        if (this.nodes.isEmpty()) {
            this.getParentEvaluator().evaluateFalse(this);
            this.quit();
        }
    }

    public final void quit() {
        if (ExecutionPathDebugLog.isDebugEnabled && log.isDebugEnabled()) {
            log.debug(".quit Stopping followed-by all children");
        }
        for (EvalStateNode child : this.nodes.keySet()) {
            child.quit();
        }
    }

    public final Object accept(EvalStateNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public final Object childrenAccept(EvalStateNodeVisitor visitor, Object data) {
        for (EvalStateNode node : this.nodes.keySet()) {
            node.accept(visitor, data);
        }
        return data;
    }

    public final String toString() {
        return "EvalFollowedByStateNode nodes=" + this.nodes.size();
    }
}

