/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.pattern.EvalEveryDistinctNode;
import com.espertech.esper.pattern.EvalFilterNode;
import com.espertech.esper.pattern.EvalGuardNode;
import com.espertech.esper.pattern.EvalMatchUntilNode;
import com.espertech.esper.pattern.EvalNodeAnalysisResult;
import com.espertech.esper.pattern.EvalNodeNumber;
import com.espertech.esper.pattern.EvalObserverNode;
import com.espertech.esper.pattern.EvalStateNode;
import com.espertech.esper.pattern.Evaluator;
import com.espertech.esper.pattern.MatchedEventMap;
import com.espertech.esper.pattern.PatternContext;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EvalNode
implements MetaDefItem,
Serializable {
    private static final Log log = LogFactory.getLog(EvalNode.class);
    private static final long serialVersionUID = 0L;
    private final List<EvalNode> childNodes = new ArrayList<EvalNode>();
    private EvalNodeNumber nodeNumber;

    public abstract EvalStateNode newState(Evaluator var1, MatchedEventMap var2, PatternContext var3, Object var4);

    EvalNode() {
    }

    public EvalNodeNumber getNodeNumber() {
        return this.nodeNumber;
    }

    public void setNodeNumber(EvalNodeNumber nodeNumber) {
        this.nodeNumber = nodeNumber;
    }

    public final void addChildNode(EvalNode childNode) {
        this.childNodes.add(childNode);
    }

    public final List<EvalNode> getChildNodes() {
        return this.childNodes;
    }

    public final void dumpDebug(String prefix) {
        if (log.isDebugEnabled()) {
            log.debug(".dumpDebug " + prefix + this.toString());
        }
        for (EvalNode node : this.childNodes) {
            node.dumpDebug(prefix + "  ");
        }
    }

    public static EvalNodeAnalysisResult recursiveAnalyzeChildNodes(EvalNode currentNode) {
        EvalNodeAnalysisResult evalNodeAnalysisResult = new EvalNodeAnalysisResult();
        EvalNode.recursiveAnalyzeChildNodes(evalNodeAnalysisResult, currentNode);
        return evalNodeAnalysisResult;
    }

    private static void recursiveAnalyzeChildNodes(EvalNodeAnalysisResult evalNodeAnalysisResult, EvalNode currentNode) {
        if (currentNode instanceof EvalFilterNode || currentNode instanceof EvalGuardNode || currentNode instanceof EvalObserverNode || currentNode instanceof EvalMatchUntilNode || currentNode instanceof EvalEveryDistinctNode) {
            evalNodeAnalysisResult.addNode(currentNode);
        }
        for (EvalNode node : currentNode.getChildNodes()) {
            EvalNode.recursiveAnalyzeChildNodes(evalNodeAnalysisResult, node);
        }
    }

    public static Set<EvalNode> recursiveGetChildNodes(EvalNode currentNode) {
        HashSet<EvalNode> result = new HashSet<EvalNode>();
        EvalNode.recursiveGetChildNodes(result, currentNode);
        return result;
    }

    private static void recursiveGetChildNodes(Set<EvalNode> set, EvalNode currentNode) {
        for (EvalNode node : currentNode.getChildNodes()) {
            set.add(node);
            EvalNode.recursiveGetChildNodes(set, node);
        }
    }
}

