/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.pattern;

import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.util.Arrays;

public class EvalNodeNumber
implements MetaDefItem,
Serializable {
    private short[] number;
    private static final long serialVersionUID = -2623267386821650096L;

    public EvalNodeNumber() {
        this.number = new short[0];
    }

    private EvalNodeNumber(short[] number) {
        this.number = number;
    }

    public short getChildNumber() {
        return this.number[this.number.length - 1];
    }

    public boolean isRoot() {
        return this.number.length == 0;
    }

    public EvalNodeNumber getParentNumber() {
        if (this.isRoot()) {
            return null;
        }
        short[] num = new short[this.number.length - 1];
        System.arraycopy(this.number, 0, num, 0, this.number.length - 1);
        return new EvalNodeNumber(num);
    }

    public EvalNodeNumber newChildNumber() {
        short[] num = new short[this.number.length + 1];
        System.arraycopy(this.number, 0, num, 0, this.number.length);
        num[this.number.length] = 0;
        return new EvalNodeNumber(num);
    }

    public EvalNodeNumber newSiblingNumber() {
        int size = this.number.length;
        if (size == 0) {
            throw new IllegalStateException("Cannot create a new node number for root node");
        }
        short[] num = new short[size];
        System.arraycopy(this.number, 0, num, 0, size);
        short next = this.number[size - 1];
        num[size - 1] = next = (short)(next + 1);
        return new EvalNodeNumber(num);
    }

    public String toString() {
        return Arrays.toString(this.number);
    }

    public short[] getNumber() {
        return this.number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EvalNodeNumber that = (EvalNodeNumber)o;
        return Arrays.equals(this.number, that.number);
    }

    public int hashCode() {
        return Arrays.hashCode(this.number);
    }
}

