/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.rowregex;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.collection.RollingEventBuffer;
import com.espertech.esper.rowregex.RegexPartitionStateRandomAccess;
import com.espertech.esper.rowregex.RegexPartitionStateRandomAccessGetter;
import java.util.HashMap;
import java.util.Map;

public class RegexPartitionStateRandomAccessImpl
implements RegexPartitionStateRandomAccess {
    private final RegexPartitionStateRandomAccessGetter getter;
    private final Map<EventBean, EventBean[]> priorEventMap;
    private final RollingEventBuffer newEvents;
    private EventBean[] lastNew;

    public RegexPartitionStateRandomAccessImpl(RegexPartitionStateRandomAccessGetter getter) {
        this.getter = getter;
        this.newEvents = new RollingEventBuffer(getter.getMaxPriorIndex() + 1);
        this.priorEventMap = !getter.isUnbound() ? new HashMap<EventBean, EventBean[]>() : null;
    }

    public void newEventPrepare(EventBean newEvent) {
        this.newEvents.add(newEvent);
        EventBean[] priorEvents = new EventBean[this.getter.getIndexesRequestedLen()];
        for (int j = 0; j < priorEvents.length; ++j) {
            int priorIndex = this.getter.getIndexesRequested()[j];
            priorEvents[j] = this.newEvents.get(priorIndex);
        }
        if (this.priorEventMap != null) {
            this.priorEventMap.put(newEvent, priorEvents);
        }
        this.lastNew = priorEvents;
        this.getter.setRandomAccess(this);
    }

    public void existingEventPrepare(EventBean newEvent) {
        if (this.priorEventMap != null) {
            this.lastNew = this.priorEventMap.get(newEvent);
        }
        this.getter.setRandomAccess(this);
    }

    public EventBean getPreviousEvent(int assignedRelativeIndex) {
        if (this.lastNew == null) {
            return null;
        }
        return this.lastNew[assignedRelativeIndex];
    }

    public void remove(EventBean[] oldEvents) {
        if (oldEvents == null) {
            return;
        }
        for (int i = 0; i < oldEvents.length; ++i) {
            this.remove(oldEvents[i]);
        }
    }

    public void remove(EventBean oldEvent) {
        if (this.priorEventMap != null) {
            this.priorEventMap.remove(oldEvent);
        }
    }

    public boolean isEmpty() {
        if (this.priorEventMap != null) {
            this.priorEventMap.isEmpty();
        }
        return true;
    }
}

