/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.schedule;

import com.espertech.esper.schedule.ScheduleComputeHelper;
import com.espertech.esper.schedule.ScheduleHandle;
import com.espertech.esper.schedule.ScheduleHandleExistsException;
import com.espertech.esper.schedule.ScheduleServiceException;
import com.espertech.esper.schedule.ScheduleSet;
import com.espertech.esper.schedule.ScheduleSetEntry;
import com.espertech.esper.schedule.ScheduleSlot;
import com.espertech.esper.schedule.ScheduleSpec;
import com.espertech.esper.schedule.SchedulingServiceSPI;
import com.espertech.esper.timer.TimeSourceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SchedulingServiceImpl
implements SchedulingServiceSPI {
    private final SortedMap<Long, SortedMap<ScheduleSlot, ScheduleHandle>> timeHandleMap = new TreeMap<Long, SortedMap<ScheduleSlot, ScheduleHandle>>();
    private final Map<ScheduleHandle, SortedMap<ScheduleSlot, ScheduleHandle>> handleSetMap = new HashMap<ScheduleHandle, SortedMap<ScheduleSlot, ScheduleHandle>>();
    private volatile long currentTime;
    private static final Log log = LogFactory.getLog(SchedulingServiceImpl.class);

    public SchedulingServiceImpl(TimeSourceService timeSourceService) {
        this.currentTime = timeSourceService.getTimeMillis() - 1L;
    }

    @Override
    public void destroy() {
        log.debug("Destroying scheduling service");
        this.handleSetMap.clear();
        this.timeHandleMap.clear();
    }

    @Override
    public long getTime() {
        return this.currentTime;
    }

    @Override
    public final synchronized void setTime(long currentTime) {
        this.currentTime = currentTime;
    }

    @Override
    public final synchronized void add(long afterMSec, ScheduleHandle handle, ScheduleSlot slot) throws ScheduleServiceException {
        if (this.handleSetMap.containsKey(handle)) {
            String message = "Handle already in collection";
            log.fatal(".add " + message);
            throw new ScheduleHandleExistsException(message);
        }
        long triggerOnTime = this.currentTime + afterMSec;
        this.addTrigger(slot, handle, triggerOnTime);
    }

    @Override
    public final synchronized void add(ScheduleSpec spec, ScheduleHandle handle, ScheduleSlot slot) {
        if (this.handleSetMap.containsKey(handle)) {
            String message = "Handle already in collection";
            log.fatal(".add " + message);
            throw new ScheduleHandleExistsException(message);
        }
        long nextScheduledTime = ScheduleComputeHelper.computeNextOccurance(spec, this.currentTime);
        if (nextScheduledTime <= this.currentTime) {
            String message = "Schedule computation returned invalid time, operation not completed";
            log.fatal(".add " + message + "  nextScheduledTime=" + nextScheduledTime + "  currentTime=" + this.currentTime);
            assert (false);
            return;
        }
        this.addTrigger(slot, handle, nextScheduledTime);
    }

    @Override
    public final synchronized void remove(ScheduleHandle handle, ScheduleSlot slot) {
        SortedMap<ScheduleSlot, ScheduleHandle> handleSet = this.handleSetMap.get(handle);
        if (handleSet == null) {
            return;
        }
        handleSet.remove(slot);
        this.handleSetMap.remove(handle);
    }

    @Override
    public final synchronized void evaluate(Collection<ScheduleHandle> handles) {
        SortedMap<Long, SortedMap<ScheduleSlot, ScheduleHandle>> headMap = this.timeHandleMap.headMap(this.currentTime + 1L);
        LinkedList<Long> removeKeys = new LinkedList<Long>();
        for (Map.Entry<Long, SortedMap<ScheduleSlot, ScheduleHandle>> entry : headMap.entrySet()) {
            Long key = entry.getKey();
            SortedMap<ScheduleSlot, ScheduleHandle> value = entry.getValue();
            removeKeys.add(key);
            for (ScheduleHandle handle : value.values()) {
                handles.add(handle);
            }
        }
        for (Map.Entry<Long, SortedMap<ScheduleSlot, ScheduleHandle>> entry : headMap.entrySet()) {
            for (ScheduleHandle handle : entry.getValue().values()) {
                this.handleSetMap.remove(handle);
            }
        }
        for (Long key : removeKeys) {
            this.timeHandleMap.remove(key);
        }
    }

    @Override
    public ScheduleSet take(Set<String> statementIds) {
        ArrayList<ScheduleSetEntry> list = new ArrayList<ScheduleSetEntry>();
        long currentTime = this.getTime();
        for (Map.Entry<Long, SortedMap<ScheduleSlot, ScheduleHandle>> schedule : this.timeHandleMap.entrySet()) {
            for (Map.Entry<ScheduleSlot, ScheduleHandle> entry : schedule.getValue().entrySet()) {
                if (!statementIds.contains(entry.getValue().getStatementId())) continue;
                long relative = schedule.getKey() - currentTime;
                list.add(new ScheduleSetEntry(relative, entry.getKey(), entry.getValue()));
            }
        }
        for (ScheduleSetEntry entry : list) {
            this.remove(entry.getHandle(), entry.getSlot());
        }
        return new ScheduleSet(list);
    }

    @Override
    public void apply(ScheduleSet scheduleSet) {
        for (ScheduleSetEntry entry : scheduleSet.getList()) {
            this.add(entry.getTime(), entry.getHandle(), entry.getSlot());
        }
    }

    private void addTrigger(ScheduleSlot slot, ScheduleHandle handle, long triggerTime) {
        TreeMap<ScheduleSlot, ScheduleHandle> handleSet = (TreeMap<ScheduleSlot, ScheduleHandle>)this.timeHandleMap.get(triggerTime);
        if (handleSet == null) {
            handleSet = new TreeMap<ScheduleSlot, ScheduleHandle>();
            this.timeHandleMap.put(triggerTime, handleSet);
        }
        handleSet.put(slot, handle);
        this.handleSetMap.put(handle, handleSet);
    }

    @Override
    public int getTimeHandleCount() {
        return this.timeHandleMap.size();
    }

    @Override
    public Long getFurthestTimeHandle() {
        if (!this.timeHandleMap.isEmpty()) {
            return this.timeHandleMap.lastKey();
        }
        return null;
    }

    @Override
    public int getScheduleHandleCount() {
        return this.handleSetMap.size();
    }

    @Override
    public boolean isScheduled(ScheduleHandle handle) {
        return this.handleSetMap.containsKey(handle);
    }
}

