/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.type;

import com.espertech.esper.collection.MultiKey;
import com.espertech.esper.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.util.SimpleNumberBigIntegerCoercer;
import com.espertech.esper.util.SimpleNumberCoercerFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MathArithTypeEnum {
    ADD("+"),
    SUBTRACT("-"),
    DIVIDE("/"),
    MULTIPLY("*"),
    MODULO("%");

    private static Map<MultiKey<Object>, Computer> computers;
    private String expressionText;

    private MathArithTypeEnum(String expressionText) {
        this.expressionText = expressionText;
    }

    public Computer getComputer(Class coercedType, Class typeOne, Class typeTwo, boolean isIntegerDivision, boolean isDivisionByZeroReturnsNull) {
        if (coercedType != Double.class && coercedType != Float.class && coercedType != Long.class && coercedType != Integer.class && coercedType != BigDecimal.class && coercedType != BigInteger.class) {
            throw new IllegalArgumentException("Expected base numeric type for computation result but got type " + coercedType);
        }
        if (coercedType == BigDecimal.class) {
            return this.makeBigDecimalComputer(typeOne, typeTwo, isDivisionByZeroReturnsNull);
        }
        if (coercedType == BigInteger.class) {
            return this.makeBigIntegerComputer(typeOne, typeTwo);
        }
        if (this != DIVIDE) {
            MultiKey<Object> key = new MultiKey<Object>(new Object[]{coercedType, this});
            Computer computer = computers.get(key);
            if (computer == null) {
                throw new IllegalArgumentException("Could not determine process or type " + (Object)((Object)this) + " type " + coercedType);
            }
            return computer;
        }
        if (!isIntegerDivision) {
            return new DivideDouble(isDivisionByZeroReturnsNull);
        }
        if (coercedType == Double.class) {
            return new DivideDouble(isDivisionByZeroReturnsNull);
        }
        if (coercedType == Float.class) {
            return new DivideFloat();
        }
        if (coercedType == Long.class) {
            return new DivideLong();
        }
        if (coercedType == Integer.class) {
            return new DivideInt();
        }
        if (coercedType == BigDecimal.class) {
            return new DivideBigDec(isDivisionByZeroReturnsNull);
        }
        if (coercedType == BigInteger.class) {
            return new DivideBigInt();
        }
        throw new IllegalArgumentException("Could not determine process or type " + (Object)((Object)this) + " type " + coercedType);
    }

    private Computer makeBigDecimalComputer(Class typeOne, Class typeTwo, boolean divisionByZeroReturnsNull) {
        if (typeOne == BigDecimal.class && typeTwo == BigDecimal.class) {
            if (this == DIVIDE) {
                return new DivideBigDec(divisionByZeroReturnsNull);
            }
            return computers.get(new MultiKey<Object>(new Object[]{BigDecimal.class, this}));
        }
        SimpleNumberBigDecimalCoercer convertorOne = SimpleNumberCoercerFactory.getCoercerBigDecimal(typeOne);
        SimpleNumberBigDecimalCoercer convertorTwo = SimpleNumberCoercerFactory.getCoercerBigDecimal(typeTwo);
        if (this == ADD) {
            return new AddBigDecConvComputer(convertorOne, convertorTwo);
        }
        if (this == SUBTRACT) {
            return new SubtractBigDecConvComputer(convertorOne, convertorTwo);
        }
        if (this == MULTIPLY) {
            return new MultiplyBigDecConvComputer(convertorOne, convertorTwo);
        }
        if (this == DIVIDE) {
            return new DivideBigDecConvComputer(convertorOne, convertorTwo, divisionByZeroReturnsNull);
        }
        return new ModuloDouble();
    }

    private Computer makeBigIntegerComputer(Class typeOne, Class typeTwo) {
        if (typeOne == BigDecimal.class && typeTwo == BigDecimal.class) {
            return computers.get(new MultiKey<Object>(new Object[]{BigDecimal.class, this}));
        }
        SimpleNumberBigIntegerCoercer convertorOne = SimpleNumberCoercerFactory.getCoercerBigInteger(typeOne);
        SimpleNumberBigIntegerCoercer convertorTwo = SimpleNumberCoercerFactory.getCoercerBigInteger(typeTwo);
        if (this == ADD) {
            return new AddBigIntConvComputer(convertorOne, convertorTwo);
        }
        if (this == SUBTRACT) {
            return new SubtractBigIntConvComputer(convertorOne, convertorTwo);
        }
        if (this == MULTIPLY) {
            return new MultiplyBigIntConvComputer(convertorOne, convertorTwo);
        }
        if (this == DIVIDE) {
            return new DivideBigIntConvComputer(convertorOne, convertorTwo);
        }
        return new ModuloLong();
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    public static MathArithTypeEnum parseOperator(String operator) {
        for (int i = 0; i < MathArithTypeEnum.values().length; ++i) {
            MathArithTypeEnum val = MathArithTypeEnum.values()[i];
            if (!val.getExpressionText().equals(operator)) continue;
            return MathArithTypeEnum.values()[i];
        }
        throw new IllegalArgumentException("Unknown operator '" + operator + "'");
    }

    static {
        computers = new HashMap<MultiKey<Object>, Computer>();
        computers.put(new MultiKey<Object>(new Object[]{Double.class, ADD}), new AddDouble());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, ADD}), new AddFloat());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, ADD}), new AddLong());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, ADD}), new AddInt());
        computers.put(new MultiKey<Object>(new Object[]{BigDecimal.class, ADD}), new AddBigDec());
        computers.put(new MultiKey<Object>(new Object[]{BigInteger.class, ADD}), new AddBigInt());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, SUBTRACT}), new SubtractDouble());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, SUBTRACT}), new SubtractFloat());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, SUBTRACT}), new SubtractLong());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, SUBTRACT}), new SubtractInt());
        computers.put(new MultiKey<Object>(new Object[]{BigDecimal.class, SUBTRACT}), new SubtractBigDec());
        computers.put(new MultiKey<Object>(new Object[]{BigInteger.class, SUBTRACT}), new SubtractBigInt());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, MULTIPLY}), new MultiplyDouble());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, MULTIPLY}), new MultiplyFloat());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, MULTIPLY}), new MultiplyLong());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, MULTIPLY}), new MultiplyInt());
        computers.put(new MultiKey<Object>(new Object[]{BigDecimal.class, MULTIPLY}), new MultiplyBigDec());
        computers.put(new MultiKey<Object>(new Object[]{BigInteger.class, MULTIPLY}), new MultiplyBigInt());
        computers.put(new MultiKey<Object>(new Object[]{Double.class, MODULO}), new ModuloDouble());
        computers.put(new MultiKey<Object>(new Object[]{Float.class, MODULO}), new ModuloFloat());
        computers.put(new MultiKey<Object>(new Object[]{Long.class, MODULO}), new ModuloLong());
        computers.put(new MultiKey<Object>(new Object[]{Integer.class, MODULO}), new ModuloInt());
        computers.put(new MultiKey<Object>(new Object[]{BigDecimal.class, MODULO}), new ModuloDouble());
        computers.put(new MultiKey<Object>(new Object[]{BigInteger.class, MODULO}), new ModuloLong());
    }

    public static class DivideBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        public DivideBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        public Number compute(Number d1, Number d2) {
            BigInteger s1 = this.convOne.coerceBoxedBigInt(d1);
            BigInteger s2 = this.convTwo.coerceBoxedBigInt(d2);
            if (s2.doubleValue() == 0.0) {
                return null;
            }
            return s1.divide(s2);
        }
    }

    public static class MultiplyBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        public MultiplyBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        public Number compute(Number d1, Number d2) {
            BigInteger s1 = this.convOne.coerceBoxedBigInt(d1);
            BigInteger s2 = this.convTwo.coerceBoxedBigInt(d2);
            return s1.multiply(s2);
        }
    }

    public static class SubtractBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        public SubtractBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        public Number compute(Number d1, Number d2) {
            BigInteger s1 = this.convOne.coerceBoxedBigInt(d1);
            BigInteger s2 = this.convTwo.coerceBoxedBigInt(d2);
            return s1.subtract(s2);
        }
    }

    public static class AddBigIntConvComputer
    implements Computer {
        private final SimpleNumberBigIntegerCoercer convOne;
        private final SimpleNumberBigIntegerCoercer convTwo;

        public AddBigIntConvComputer(SimpleNumberBigIntegerCoercer convOne, SimpleNumberBigIntegerCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        public Number compute(Number d1, Number d2) {
            BigInteger s1 = this.convOne.coerceBoxedBigInt(d1);
            BigInteger s2 = this.convTwo.coerceBoxedBigInt(d2);
            return s1.add(s2);
        }
    }

    public static class DivideBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;
        private final boolean divisionByZeroReturnsNull;

        public DivideBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo, boolean divisionByZeroReturnsNull) {
            this.convOne = convOne;
            this.convTwo = convTwo;
            this.divisionByZeroReturnsNull = divisionByZeroReturnsNull;
        }

        public Number compute(Number d1, Number d2) {
            BigDecimal s1 = this.convOne.coerceBoxedBigDec(d1);
            BigDecimal s2 = this.convTwo.coerceBoxedBigDec(d2);
            if (s2.doubleValue() == 0.0) {
                if (this.divisionByZeroReturnsNull) {
                    return null;
                }
                double result = s1.doubleValue() / 0.0;
                return new BigDecimal(result);
            }
            return s1.divide(s2);
        }
    }

    public static class MultiplyBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        public MultiplyBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        public Number compute(Number d1, Number d2) {
            BigDecimal s1 = this.convOne.coerceBoxedBigDec(d1);
            BigDecimal s2 = this.convTwo.coerceBoxedBigDec(d2);
            return s1.multiply(s2);
        }
    }

    public static class SubtractBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        public SubtractBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        public Number compute(Number d1, Number d2) {
            BigDecimal s1 = this.convOne.coerceBoxedBigDec(d1);
            BigDecimal s2 = this.convTwo.coerceBoxedBigDec(d2);
            return s1.subtract(s2);
        }
    }

    public static class AddBigDecConvComputer
    implements Computer {
        private final SimpleNumberBigDecimalCoercer convOne;
        private final SimpleNumberBigDecimalCoercer convTwo;

        public AddBigDecConvComputer(SimpleNumberBigDecimalCoercer convOne, SimpleNumberBigDecimalCoercer convTwo) {
            this.convOne = convOne;
            this.convTwo = convTwo;
        }

        public Number compute(Number d1, Number d2) {
            BigDecimal s1 = this.convOne.coerceBoxedBigDec(d1);
            BigDecimal s2 = this.convTwo.coerceBoxedBigDec(d2);
            return s1.add(s2);
        }
    }

    public static class ModuloInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.intValue() % d2.intValue();
        }
    }

    public static class ModuloLong
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.longValue() % d2.longValue();
        }
    }

    public static class ModuloFloat
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() % d2.floatValue());
        }
    }

    public static class ModuloDouble
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() % d2.doubleValue();
        }
    }

    public static class MultiplyBigDec
    implements Computer {
        public Number compute(Number d1, Number d2) {
            BigDecimal b1 = (BigDecimal)d1;
            BigDecimal b2 = (BigDecimal)d2;
            return b1.multiply(b2);
        }
    }

    public static class MultiplyBigInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            BigInteger b1 = (BigInteger)d1;
            BigInteger b2 = (BigInteger)d2;
            return b1.multiply(b2);
        }
    }

    public static class MultiplyInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.intValue() * d2.intValue();
        }
    }

    public static class MultiplyLong
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.longValue() * d2.longValue();
        }
    }

    public static class MultiplyFloat
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() * d2.floatValue());
        }
    }

    public static class MultiplyDouble
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() * d2.doubleValue();
        }
    }

    public static class DivideBigDec
    implements Computer {
        private final boolean divisionByZeroReturnsNull;

        public DivideBigDec(boolean divisionByZeroReturnsNull) {
            this.divisionByZeroReturnsNull = divisionByZeroReturnsNull;
        }

        public Number compute(Number d1, Number d2) {
            BigDecimal b1 = (BigDecimal)d1;
            BigDecimal b2 = (BigDecimal)d2;
            if (b2.doubleValue() == 0.0) {
                if (this.divisionByZeroReturnsNull) {
                    return null;
                }
                double result = b1.doubleValue() / 0.0;
                return new BigDecimal(result);
            }
            return b1.divide(b2);
        }
    }

    public static class DivideBigInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            BigInteger b1 = (BigInteger)d1;
            BigInteger b2 = (BigInteger)d2;
            if (b2.doubleValue() == 0.0) {
                return null;
            }
            return b1.divide(b2);
        }
    }

    public static class DivideInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            int d2Int = d2.intValue();
            if (d2Int == 0) {
                return null;
            }
            return d1.intValue() / d2Int;
        }
    }

    public static class DivideLong
    implements Computer {
        public Number compute(Number d1, Number d2) {
            long d2Long = d2.longValue();
            if (d2Long == 0L) {
                return null;
            }
            return d1.longValue() / d2Long;
        }
    }

    public static class DivideFloat
    implements Computer {
        public Number compute(Number d1, Number d2) {
            float d2Float = d2.floatValue();
            if (d2Float == 0.0f) {
                return null;
            }
            return Float.valueOf(d1.floatValue() / d2Float);
        }
    }

    public static class DivideDouble
    implements Computer {
        private final boolean divisionByZeroReturnsNull;

        public DivideDouble(boolean divisionByZeroReturnsNull) {
            this.divisionByZeroReturnsNull = divisionByZeroReturnsNull;
        }

        public Number compute(Number d1, Number d2) {
            double d2Double = d2.doubleValue();
            if (this.divisionByZeroReturnsNull && d2Double == 0.0) {
                return null;
            }
            return d1.doubleValue() / d2Double;
        }
    }

    public static class SubtractBigDec
    implements Computer {
        public Number compute(Number d1, Number d2) {
            BigDecimal b1 = (BigDecimal)d1;
            BigDecimal b2 = (BigDecimal)d2;
            return b1.subtract(b2);
        }
    }

    public static class SubtractBigInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            BigInteger b1 = (BigInteger)d1;
            BigInteger b2 = (BigInteger)d2;
            return b1.subtract(b2);
        }
    }

    public static class SubtractInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.intValue() - d2.intValue();
        }
    }

    public static class SubtractLong
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.longValue() - d2.longValue();
        }
    }

    public static class SubtractFloat
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() - d2.floatValue());
        }
    }

    public static class SubtractDouble
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() - d2.doubleValue();
        }
    }

    public static class AddBigDec
    implements Computer {
        public Number compute(Number d1, Number d2) {
            BigDecimal b1 = (BigDecimal)d1;
            BigDecimal b2 = (BigDecimal)d2;
            return b1.add(b2);
        }
    }

    public static class AddBigInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            BigInteger b1 = (BigInteger)d1;
            BigInteger b2 = (BigInteger)d2;
            return b1.add(b2);
        }
    }

    public static class AddInt
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.intValue() + d2.intValue();
        }
    }

    public static class AddLong
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.longValue() + d2.longValue();
        }
    }

    public static class AddFloat
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return Float.valueOf(d1.floatValue() + d2.floatValue());
        }
    }

    public static class AddDouble
    implements Computer {
        public Number compute(Number d1, Number d2) {
            return d1.doubleValue() + d2.doubleValue();
        }
    }

    public static interface Computer {
        public Number compute(Number var1, Number var2);
    }
}

