/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.type;

import com.espertech.esper.client.EventBean;
import com.espertech.esper.epl.expression.ExprEvaluatorContext;
import com.espertech.esper.epl.expression.ExprNode;
import com.espertech.esper.util.SimpleNumberBigDecimalCoercer;
import com.espertech.esper.util.SimpleNumberBigIntegerCoercer;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MinMaxTypeEnum {
    MAX("max"),
    MIN("min");

    private String expressionText;

    private MinMaxTypeEnum(String expressionText) {
        this.expressionText = expressionText;
    }

    public String getExpressionText() {
        return this.expressionText;
    }

    public static class ComputerBigDecCoerce
    implements Computer {
        private ExprNode[] childNodes;
        private SimpleNumberBigDecimalCoercer[] convertors;
        private boolean isMax;

        public ComputerBigDecCoerce(ExprNode[] childNodes, SimpleNumberBigDecimalCoercer[] convertors, boolean isMax) {
            this.childNodes = childNodes;
            this.convertors = convertors;
            this.isMax = isMax;
        }

        public Number execute(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Number valueChildOne = (Number)this.childNodes[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            Number valueChildTwo = (Number)this.childNodes[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (valueChildOne == null || valueChildTwo == null) {
                return null;
            }
            BigDecimal bigDecOne = this.convertors[0].coerceBoxedBigDec(valueChildOne);
            BigDecimal bigDecTwo = this.convertors[1].coerceBoxedBigDec(valueChildTwo);
            BigDecimal result = this.isMax && bigDecOne.compareTo(bigDecTwo) > 0 || !this.isMax && bigDecOne.compareTo(bigDecTwo) < 0 ? bigDecOne : bigDecTwo;
            for (int i = 2; i < this.childNodes.length; ++i) {
                Number valueChild = (Number)this.childNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueChild == null) {
                    return null;
                }
                BigDecimal bigDec = this.convertors[i].coerceBoxedBigDec(valueChild);
                if ((!this.isMax || result.compareTo(bigDec) >= 0) && (this.isMax || result.compareTo(bigDec) <= 0)) continue;
                result = bigDec;
            }
            return result;
        }
    }

    public static class ComputerBigIntCoerce
    implements Computer {
        private ExprNode[] childNodes;
        private SimpleNumberBigIntegerCoercer[] convertors;
        private boolean isMax;

        public ComputerBigIntCoerce(ExprNode[] childNodes, SimpleNumberBigIntegerCoercer[] convertors, boolean isMax) {
            this.childNodes = childNodes;
            this.convertors = convertors;
            this.isMax = isMax;
        }

        public Number execute(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Number valueChildOne = (Number)this.childNodes[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            Number valueChildTwo = (Number)this.childNodes[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (valueChildOne == null || valueChildTwo == null) {
                return null;
            }
            BigInteger bigIntOne = this.convertors[0].coerceBoxedBigInt(valueChildOne);
            BigInteger bigIntTwo = this.convertors[1].coerceBoxedBigInt(valueChildTwo);
            BigInteger result = this.isMax && bigIntOne.compareTo(bigIntTwo) > 0 || !this.isMax && bigIntOne.compareTo(bigIntTwo) < 0 ? bigIntOne : bigIntTwo;
            for (int i = 2; i < this.childNodes.length; ++i) {
                Number valueChild = (Number)this.childNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueChild == null) {
                    return null;
                }
                BigInteger bigInt = this.convertors[i].coerceBoxedBigInt(valueChild);
                if ((!this.isMax || result.compareTo(bigInt) >= 0) && (this.isMax || result.compareTo(bigInt) <= 0)) continue;
                result = bigInt;
            }
            return result;
        }
    }

    public static class MaxComputerDoubleCoerce
    implements Computer {
        private ExprNode[] childNodes;

        public MaxComputerDoubleCoerce(ExprNode[] childNodes) {
            this.childNodes = childNodes;
        }

        public Number execute(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Number valueChildOne = (Number)this.childNodes[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            Number valueChildTwo = (Number)this.childNodes[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (valueChildOne == null || valueChildTwo == null) {
                return null;
            }
            Number result = valueChildOne.doubleValue() > valueChildTwo.doubleValue() ? (Number)valueChildOne : (Number)valueChildTwo;
            for (int i = 2; i < this.childNodes.length; ++i) {
                Number valueChild = (Number)this.childNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueChild == null) {
                    return null;
                }
                if (!(valueChild.doubleValue() > result.doubleValue())) continue;
                result = valueChild;
            }
            return result;
        }
    }

    public static class MinComputerDoubleCoerce
    implements Computer {
        private ExprNode[] childNodes;

        public MinComputerDoubleCoerce(ExprNode[] childNodes) {
            this.childNodes = childNodes;
        }

        public Number execute(EventBean[] eventsPerStream, boolean isNewData, ExprEvaluatorContext exprEvaluatorContext) {
            Number valueChildOne = (Number)this.childNodes[0].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            Number valueChildTwo = (Number)this.childNodes[1].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
            if (valueChildOne == null || valueChildTwo == null) {
                return null;
            }
            Number result = valueChildOne.doubleValue() > valueChildTwo.doubleValue() ? (Number)valueChildTwo : (Number)valueChildOne;
            for (int i = 2; i < this.childNodes.length; ++i) {
                Number valueChild = (Number)this.childNodes[i].evaluate(eventsPerStream, isNewData, exprEvaluatorContext);
                if (valueChild == null) {
                    return null;
                }
                if (!(valueChild.doubleValue() < result.doubleValue())) continue;
                result = valueChild;
            }
            return result;
        }
    }

    public static interface Computer {
        public Number execute(EventBean[] var1, boolean var2, ExprEvaluatorContext var3);
    }
}

