/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.client.annotation.Hook;
import com.espertech.esper.client.annotation.HookType;
import com.espertech.esper.epl.core.EngineImportException;
import com.espertech.esper.epl.core.EngineImportService;
import com.espertech.esper.epl.core.MethodResolutionService;
import com.espertech.esper.epl.expression.ExprValidationException;
import com.espertech.esper.event.EventAdapterException;
import com.espertech.esper.type.BoolValue;
import com.espertech.esper.type.ByteValue;
import com.espertech.esper.type.DoubleValue;
import com.espertech.esper.type.FloatValue;
import com.espertech.esper.type.IntValue;
import com.espertech.esper.type.LongValue;
import com.espertech.esper.type.ShortValue;
import com.espertech.esper.util.ClassInstantiationException;
import com.espertech.esper.util.CoercionException;
import com.espertech.esper.util.MethodResolver;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaClassHelper {
    public static Class getBoxedType(Class clazz) {
        if (clazz == null) {
            return clazz;
        }
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        return clazz;
    }

    public static String getParameterAsString(Class[] parameters) {
        StringBuilder builder = new StringBuilder();
        String delimiterComma = ", ";
        String delimiter = "";
        for (Class param : parameters) {
            builder.append(delimiter);
            builder.append(JavaClassHelper.getParameterAsString(param));
            delimiter = delimiterComma;
        }
        return builder.toString();
    }

    public static String getParameterAsString(Class param) {
        if (param == null) {
            return "null (any type)";
        }
        return param.getSimpleName();
    }

    public static Class getPrimitiveType(Class clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        return clazz;
    }

    public static boolean isNumeric(Class clazz) {
        return clazz == Double.class || clazz == Double.TYPE || clazz == BigDecimal.class || clazz == BigInteger.class || clazz == Float.class || clazz == Float.TYPE || clazz == Short.class || clazz == Short.TYPE || clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Byte.class || clazz == Byte.TYPE;
    }

    public static boolean isNumericNonFP(Class clazz) {
        return clazz == Short.class || clazz == Short.TYPE || clazz == Integer.class || clazz == Integer.TYPE || clazz == Long.class || clazz == Long.TYPE || clazz == Byte.class || clazz == Byte.TYPE;
    }

    public static boolean isAssignmentCompatible(Class invocationType, Class declarationType) {
        Class parameterWrapperClazz;
        if (invocationType == null) {
            return true;
        }
        if (declarationType.isAssignableFrom(invocationType)) {
            return true;
        }
        if (declarationType.isPrimitive() && (parameterWrapperClazz = JavaClassHelper.getBoxedType(declarationType)) != null && parameterWrapperClazz.equals(invocationType)) {
            return true;
        }
        if (JavaClassHelper.getBoxedType(invocationType) == declarationType) {
            return true;
        }
        Set<Class> widenings = MethodResolver.getWideningConversions().get(declarationType);
        if (widenings != null) {
            return widenings.contains(invocationType);
        }
        if (declarationType.isInterface() && JavaClassHelper.isImplementsInterface(invocationType, declarationType)) {
            return true;
        }
        return JavaClassHelper.recursiveIsSuperClass(invocationType, declarationType);
    }

    public static boolean isBoolean(Class clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }

    public static Class getArithmaticCoercionType(Class typeOne, Class typeTwo) throws CoercionException {
        Class boxedOne = JavaClassHelper.getBoxedType(typeOne);
        Class boxedTwo = JavaClassHelper.getBoxedType(typeTwo);
        if (!JavaClassHelper.isNumeric(boxedOne) || !JavaClassHelper.isNumeric(boxedTwo)) {
            throw new CoercionException("Cannot coerce types " + typeOne.getName() + " and " + typeTwo.getName());
        }
        if (boxedOne == boxedTwo) {
            return boxedOne;
        }
        if (boxedOne == BigDecimal.class || boxedTwo == BigDecimal.class) {
            return BigDecimal.class;
        }
        if (boxedOne == BigInteger.class && JavaClassHelper.isFloatingPointClass(boxedTwo) || boxedTwo == BigInteger.class && JavaClassHelper.isFloatingPointClass(boxedOne)) {
            return BigDecimal.class;
        }
        if (boxedOne == BigInteger.class || boxedTwo == BigInteger.class) {
            return BigInteger.class;
        }
        if (boxedOne == Double.class || boxedTwo == Double.class) {
            return Double.class;
        }
        if (boxedOne == Float.class && !JavaClassHelper.isFloatingPointClass(typeTwo)) {
            return Double.class;
        }
        if (boxedTwo == Float.class && !JavaClassHelper.isFloatingPointClass(typeOne)) {
            return Double.class;
        }
        if (boxedOne == Long.class || boxedTwo == Long.class) {
            return Long.class;
        }
        return Integer.class;
    }

    public static Number coerceBoxed(Number numToCoerce, Class resultBoxedType) {
        if (numToCoerce.getClass() == resultBoxedType) {
            return numToCoerce;
        }
        if (resultBoxedType == Double.class) {
            return numToCoerce.doubleValue();
        }
        if (resultBoxedType == Long.class) {
            return numToCoerce.longValue();
        }
        if (resultBoxedType == BigInteger.class) {
            return BigInteger.valueOf(numToCoerce.longValue());
        }
        if (resultBoxedType == BigDecimal.class) {
            if (JavaClassHelper.isFloatingPointNumber(numToCoerce)) {
                return new BigDecimal(numToCoerce.doubleValue());
            }
            return new BigDecimal(numToCoerce.longValue());
        }
        if (resultBoxedType == Float.class) {
            return Float.valueOf(numToCoerce.floatValue());
        }
        if (resultBoxedType == Integer.class) {
            return numToCoerce.intValue();
        }
        if (resultBoxedType == Short.class) {
            return numToCoerce.shortValue();
        }
        if (resultBoxedType == Byte.class) {
            return numToCoerce.byteValue();
        }
        throw new IllegalArgumentException("Cannot coerce to number subtype " + resultBoxedType.getName());
    }

    public static boolean isFloatingPointNumber(Number number) {
        return number instanceof Float || number instanceof Double;
    }

    public static boolean isFloatingPointClass(Class clazz) {
        return clazz == Float.class || clazz == Double.class || clazz == Float.TYPE || clazz == Double.TYPE;
    }

    public static Class getCompareToCoercionType(Class typeOne, Class typeTwo) throws CoercionException {
        if (typeOne == String.class && typeTwo == String.class) {
            return String.class;
        }
        if (!(typeOne != Boolean.TYPE && typeOne != Boolean.class || typeTwo != Boolean.TYPE && typeTwo != Boolean.class)) {
            return Boolean.class;
        }
        if (!JavaClassHelper.isJavaBuiltinDataType(typeOne) && !JavaClassHelper.isJavaBuiltinDataType(typeTwo)) {
            if (typeOne != typeTwo) {
                return Object.class;
            }
            return typeOne;
        }
        if (!JavaClassHelper.isNumeric(typeOne) || !JavaClassHelper.isNumeric(typeTwo)) {
            throw new CoercionException("Types cannot be compared: " + typeOne.getName() + " and " + typeTwo.getName());
        }
        return JavaClassHelper.getArithmaticCoercionType(typeOne, typeTwo);
    }

    public static boolean isBigNumberType(Class clazz) {
        return clazz == BigInteger.class || clazz == BigDecimal.class;
    }

    public static boolean canCoerce(Class numberClassToBeCoerced, Class numberClassToCoerceTo) {
        Class boxedFrom = JavaClassHelper.getBoxedType(numberClassToBeCoerced);
        Class boxedTo = JavaClassHelper.getBoxedType(numberClassToCoerceTo);
        if (!JavaClassHelper.isNumeric(numberClassToBeCoerced)) {
            throw new IllegalArgumentException("Class '" + numberClassToBeCoerced + "' is not a numeric type'");
        }
        if (boxedTo == Float.class) {
            return boxedFrom == Byte.class || boxedFrom == Short.class || boxedFrom == Integer.class || boxedFrom == Long.class || boxedFrom == Float.class;
        }
        if (boxedTo == Double.class) {
            return boxedFrom == Byte.class || boxedFrom == Short.class || boxedFrom == Integer.class || boxedFrom == Long.class || boxedFrom == Float.class || boxedFrom == Double.class;
        }
        if (boxedTo == BigDecimal.class) {
            return boxedFrom == Byte.class || boxedFrom == Short.class || boxedFrom == Integer.class || boxedFrom == Long.class || boxedFrom == Float.class || boxedFrom == Double.class || boxedFrom == BigInteger.class || boxedFrom == BigDecimal.class;
        }
        if (boxedTo == BigInteger.class) {
            return boxedFrom == Byte.class || boxedFrom == Short.class || boxedFrom == Integer.class || boxedFrom == Long.class || boxedFrom == BigInteger.class;
        }
        if (boxedTo == Long.class) {
            return boxedFrom == Byte.class || boxedFrom == Short.class || boxedFrom == Integer.class || boxedFrom == Long.class;
        }
        if (boxedTo == Integer.class || boxedTo == Short.class || boxedTo == Byte.class) {
            return boxedFrom == Byte.class || boxedFrom == Short.class || boxedFrom == Integer.class;
        }
        throw new IllegalArgumentException("Class '" + numberClassToCoerceTo + "' is not a numeric type'");
    }

    public static String getBoxedClassName(String className) {
        if (className.equals(Character.TYPE.getName())) {
            return Character.class.getName();
        }
        if (className.equals(Byte.TYPE.getName())) {
            return Byte.class.getName();
        }
        if (className.equals(Short.TYPE.getName())) {
            return Short.class.getName();
        }
        if (className.equals(Integer.TYPE.getName())) {
            return Integer.class.getName();
        }
        if (className.equals(Long.TYPE.getName())) {
            return Long.class.getName();
        }
        if (className.equals(Float.TYPE.getName())) {
            return Float.class.getName();
        }
        if (className.equals(Double.TYPE.getName())) {
            return Double.class.getName();
        }
        if (className.equals(Boolean.TYPE.getName())) {
            return Boolean.class.getName();
        }
        return className;
    }

    public static boolean isJavaBuiltinDataType(Class clazz) {
        if (clazz == null) {
            return true;
        }
        Class clazzBoxed = JavaClassHelper.getBoxedType(clazz);
        if (JavaClassHelper.isNumeric(clazzBoxed)) {
            return true;
        }
        if (JavaClassHelper.isBoolean(clazzBoxed)) {
            return true;
        }
        if (clazzBoxed.equals(String.class)) {
            return true;
        }
        if (clazzBoxed.equals(Character.TYPE) || clazzBoxed.equals(Character.class)) {
            return true;
        }
        return clazzBoxed.equals(Void.TYPE);
    }

    public static Class getCommonCoercionType(Class[] types) throws CoercionException {
        int i;
        if (types.length < 1) {
            throw new IllegalArgumentException("Unexpected zero length array");
        }
        if (types.length == 1) {
            return JavaClassHelper.getBoxedType(types[0]);
        }
        ArrayList<Class> nonNullTypes = new ArrayList<Class>();
        for (i = 0; i < types.length; ++i) {
            if (types[i] == null) continue;
            nonNullTypes.add(types[i]);
        }
        types = nonNullTypes.toArray(new Class[nonNullTypes.size()]);
        if (types.length == 0) {
            return null;
        }
        if (types.length == 1) {
            return JavaClassHelper.getBoxedType(types[0]);
        }
        if (types[0] == String.class) {
            for (i = 0; i < types.length; ++i) {
                if (types[i] == String.class) continue;
                throw new CoercionException("Cannot coerce to String type " + types[i].getName());
            }
            return String.class;
        }
        for (i = 0; i < types.length; ++i) {
            types[i] = JavaClassHelper.getBoxedType(types[i]);
        }
        if (types[0] == Boolean.class) {
            for (i = 0; i < types.length; ++i) {
                if (types[i] == Boolean.class) continue;
                throw new CoercionException("Cannot coerce to Boolean type " + types[i].getName());
            }
            return Boolean.class;
        }
        if (types[0] == Character.class) {
            for (Class type : types) {
                if (type == Character.class) continue;
                throw new CoercionException("Cannot coerce to Boolean type " + type.getName());
            }
            return Character.class;
        }
        boolean isAllBuiltinTypes = true;
        boolean isAllNumeric = true;
        for (Class type : types) {
            if (JavaClassHelper.isNumeric(type) || JavaClassHelper.isJavaBuiltinDataType(type)) continue;
            isAllBuiltinTypes = false;
        }
        if (!isAllBuiltinTypes) {
            for (Class type : types) {
                if (JavaClassHelper.isJavaBuiltinDataType(type)) {
                    throw new CoercionException("Cannot coerce to " + types[0].getName() + " type " + type.getName());
                }
                if (type == types[0]) continue;
                return Object.class;
            }
            return types[0];
        }
        if (!isAllNumeric) {
            throw new CoercionException("Cannot coerce to numeric type " + types[0].getName());
        }
        Class result = JavaClassHelper.getArithmaticCoercionType(types[0], types[1]);
        for (int count = 2; count < types.length; ++count) {
            result = JavaClassHelper.getArithmaticCoercionType(result, types[count]);
        }
        return result;
    }

    public static Class getClassForName(String className) throws ClassNotFoundException {
        if (className.equals(Boolean.TYPE.getName())) {
            return Boolean.TYPE;
        }
        if (className.equals(Character.TYPE.getName())) {
            return Character.TYPE;
        }
        if (className.equals(Double.TYPE.getName())) {
            return Double.TYPE;
        }
        if (className.equals(Float.TYPE.getName())) {
            return Float.TYPE;
        }
        if (className.equals(Byte.TYPE.getName())) {
            return Byte.TYPE;
        }
        if (className.equals(Short.TYPE.getName())) {
            return Short.TYPE;
        }
        if (className.equals(Integer.TYPE.getName())) {
            return Integer.TYPE;
        }
        if (className.equals(Long.TYPE.getName())) {
            return Long.TYPE;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return Class.forName(className, true, cl);
    }

    public static Class getClassForSimpleName(String className) throws EventAdapterException {
        if ("string".equals(className.toLowerCase().trim()) || "varchar".equals(className.toLowerCase().trim()) || "varchar2".equals(className.toLowerCase().trim())) {
            return String.class;
        }
        if ("integer".equals(className.toLowerCase().trim())) {
            return Integer.class;
        }
        if ("bool".equals(className.toLowerCase().trim())) {
            return Boolean.class;
        }
        if ("character".equals(className.toLowerCase().trim())) {
            return Character.class;
        }
        String boxedClassName = JavaClassHelper.getBoxedClassName(className.trim());
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return Class.forName(boxedClassName, true, cl);
        }
        catch (ClassNotFoundException ex) {
            boxedClassName = JavaClassHelper.getBoxedClassName(className.toLowerCase().trim());
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                return Class.forName(boxedClassName, true, cl);
            }
            catch (ClassNotFoundException ex2) {
                throw new EventAdapterException("Unable to load class '" + boxedClassName + "', class not found", ex2);
            }
        }
    }

    public static Class getPrimitiveClassForName(String typeName) {
        if ((typeName = typeName.toLowerCase()).equals("boolean")) {
            return Boolean.TYPE;
        }
        if (typeName.equals("char")) {
            return Character.TYPE;
        }
        if (typeName.equals("double")) {
            return Double.TYPE;
        }
        if (typeName.equals("float")) {
            return Float.TYPE;
        }
        if (typeName.equals("byte")) {
            return Byte.TYPE;
        }
        if (typeName.equals("short")) {
            return Short.TYPE;
        }
        if (typeName.equals("int")) {
            return Integer.TYPE;
        }
        if (typeName.equals("long")) {
            return Long.TYPE;
        }
        if (typeName.equals("string")) {
            return String.class;
        }
        return null;
    }

    public static Object parse(Class clazz, String text) {
        Class classBoxed = JavaClassHelper.getBoxedType(clazz);
        if (classBoxed == String.class) {
            return text;
        }
        if (classBoxed == Character.class) {
            return Character.valueOf(text.charAt(0));
        }
        if (classBoxed == Boolean.class) {
            return BoolValue.parseString(text.toLowerCase().trim());
        }
        if (classBoxed == Byte.class) {
            return ByteValue.parseString(text.trim());
        }
        if (classBoxed == Short.class) {
            return ShortValue.parseString(text.trim());
        }
        if (classBoxed == Long.class) {
            return LongValue.parseString(text.trim());
        }
        if (classBoxed == Float.class) {
            return Float.valueOf(FloatValue.parseString(text.trim()));
        }
        if (classBoxed == Double.class) {
            return DoubleValue.parseString(text.trim());
        }
        if (classBoxed == Integer.class) {
            return IntValue.parseString(text.trim());
        }
        return null;
    }

    public static boolean isImplementsInterface(Class clazz, Class interfaceClass) {
        if (!interfaceClass.isInterface()) {
            throw new IllegalArgumentException("Interface class passed in is not an interface");
        }
        boolean resultThisClass = JavaClassHelper.recursiveIsImplementsInterface(clazz, interfaceClass);
        if (resultThisClass) {
            return true;
        }
        return JavaClassHelper.recursiveSuperclassImplementsInterface(clazz, interfaceClass);
    }

    public static boolean isSubclassOrImplementsInterface(Class extendorOrImplementor, Class extendedOrImplemented) {
        if (extendorOrImplementor.equals(extendedOrImplemented)) {
            return true;
        }
        if (extendedOrImplemented.isInterface()) {
            return JavaClassHelper.recursiveIsImplementsInterface(extendorOrImplementor, extendedOrImplemented) || JavaClassHelper.recursiveSuperclassImplementsInterface(extendorOrImplementor, extendedOrImplemented);
        }
        return JavaClassHelper.recursiveIsSuperClass(extendorOrImplementor, extendedOrImplemented);
    }

    private static boolean recursiveIsSuperClass(Class clazz, Class superClass) {
        if (clazz == null) {
            return false;
        }
        if (clazz.isPrimitive()) {
            return false;
        }
        Class mySuperClass = clazz.getSuperclass();
        if (mySuperClass == superClass) {
            return true;
        }
        if (mySuperClass == Object.class) {
            return false;
        }
        return JavaClassHelper.recursiveIsSuperClass(mySuperClass, superClass);
    }

    private static boolean recursiveSuperclassImplementsInterface(Class clazz, Class interfaceClass) {
        Class superClass = clazz.getSuperclass();
        if (superClass == null || superClass == Object.class) {
            return false;
        }
        boolean result = JavaClassHelper.recursiveIsImplementsInterface(superClass, interfaceClass);
        if (result) {
            return result;
        }
        return JavaClassHelper.recursiveSuperclassImplementsInterface(superClass, interfaceClass);
    }

    private static boolean recursiveIsImplementsInterface(Class clazz, Class interfaceClass) {
        if (clazz == interfaceClass) {
            return true;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        if (interfaces == null) {
            return false;
        }
        for (Class<?> classToCheck : interfaces) {
            boolean result = JavaClassHelper.recursiveIsImplementsInterface(classToCheck, interfaceClass);
            if (!result) continue;
            return result;
        }
        return false;
    }

    public static Object instantiate(Class implementedOrExtendedClass, String className) throws ClassInstantiationException {
        Object obj;
        Class<?> clazz;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(className, true, cl);
        }
        catch (ClassNotFoundException ex) {
            throw new ClassInstantiationException("Unable to load class '" + className + "', class not found", ex);
        }
        if (!JavaClassHelper.isSubclassOrImplementsInterface(clazz, implementedOrExtendedClass)) {
            if (implementedOrExtendedClass.isInterface()) {
                throw new ClassInstantiationException("Class '" + className + "' does not implement interface '" + implementedOrExtendedClass.getName() + "'");
            }
            throw new ClassInstantiationException("Class '" + className + "' does not extend '" + implementedOrExtendedClass.getName() + "'");
        }
        try {
            obj = clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new ClassInstantiationException("Unable to instantiate from class '" + className + "' via default constructor", ex);
        }
        catch (IllegalAccessException ex) {
            throw new ClassInstantiationException("Illegal access when instantiating class '" + className + "' via default constructor", ex);
        }
        return obj;
    }

    public static void getSuper(Class clazz, Set<Class> result) {
        JavaClassHelper.getSuperInterfaces(clazz, result);
        JavaClassHelper.getSuperClasses(clazz, result);
    }

    public static boolean isSimpleNameFullyQualfied(String simpleClassName, String fullyQualifiedClassname) {
        return fullyQualifiedClassname.endsWith("." + simpleClassName) || fullyQualifiedClassname.equals(simpleClassName);
    }

    public static boolean isFragmentableType(Class propertyType) {
        if (propertyType == null) {
            return false;
        }
        if (propertyType.isArray()) {
            return JavaClassHelper.isFragmentableType(propertyType.getComponentType());
        }
        if (JavaClassHelper.isJavaBuiltinDataType(propertyType)) {
            return false;
        }
        if (propertyType.isEnum()) {
            return false;
        }
        if (JavaClassHelper.isImplementsInterface(propertyType, Map.class)) {
            return false;
        }
        if (propertyType == Node.class) {
            return false;
        }
        if (propertyType == NodeList.class) {
            return false;
        }
        if (propertyType == Object.class) {
            return false;
        }
        if (propertyType == Calendar.class) {
            return false;
        }
        return propertyType != Date.class;
    }

    private static void getSuperInterfaces(Class clazz, Set<Class> result) {
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            result.add(interfaces[i]);
            JavaClassHelper.getSuperInterfaces(interfaces[i], result);
        }
    }

    private static void getSuperClasses(Class clazz, Set<Class> result) {
        Class superClass = clazz.getSuperclass();
        if (superClass == null) {
            return;
        }
        result.add(superClass);
        JavaClassHelper.getSuper(superClass, result);
    }

    public static Class getGenericReturnType(Method method, Field field, boolean isAllowNull) {
        if (method == null) {
            return JavaClassHelper.getGenericFieldType(field, isAllowNull);
        }
        return JavaClassHelper.getGenericReturnType(method, isAllowNull);
    }

    public static Class getGenericReturnTypeMap(Method method, Field field, boolean isAllowNull) {
        if (method == null) {
            return JavaClassHelper.getGenericFieldTypeMap(field, isAllowNull);
        }
        return JavaClassHelper.getGenericReturnTypeMap(method, isAllowNull);
    }

    public static Class getGenericReturnType(Method method, boolean isAllowNull) {
        Type t = method.getGenericReturnType();
        Class result = JavaClassHelper.getGenericType(t, 0);
        if (!isAllowNull && result == null) {
            return Object.class;
        }
        return result;
    }

    public static Class getGenericReturnTypeMap(Method method, boolean isAllowNull) {
        Type t = method.getGenericReturnType();
        Class result = JavaClassHelper.getGenericType(t, 1);
        if (!isAllowNull && result == null) {
            return Object.class;
        }
        return result;
    }

    public static Class getGenericFieldType(Field field, boolean isAllowNull) {
        Type t = field.getGenericType();
        Class result = JavaClassHelper.getGenericType(t, 0);
        if (!isAllowNull && result == null) {
            return Object.class;
        }
        return result;
    }

    public static Class getGenericFieldTypeMap(Field field, boolean isAllowNull) {
        Type t = field.getGenericType();
        Class result = JavaClassHelper.getGenericType(t, 1);
        if (!isAllowNull && result == null) {
            return Object.class;
        }
        return result;
    }

    private static Class getGenericType(Type t, int index) {
        if (t == null) {
            return null;
        }
        if (!(t instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType ptype = (ParameterizedType)t;
        if (ptype.getActualTypeArguments() == null || ptype.getActualTypeArguments().length < index + 1) {
            return Object.class;
        }
        Type typeParam = ptype.getActualTypeArguments()[index];
        if (!(typeParam instanceof Class)) {
            return Object.class;
        }
        return (Class)typeParam;
    }

    public static Object getAnnotationHook(Annotation[] annotations, HookType hookType, Class interfaceExpected, MethodResolutionService resolution) throws ExprValidationException {
        Class clazz;
        Hook hook;
        if (annotations == null) {
            return null;
        }
        String hookClass = null;
        for (int i = 0; i < annotations.length; ++i) {
            if (!(annotations[i] instanceof Hook) || (hook = (Hook)annotations[i]).type() != hookType) continue;
            hookClass = hook.hook();
        }
        if (hookClass == null) {
            return null;
        }
        try {
            clazz = resolution.resolveClass(hookClass);
        }
        catch (EngineImportException e) {
            throw new ExprValidationException("Failed to resolve hook provider of hook type '" + (Object)((Object)hookType) + "' import '" + hookClass + "' :" + e.getMessage());
        }
        if (!JavaClassHelper.isImplementsInterface(clazz, interfaceExpected)) {
            throw new ExprValidationException("Hook provider for hook type '" + (Object)((Object)hookType) + "' " + "class '" + clazz.getName() + "' does not implement the required '" + interfaceExpected.getSimpleName() + "' interface");
        }
        try {
            hook = clazz.newInstance();
        }
        catch (Exception e) {
            throw new ExprValidationException("Failed to instantiate hook provider of hook type '" + (Object)((Object)hookType) + "' " + "class '" + clazz.getName() + "' :" + e.getMessage());
        }
        return hook;
    }

    public static Object resolveIdentAsEnumConst(String constant, MethodResolutionService methodResolutionService, EngineImportService engineImportService) throws ExprValidationException {
        Field field;
        Class clazz;
        int lastDotIndex = constant.lastIndexOf(46);
        if (lastDotIndex == -1) {
            return null;
        }
        String className = constant.substring(0, lastDotIndex);
        String constName = constant.substring(lastDotIndex + 1);
        try {
            clazz = engineImportService != null ? engineImportService.resolveClass(className) : methodResolutionService.resolveClass(className);
        }
        catch (EngineImportException e) {
            return null;
        }
        try {
            field = clazz.getField(constName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        int modifiers = field.getModifiers();
        if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
            try {
                return field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new ExprValidationException("Exception accessing field '" + field.getName() + "': " + e.getMessage(), e);
            }
        }
        return null;
    }
}

