/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.collection.MultiKeyUntyped;
import com.espertech.esper.util.MetaDefItem;
import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultiKeyComparator
implements Comparator<MultiKeyUntyped>,
MetaDefItem,
Serializable {
    private final boolean[] isDescendingValues;
    private static final long serialVersionUID = -5990983090238885417L;

    public MultiKeyComparator(boolean[] isDescendingValues) {
        this.isDescendingValues = isDescendingValues;
    }

    @Override
    public final int compare(MultiKeyUntyped firstValues, MultiKeyUntyped secondValues) {
        if (firstValues.size() != this.isDescendingValues.length || secondValues.size() != this.isDescendingValues.length) {
            throw new IllegalArgumentException("Incompatible size MultiKey sizes for comparison");
        }
        for (int i = 0; i < firstValues.size(); ++i) {
            boolean isDescending;
            Object valueTwo;
            Object valueOne = firstValues.get(i);
            int comparisonResult = MultiKeyComparator.compareValues(valueOne, valueTwo = secondValues.get(i), isDescending = this.isDescendingValues[i]);
            if (comparisonResult == 0) continue;
            return comparisonResult;
        }
        if (!firstValues.equals(secondValues)) {
            return -1;
        }
        return 0;
    }

    protected static int compareValues(Object valueOne, Object valueTwo, boolean isDescending) {
        if (valueOne == null || valueTwo == null) {
            if (valueOne == null && valueTwo == null) {
                return 0;
            }
            if (valueOne == null) {
                if (isDescending) {
                    return 1;
                }
                return -1;
            }
            if (isDescending) {
                return -1;
            }
            return 1;
        }
        if (!(valueOne instanceof Comparable)) {
            throw new ClassCastException("Cannot sort objects of type " + valueOne.getClass());
        }
        Comparable comparable1 = (Comparable)valueOne;
        if (isDescending) {
            return -1 * comparable1.compareTo(valueTwo);
        }
        return comparable1.compareTo(valueTwo);
    }

    public static int compareValuesCollated(Object valueOne, Object valueTwo, boolean isDescending, Collator collator) {
        if (valueOne == null || valueTwo == null) {
            if (valueOne == null && valueTwo == null) {
                return 0;
            }
            if (valueOne == null) {
                if (isDescending) {
                    return 1;
                }
                return -1;
            }
            if (isDescending) {
                return -1;
            }
            return 1;
        }
        if (isDescending) {
            return collator.compare(valueTwo, valueOne);
        }
        return collator.compare(valueOne, valueTwo);
    }
}

