/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.util;

import com.espertech.esper.type.BoolValue;
import com.espertech.esper.type.ByteValue;
import com.espertech.esper.type.DoubleValue;
import com.espertech.esper.type.FloatValue;
import com.espertech.esper.type.IntValue;
import com.espertech.esper.type.LongValue;
import com.espertech.esper.type.ShortValue;
import com.espertech.esper.util.JavaClassHelper;
import com.espertech.esper.util.SimpleTypeParser;

public class SimpleTypeParserFactory {
    public static SimpleTypeParser getParser(Class clazz) {
        Class classBoxed = JavaClassHelper.getBoxedType(clazz);
        if (classBoxed == String.class) {
            return new SimpleTypeParser(){

                public Object parse(String value) {
                    return value;
                }
            };
        }
        if (classBoxed == Character.class) {
            return new SimpleTypeParser(){

                public Object parse(String value) {
                    return Character.valueOf(value.charAt(0));
                }
            };
        }
        if (classBoxed == Boolean.class) {
            return new SimpleTypeParser(){

                public Object parse(String text) {
                    return BoolValue.parseString(text.toLowerCase().trim());
                }
            };
        }
        if (classBoxed == Byte.class) {
            return new SimpleTypeParser(){

                public Object parse(String text) {
                    return ByteValue.parseString(text.trim());
                }
            };
        }
        if (classBoxed == Short.class) {
            return new SimpleTypeParser(){

                public Object parse(String text) {
                    return ShortValue.parseString(text.trim());
                }
            };
        }
        if (classBoxed == Long.class) {
            return new SimpleTypeParser(){

                public Object parse(String text) {
                    return LongValue.parseString(text.trim());
                }
            };
        }
        if (classBoxed == Float.class) {
            return new SimpleTypeParser(){

                public Object parse(String text) {
                    return Float.valueOf(FloatValue.parseString(text.trim()));
                }
            };
        }
        if (classBoxed == Double.class) {
            return new SimpleTypeParser(){

                public Object parse(String text) {
                    return DoubleValue.parseString(text.trim());
                }
            };
        }
        if (classBoxed == Integer.class) {
            return new SimpleTypeParser(){

                public Object parse(String text) {
                    return IntValue.parseString(text.trim());
                }
            };
        }
        return null;
    }
}

