/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EPException;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.expression.ExprConstantNode;
import com.espertech.esper.view.ViewCapability;
import com.espertech.esper.view.ViewEnum;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.internal.PriorEventViewFactory;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewCapPriorEventAccess
implements ViewCapability {
    private Integer indexConstant;

    public ViewCapPriorEventAccess(Integer indexConstant) {
        this.indexConstant = indexConstant;
    }

    public Integer getIndexConstant() {
        return this.indexConstant;
    }

    @Override
    public boolean inspect(int streamNumber, List<ViewFactory> viewFactories, StatementContext statementContext) {
        String text;
        boolean unboundStream = viewFactories.isEmpty();
        for (ViewFactory viewFactory : viewFactories) {
            if (!(viewFactory instanceof PriorEventViewFactory)) continue;
            return true;
        }
        try {
            String namespace = ViewEnum.PRIOR_EVENT_VIEW.getNamespace();
            String name = ViewEnum.PRIOR_EVENT_VIEW.getName();
            ViewFactory factory = statementContext.getViewResolutionService().create(namespace, name);
            viewFactories.add(factory);
            ViewFactoryContext context = new ViewFactoryContext(statementContext, streamNumber, viewFactories.size() + 1, namespace, name);
            factory.setViewParameters(context, Arrays.asList(new ExprConstantNode(unboundStream)));
        }
        catch (ViewProcessingException ex) {
            text = "Exception creating prior event view factory";
            throw new EPException(text, ex);
        }
        catch (ViewParameterException ex) {
            text = "Exception creating prior event view factory";
            throw new EPException(text, ex);
        }
        return true;
    }

    @Override
    public boolean requiresChildViews() {
        return false;
    }

    @Override
    public boolean appliesToChildViews() {
        return false;
    }
}

