/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewEnum;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryContext;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.Viewable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewServiceHelper {
    private static final Log log = LogFactory.getLog(ViewServiceHelper.class);

    protected static void addMergeViews(List<ViewSpec> specifications) throws ViewProcessingException {
        ViewSpec lastView;
        ViewEnum viewEnum;
        if (log.isDebugEnabled()) {
            log.debug(".addMergeViews Incoming specifications=" + Arrays.toString(specifications.toArray()));
        }
        if (specifications.size() > 0 && (viewEnum = ViewEnum.forName((lastView = specifications.get(specifications.size() - 1)).getObjectNamespace(), lastView.getObjectName())) != null && viewEnum.getMergeView() != null) {
            throw new ViewProcessingException("Invalid use of the '" + lastView.getObjectNamespace() + ":" + lastView.getObjectName() + "' view, the view requires one or more child views to group, or consider using the group-by clause");
        }
        LinkedList<ViewSpec> mergeViewSpecs = new LinkedList<ViewSpec>();
        for (ViewSpec spec : specifications) {
            ViewEnum viewEnum2 = ViewEnum.forName(spec.getObjectNamespace(), spec.getObjectName());
            if (viewEnum2 == null || viewEnum2.getMergeView() == null) continue;
            ViewSpec mergeViewSpec = new ViewSpec(viewEnum2.getMergeView().getNamespace(), viewEnum2.getMergeView().getName(), spec.getObjectParameters());
            mergeViewSpecs.addFirst(mergeViewSpec);
        }
        specifications.addAll(mergeViewSpecs);
        if (log.isDebugEnabled()) {
            log.debug(".addMergeViews Outgoing specifications=" + Arrays.toString(specifications.toArray()));
        }
    }

    protected static List<View> instantiateChain(Viewable parentViewable, List<ViewFactory> viewFactories, StatementContext context) {
        LinkedList<View> newViews = new LinkedList<View>();
        Viewable parent = parentViewable;
        for (ViewFactory viewFactory : viewFactories) {
            View currentView = viewFactory.makeView(context);
            newViews.add(currentView);
            parent.addView(currentView);
            parent = currentView;
        }
        return newViews;
    }

    protected static List<View> removeChainLeafView(Viewable parentViewable, Viewable viewToRemove) {
        LinkedList<View> removedViews = new LinkedList<View>();
        if (viewToRemove.hasViews()) {
            return removedViews;
        }
        List<View> viewPath = ViewSupport.findDescendent(parentViewable, viewToRemove);
        if (viewPath == null) {
            String message = "Viewable not found when removing view " + viewToRemove;
            throw new IllegalArgumentException(message);
        }
        if (viewPath.isEmpty()) {
            boolean isViewRemoved = parentViewable.removeView((View)viewToRemove);
            if (!isViewRemoved) {
                String message = "Failed to remove immediate child view " + viewToRemove;
                log.fatal(".remove " + message);
                throw new IllegalStateException(message);
            }
            removedViews.add((View)viewToRemove);
            return removedViews;
        }
        View[] viewPathArray = viewPath.toArray(new View[viewPath.size()]);
        View currentView = (View)viewToRemove;
        for (int index = viewPathArray.length - 1; index >= 0; --index) {
            boolean isViewRemoved = viewPathArray[index].removeView(currentView);
            removedViews.add(currentView);
            if (!isViewRemoved) {
                String message = "Failed to remove view " + currentView;
                log.fatal(".remove " + message);
                throw new IllegalStateException(message);
            }
            if (viewPathArray[index].hasViews()) break;
            if (index == 0) {
                parentViewable.removeView(viewPathArray[0]);
                removedViews.add(viewPathArray[0]);
                continue;
            }
            currentView = viewPathArray[index];
        }
        return removedViews;
    }

    protected static Pair<Viewable, List<View>> matchExistingViews(Viewable rootViewable, List<ViewFactory> viewFactories) {
        boolean foundMatch;
        Viewable currentParent = rootViewable;
        LinkedList<View> matchedViewList = new LinkedList<View>();
        if (viewFactories.isEmpty()) {
            return new Pair<Viewable, List<View>>(rootViewable, new LinkedList());
        }
        block0: do {
            foundMatch = false;
            for (View childView : currentParent.getViews()) {
                ViewFactory currentFactory = viewFactories.get(0);
                if (!currentFactory.canReuse(childView)) continue;
                viewFactories.remove(0);
                currentParent = childView;
                foundMatch = true;
                matchedViewList.add(childView);
                continue block0;
            }
        } while (foundMatch && !viewFactories.isEmpty());
        return new Pair<Viewable, List<View>>(currentParent, matchedViewList);
    }

    public static List<ViewFactory> instantiateFactories(int streamNum, List<ViewSpec> viewSpecList, StatementContext statementContext) throws ViewProcessingException {
        ArrayList<ViewFactory> factoryChain = new ArrayList<ViewFactory>();
        int viewNum = 0;
        for (ViewSpec spec : viewSpecList) {
            ViewFactory viewFactory = statementContext.getViewResolutionService().create(spec.getObjectNamespace(), spec.getObjectName());
            factoryChain.add(viewFactory);
            try {
                ViewFactoryContext context = new ViewFactoryContext(statementContext, streamNum, viewNum, spec.getObjectNamespace(), spec.getObjectName());
                viewFactory.setViewParameters(context, spec.getObjectParameters());
            }
            catch (ViewParameterException e) {
                throw new ViewProcessingException("Error in view '" + spec.getObjectNamespace() + ':' + spec.getObjectName() + "', " + e.getMessage());
            }
            ++viewNum;
        }
        return factoryChain;
    }
}

