/*
 * Decompiled with CFR 0.152.
 */
package com.espertech.esper.view;

import com.espertech.esper.client.EventType;
import com.espertech.esper.collection.Pair;
import com.espertech.esper.core.StatementContext;
import com.espertech.esper.epl.spec.StreamSpecOptions;
import com.espertech.esper.epl.spec.ViewSpec;
import com.espertech.esper.view.DataWindowViewFactory;
import com.espertech.esper.view.EventStream;
import com.espertech.esper.view.InitializableView;
import com.espertech.esper.view.View;
import com.espertech.esper.view.ViewFactory;
import com.espertech.esper.view.ViewFactoryChain;
import com.espertech.esper.view.ViewParameterException;
import com.espertech.esper.view.ViewProcessingException;
import com.espertech.esper.view.ViewService;
import com.espertech.esper.view.ViewServiceHelper;
import com.espertech.esper.view.ViewSupport;
import com.espertech.esper.view.Viewable;
import com.espertech.esper.view.internal.IntersectViewFactory;
import com.espertech.esper.view.internal.UnionViewFactory;
import com.espertech.esper.view.std.GroupByViewFactory;
import com.espertech.esper.view.std.MergeViewFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ViewServiceImpl
implements ViewService {
    private static final Log log = LogFactory.getLog(ViewServiceImpl.class);

    @Override
    public ViewFactoryChain createFactories(int streamNum, EventType parentEventType, List<ViewSpec> viewSpecDefinitions, StreamSpecOptions options, StatementContext context) throws ViewProcessingException {
        ArrayList<ViewSpec> viewSpecList = new ArrayList<ViewSpec>(viewSpecDefinitions);
        ViewServiceHelper.addMergeViews(viewSpecList);
        List<ViewFactory> viewFactories = ViewServiceHelper.instantiateFactories(streamNum, viewSpecList, context);
        ViewFactory parentViewFactory = null;
        ArrayList<ViewFactory> attachedViewFactories = new ArrayList<ViewFactory>();
        for (int i = 0; i < viewFactories.size(); ++i) {
            ViewFactory factoryToAttach = viewFactories.get(i);
            try {
                factoryToAttach.attach(parentEventType, context, parentViewFactory, attachedViewFactories);
                attachedViewFactories.add(viewFactories.get(i));
                parentEventType = factoryToAttach.getEventType();
                continue;
            }
            catch (ViewParameterException ex) {
                String text = "Error attaching view to parent view";
                if (i == 0) {
                    text = "Error attaching view to event stream";
                }
                throw new ViewProcessingException(text + ": " + ex.getMessage(), ex);
            }
        }
        int dataWindowCount = 0;
        int firstNonDataWindowIndex = -1;
        for (int i = 0; i < viewFactories.size(); ++i) {
            ViewFactory factory = viewFactories.get(i);
            if (factory instanceof DataWindowViewFactory) {
                ++dataWindowCount;
                continue;
            }
            if (factory instanceof GroupByViewFactory || factory instanceof MergeViewFactory || firstNonDataWindowIndex != -1) continue;
            firstNonDataWindowIndex = i;
        }
        boolean isAllowMultipleExpiry = context.getConfigSnapshot().getEngineDefaults().getViewResources().isAllowMultipleExpiryPolicies();
        boolean isRetainIntersection = options.isRetainIntersection();
        boolean isRetainUnion = options.isRetainUnion();
        if (!isAllowMultipleExpiry && !isRetainUnion) {
            isRetainIntersection = true;
        }
        if ((isRetainUnion || isRetainIntersection) && dataWindowCount > 1) {
            viewFactories = this.getRetainViewFactories(parentEventType, viewFactories, isRetainUnion, context);
        }
        return new ViewFactoryChain(parentEventType, viewFactories);
    }

    private List<ViewFactory> getRetainViewFactories(EventType parentEventType, List<ViewFactory> viewFactories, boolean isUnion, StatementContext context) throws ViewProcessingException {
        DataWindowViewFactory retainPolicy;
        DataWindowViewFactory viewFactory;
        HashSet<Integer> groupByFactory = new HashSet<Integer>();
        HashSet<Integer> mergeFactory = new HashSet<Integer>();
        ArrayList<ViewFactory> derivedValueViews = new ArrayList<ViewFactory>();
        ArrayList<ViewFactory> dataWindowViews = new ArrayList<ViewFactory>();
        for (int i = 0; i < viewFactories.size(); ++i) {
            ViewFactory factory = viewFactories.get(i);
            if (factory instanceof GroupByViewFactory) {
                groupByFactory.add(i);
                continue;
            }
            if (factory instanceof MergeViewFactory) {
                mergeFactory.add(i);
                continue;
            }
            if (factory instanceof DataWindowViewFactory) {
                dataWindowViews.add(factory);
                continue;
            }
            derivedValueViews.add(factory);
        }
        if (groupByFactory.size() > 1) {
            throw new ViewProcessingException("Multiple group-by views are not allowed in conjuntion with multiple data windows");
        }
        if (!groupByFactory.isEmpty() && (Integer)groupByFactory.iterator().next() != 0) {
            throw new ViewProcessingException("The group-by view must occur in the first position in conjuntion with multiple data windows");
        }
        if (!groupByFactory.isEmpty() && (Integer)mergeFactory.iterator().next() != viewFactories.size() - 1) {
            throw new ViewProcessingException("The merge view cannot be used in conjuntion with multiple data windows");
        }
        GroupByViewFactory groupByViewFactory = null;
        MergeViewFactory mergeViewFactory = null;
        if (!groupByFactory.isEmpty()) {
            groupByViewFactory = (GroupByViewFactory)viewFactories.remove(0);
            mergeViewFactory = (MergeViewFactory)viewFactories.remove(viewFactories.size() - 1);
        }
        if (isUnion) {
            viewFactory = (UnionViewFactory)context.getViewResolutionService().create("internal", "union");
            ((UnionViewFactory)viewFactory).setParentEventType(parentEventType);
            ((UnionViewFactory)viewFactory).setViewFactories(dataWindowViews);
            retainPolicy = viewFactory;
        } else {
            viewFactory = (IntersectViewFactory)context.getViewResolutionService().create("internal", "intersect");
            ((IntersectViewFactory)viewFactory).setParentEventType(parentEventType);
            ((IntersectViewFactory)viewFactory).setViewFactories(dataWindowViews);
            retainPolicy = viewFactory;
        }
        ArrayList<ViewFactory> nonRetainViewFactories = new ArrayList<ViewFactory>();
        nonRetainViewFactories.add(retainPolicy);
        if (groupByViewFactory != null) {
            nonRetainViewFactories.add(0, groupByViewFactory);
            nonRetainViewFactories.addAll(derivedValueViews);
            nonRetainViewFactories.add(mergeViewFactory);
        } else {
            nonRetainViewFactories.addAll(derivedValueViews);
        }
        return nonRetainViewFactories;
    }

    @Override
    public Viewable createViews(Viewable eventStreamViewable, List<ViewFactory> viewFactories, StatementContext context) {
        Pair<Viewable, List<View>> resultPair = ViewServiceHelper.matchExistingViews(eventStreamViewable, viewFactories);
        Viewable parentViewable = resultPair.getFirst();
        if (viewFactories.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug(".createView No new views created, dumping stream ... " + eventStreamViewable);
                ViewSupport.dumpChildViews("EventStream ", eventStreamViewable);
            }
            return parentViewable;
        }
        List<View> views = ViewServiceHelper.instantiateChain(parentViewable, viewFactories, context);
        for (View view : views) {
            if (!(view instanceof InitializableView)) continue;
            InitializableView initView = (InitializableView)((Object)view);
            initView.initialize();
        }
        if (log.isDebugEnabled()) {
            log.debug(".createView New views created for stream, all views ... " + eventStreamViewable);
            ViewSupport.dumpChildViews("EventStream ", eventStreamViewable);
        }
        return views.get(views.size() - 1);
    }

    @Override
    public void remove(EventStream eventStream, Viewable viewToRemove) {
        if (viewToRemove.hasViews()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(".remove Views before the remove of view " + viewToRemove + ", for event stream " + eventStream);
            ViewSupport.dumpChildViews("EventStream ", eventStream);
        }
        ViewServiceHelper.removeChainLeafView(eventStream, viewToRemove);
        if (log.isDebugEnabled()) {
            log.debug(".remove Views after the remove, for event stream " + eventStream);
            ViewSupport.dumpChildViews("EventStream ", eventStream);
        }
    }
}

